/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.panels;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.InfernalFCPanel;
import com.InfernalFC.helpers.InventoryManager;
import com.InfernalFC.helpers.ResourceManager;
import com.InfernalFC.models.CmManData;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class CmManPanel
extends JPanel {
    @Inject
    private Provider<InfernalFCPanel> infernalFCPanel;
    private final InventoryManager inventoryManager;
    private final ResourceManager resourceManager;
    private JPanel cmButtonPanel = new JPanel();
    private JPanel itemPanel = new JPanel();
    private String color1;
    private String color2;
    private int cmMan = 3;
    private CmManData data;

    @Inject
    private CmManPanel(InfernalFCConfig config, CmManData data, ResourceManager resourceManager, InventoryManager inventoryManager) {
        this.resourceManager = resourceManager;
        this.inventoryManager = inventoryManager;
        this.data = data;
        this.color1 = "#" + Integer.toHexString(config.col1color().getRGB()).substring(2);
        this.color2 = "#" + Integer.toHexString(config.col2color().getRGB()).substring(2);
        for (int i = 3; i < 10; ++i) {
            this.cmButtonPanel.add((Component)this.createCmButton(i), "West");
        }
        this.setPreferredSize(new Dimension(200, 400));
        this.add((Component)this.cmButtonPanel, "North");
        this.add(this.createTitleLabel("Prep numbers"));
        this.itemPanel.setLayout(new GridLayout(0, 4));
        this.itemPanel.setPreferredSize(new Dimension(200, 100));
        this.setItemPanel();
        this.add(this.itemPanel);
        this.add(this.createTitleLabel("Roles"));
        this.add(this.createRoleButton("Surge 1"));
        this.add(this.createRoleButton("Surge 2"));
        this.add(this.createRoleButton("Prep"));
        this.add(this.createRoleButton("Chinner"));
        this.add(this.createRoleButton("Crosser"));
    }

    private JButton createCmButton(final int index) {
        final JButton label = new JButton(String.valueOf(index));
        label.setPreferredSize(new Dimension(26, 26));
        label.setFont(new Font("Arial", 0, 9));
        label.setFocusable(false);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    CmManPanel.this.cmMan = index;
                    CmManPanel.this.setItemPanel();
                }
            }
        });
        return label;
    }

    private JButton createRoleButton(final String role) {
        final JButton label = new JButton(role);
        label.setPreferredSize(new Dimension(200, 30));
        label.setFont(new Font("Arial", 0, 9));
        label.setFocusable(false);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ((InfernalFCPanel)((Object)CmManPanel.this.infernalFCPanel.get())).cmManRolePanel.setRole(role);
                    ((InfernalFCPanel)((Object)CmManPanel.this.infernalFCPanel.get())).SwitchPanel("cmmanrole");
                }
            }
        });
        return label;
    }

    private void setItemPanel() {
        try {
            String[][] cmManData = this.data.itemMapping.get(String.valueOf(this.cmMan));
            this.itemPanel.removeAll();
            for (String[] row : cmManData) {
                this.itemPanel.add(this.createItemLabel((String)Array.get(row, 0), (String)Array.get(row, 1)));
            }
            this.itemPanel.updateUI();
            this.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JLabel createItemLabel(String name, String quantity) {
        JLabel label = new JLabel();
        label.setToolTipText(name);
        label.setHorizontalAlignment(0);
        label.setBorder(BorderFactory.createLineBorder(ColorScheme.DARK_GRAY_COLOR, 2));
        label.setBackground(new Color(39, 25, 25));
        if (this.inventoryManager.HasItem(name)) {
            label.setOpaque(false);
        } else {
            label.setOpaque(true);
        }
        try {
            Runnable task = () -> {
                Icon icon = this.resourceManager.GetItemImage(name);
                label.setIcon(this.getLabeledIcon(icon, quantity));
            };
            Thread thread = new Thread(task);
            thread.start();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return label;
    }

    private Icon getLabeledIcon(Icon oldIcon, String text) {
        int w = oldIcon.getIconWidth();
        int h = oldIcon.getIconHeight();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        oldIcon.paintIcon(null, g2d, 0, 0);
        g2d.setPaint(Color.yellow);
        g2d.drawString(text, 0, 10);
        g2d.dispose();
        return new ImageIcon(img.getScaledInstance(w, h, 4));
    }

    private JLabel createTitleLabel(String title) {
        JLabel label = new JLabel(title, 0);
        label.setPreferredSize(new Dimension(200, 20));
        label.setForeground(Color.yellow);
        return label;
    }
}

