/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.helpers;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.InfernalFCPlugin;
import com.InfernalFC.helpers.MarkersManager;
import com.InfernalFC.models.ColorTileMarker;
import com.google.common.base.Strings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class GroundMarkerOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    @Inject
    private InfernalFCConfig config;
    @Inject
    private MarkersManager markersManager;
    private final InfernalFCPlugin plugin;
    private final Client client;

    @Inject
    private GroundMarkerOverlay(Client client, InfernalFCPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        Collection<ColorTileMarker> points = this.markersManager.getMarkers();
        if (points.isEmpty()) {
            return null;
        }
        BasicStroke stroke = new BasicStroke(1.0f);
        for (ColorTileMarker point : points) {
            WorldPoint worldPoint = point.getWorldPoint();
            if (worldPoint.getPlane() != this.client.getPlane()) continue;
            Color tileColor = point.getColor();
            this.drawTile(graphics, worldPoint, tileColor, point.getLabel(), stroke);
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color, @Nullable String label, Stroke borderStroke) {
        Point canvasTextLocation;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Stroke)borderStroke);
        }
        if (!Strings.isNullOrEmpty((String)label) && (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (String)label, (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasTextLocation, (String)label, (Color)color);
        }
    }
}

