/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC.helpers;

import com.InfernalFC.helpers.PointsEnum;
import com.InfernalFC.models.EventData;
import com.InfernalFC.models.PlayerData;
import com.InfernalFC.models.PointsData;
import com.InfernalFC.models.RankData;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DataManager {
    private static final String baseUrl = "https://infernal-osrs.com/api/";
    private RankData[] ranks;

    @Inject
    private DataManager() {
    }

    public PlayerData[] GetPlayerData(String searchString) {
        try {
            URL url = new URL("https://infernal-osrs.com/api/Members?active=1&_start=0&_end=10&Clan_id=1&username=" + URLEncoder.encode(searchString, StandardCharsets.UTF_8.toString()));
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            return (PlayerData[])new Gson().fromJson((Reader)reader, PlayerData[].class);
        }
        catch (Exception e) {
            System.out.println(e);
            return new PlayerData[0];
        }
    }

    public PlayerData[] GetAltData(int id) {
        try {
            URL url = new URL("https://infernal-osrs.com/api/Members?active=1&_start=0&_end=10&Clan_id=1&parentAccount=" + id);
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            return (PlayerData[])new Gson().fromJson((Reader)reader, PlayerData[].class);
        }
        catch (Exception e) {
            System.out.println(e);
            return new PlayerData[0];
        }
    }

    public PlayerData GetParentData(int id) {
        try {
            URL url = new URL("https://infernal-osrs.com/api/Members?active=1&_start=0&_end=10&Clan_id=1&id=" + id);
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            PlayerData[] result = (PlayerData[])new Gson().fromJson((Reader)reader, PlayerData[].class);
            return result[0];
        }
        catch (Exception e) {
            System.out.println(e);
            return new PlayerData();
        }
    }

    public RankData[] GetRankData() {
        if (this.ranks != null) {
            return this.ranks;
        }
        try {
            URL url = new URL("https://infernal-osrs.com/api/ranks?_start=0&_end=5000&Clan_id=1");
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            this.ranks = (RankData[])new Gson().fromJson((Reader)reader, RankData[].class);
            return this.ranks;
        }
        catch (Exception e) {
            System.out.println(e);
            return new RankData[0];
        }
    }

    public PointsData GetOverallPoints() {
        return this.GetPoints(PointsEnum.OVERALL);
    }

    public PointsData GetEhbPoints() {
        return this.GetPoints(PointsEnum.EHB);
    }

    public PointsData GetKcPoints() {
        return this.GetPoints(PointsEnum.KC);
    }

    public PointsData GetPetPoints() {
        return this.GetPoints(PointsEnum.PETS);
    }

    private PointsData GetPoints(PointsEnum score) {
        try {
            URL url;
            switch (score) {
                case EHB: {
                    url = new URL("https://infernal-osrs.com/api/Members/killcounts/ehb?_start=0&_end=1&Clan_id=1");
                    break;
                }
                case KC: {
                    url = new URL("https://infernal-osrs.com/api/Members/killcounts/overall?_start=0&_end=1&Clan_id=1");
                    break;
                }
                default: {
                    url = new URL("https://infernal-osrs.com/api/Members/points/overall?_start=0&_end=1&Clan_id=1");
                    break;
                }
                case PETS: {
                    url = new URL("https://infernal-osrs.com/api/Members/pets?_sort=count&_order=DESC&_start=0&_end=1&Clan_id=1");
                }
            }
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            PointsData[] pointsData = (PointsData[])new Gson().fromJson((Reader)reader, PointsData[].class);
            return pointsData[0];
        }
        catch (Exception e) {
            System.out.println(e);
            return new PointsData();
        }
    }

    public EventData[] GetEvents() {
        try {
            URL url = new URL("https://infernal-osrs.com/api/Events?_end=10&_order=DESC&_sort=date&_start=0&Clan_id=1");
            InputStream input = url.openStream();
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            EventData[] eventData = (EventData[])new Gson().fromJson((Reader)reader, EventData[].class);
            Date today = new Date();
            today.setHours(0);
            today.setMinutes(0);
            today.setSeconds(0);
            eventData = (EventData[])Arrays.stream(eventData).filter(x -> x.getDate().after(today)).toArray(EventData[]::new);
            this.invertArray(eventData);
            return eventData;
        }
        catch (Exception e) {
            System.out.println(e);
            return new EventData[0];
        }
    }

    private void invertArray(EventData[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            EventData temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }
}

