/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.InfernalFCOverlay;
import com.InfernalFC.InfernalFCPanel;
import com.InfernalFC.helpers.GroundMarkerOverlay;
import com.InfernalFC.helpers.MarkersManager;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Infernal", description="A plugin designed for clans to keep track of members/events & much more!", tags={"Infernal"})
public class InfernalFCPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InfernalFCPlugin.class);
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private Client client;
    @Inject
    private InfernalFCConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfernalFCOverlay overlay;
    @Inject
    private GroundMarkerOverlay groundMarkerOverlay;
    @Inject
    private MarkersManager markersManager;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientToolbar clientToolbar;
    private InfernalFCPanel panel;
    private NavigationButton uiNavigationButton;
    static final String CONFIG_GROUP = "InfernalFC";
    static final String LOOKUP = "Clan Check";
    static final int FRIENDS_CHAT = 9;
    static final int CLAN_CHAT = 41;
    private static final String KICK_OPTION = "Kick";
    private static final ImmutableList<String> AFTER_OPTIONS = ImmutableList.of((Object)"Message", (Object)"Add ignore", (Object)"Remove friend", (Object)"Delete", (Object)"Kick");

    protected void startUp() throws Exception {
        this.setOverLay();
        this.startClanPanel();
        this.overlayManager.add((Overlay)this.groundMarkerOverlay);
        if (this.config.menuOption() && this.client != null) {
            ((MenuManager)this.menuManager.get()).addPlayerMenuItem(LOOKUP);
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.groundMarkerOverlay);
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
        if (this.client != null) {
            ((MenuManager)this.menuManager.get()).removePlayerMenuItem(LOOKUP);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) throws IOException {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (event.getKey().equals("overlay")) {
                this.setOverLay();
            } else if (event.getKey().equals("col1color") || event.getKey().equals("col2color")) {
                this.panel.removeAll();
                this.clientToolbar.removeNavigation(this.uiNavigationButton);
                this.startClanPanel();
            }
            if (this.client != null) {
                ((MenuManager)this.menuManager.get()).removePlayerMenuItem(LOOKUP);
                if (this.config.menuOption()) {
                    ((MenuManager)this.menuManager.get()).addPlayerMenuItem(LOOKUP);
                }
            }
        }
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged event) {
        if (this.panel.getRanksPanel().isShowing() && event.getContainerId() == InventoryID.INVENTORY.getId()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.panel.getRanksPanel().updateItems());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.markersManager.loadPoints();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (!this.config.menuOption()) {
            return;
        }
        int groupId = WidgetInfo.TO_GROUP((int)event.getActionParam1());
        String option = event.getOption();
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() || groupId == WidgetInfo.CHATBOX.getGroupId() && !KICK_OPTION.equals(option) || groupId == WidgetInfo.RAIDING_PARTY.getGroupId() || groupId == WidgetInfo.PRIVATE_CHAT_MESSAGE.getGroupId() || groupId == WidgetInfo.IGNORE_LIST.getGroupId()) {
            if (!AFTER_OPTIONS.contains((Object)option) || option.equals("Delete") && groupId != WidgetInfo.IGNORE_LIST.getGroupId()) {
                return;
            }
            this.client.createMenuEntry(-1).setOption(LOOKUP).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier());
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if ((event.getMenuAction() == MenuAction.RUNELITE || event.getMenuAction() == MenuAction.RUNELITE_PLAYER) && event.getMenuOption().equals(LOOKUP)) {
            String target;
            if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER) {
                Player player = this.client.getCachedPlayers()[event.getId()];
                if (player == null) {
                    return;
                }
                target = player.getName();
            } else {
                target = Text.removeTags((String)event.getMenuTarget());
            }
            SwingUtilities.invokeLater(() -> {
                if (!this.uiNavigationButton.isSelected()) {
                    this.uiNavigationButton.getOnSelect().run();
                }
                this.panel.SwitchPanel("lookup");
                this.panel.getLookupPanel().SearchExact(target);
            });
        }
    }

    private void startClanPanel() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.panel = (InfernalFCPanel)((Object)this.injector.getInstance(InfernalFCPanel.class));
        this.uiNavigationButton = NavigationButton.builder().tooltip("Infernal").icon(icon).priority(7).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    private void setOverLay() {
        if (this.config.overlay()) {
            this.overlayManager.add((Overlay)this.overlay);
        } else {
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    @Provides
    InfernalFCConfig provideConfig(ConfigManager configManager) {
        return (InfernalFCConfig)configManager.getConfig(InfernalFCConfig.class);
    }

    InfernalFCPanel getPanel() {
        return this.panel;
    }

    void setPanel(InfernalFCPanel panel) {
        this.panel = panel;
    }
}

