/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC;

import com.InfernalFC.components.combobox.ComboBoxIconEntry;
import com.InfernalFC.components.combobox.ComboBoxIconListRenderer;
import com.InfernalFC.helpers.DataManager;
import com.InfernalFC.panels.CmManPanel;
import com.InfernalFC.panels.CmManRolePanel;
import com.InfernalFC.panels.HomePanel;
import com.InfernalFC.panels.LookupPanel;
import com.InfernalFC.panels.RanksPanel;
import com.InfernalFC.panels.TobSpecPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InfernalFCPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(InfernalFCPanel.class);
    final JComboBox<ComboBoxIconEntry> dropdown = new JComboBox();
    private final HomePanel homePanel;
    private final CmManPanel cmManPanel;
    public final CmManRolePanel cmManRolePanel;
    private final RanksPanel ranksPanel;
    private final LookupPanel lookupPanel;
    private final TobSpecPanel tobSpecPanel;
    private String tab;

    @Inject
    private InfernalFCPanel(CmManPanel cmManPanel, CmManRolePanel cmManRolePanel, HomePanel homePanel, DataManager dataManager, RanksPanel ranksPanel, LookupPanel lookupPanel, TobSpecPanel tobSpecPanel) {
        this.homePanel = homePanel;
        this.cmManPanel = cmManPanel;
        this.cmManRolePanel = cmManRolePanel;
        this.ranksPanel = ranksPanel;
        this.lookupPanel = lookupPanel;
        this.tobSpecPanel = tobSpecPanel;
        int index = 0;
        this.dropdown.setFocusable(false);
        this.dropdown.setForeground(Color.WHITE);
        ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
        this.dropdown.setRenderer(renderer);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"home.png");
        this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Home", "home"));
        icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Lookup_icon.png");
        this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Player Lookup", "lookup"));
        icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"Requirement_icon.png");
        this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " Requirements", "ranks"));
        icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"cm.png");
        this.dropdown.addItem(new ComboBoxIconEntry(new ImageIcon(icon), " CM Meta", "cmman"));
        this.dropdown.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                ComboBoxIconEntry source = (ComboBoxIconEntry)e.getItem();
                this.tab = source.getData().toString();
                this.SwitchPanel(this.tab);
            }
        });
        this.dropdown.setSelectedIndex(index);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add(this.dropdown, c);
        ++c.gridy;
        homePanel.setSize(new Dimension(200, 700));
        cmManPanel.setSize(new Dimension(200, 700));
        lookupPanel.setSize(new Dimension(200, 700));
        ranksPanel.setSize(new Dimension(200, 700));
        tobSpecPanel.setSize(new Dimension(200, 700));
        this.dropdown.setSelectedIndex(-1);
        this.dropdown.setSelectedIndex(0);
        Runnable task = dataManager::GetRankData;
        Thread thread = new Thread(task);
        thread.start();
    }

    public void SwitchPanel(String tab) {
        this.removeAll();
        this.add(this.dropdown);
        switch (tab) {
            case "home": {
                this.add(this.getHomePanel());
                this.getHomePanel().Load();
                break;
            }
            case "cmman": {
                this.add(this.getCmManPanel());
                break;
            }
            case "cmmanrole": {
                this.add(this.getCmManRolePanel());
                break;
            }
            case "lookup": {
                this.add(this.getLookupPanel());
                break;
            }
            case "ranks": {
                this.add(this.getRanksPanel());
                this.getRanksPanel().rankChange("Trial");
                break;
            }
            case "Tob": {
                this.add(this.getTobSpecPanel());
            }
        }
        this.updateUI();
    }

    public HomePanel getHomePanel() {
        return this.homePanel;
    }

    public CmManPanel getCmManPanel() {
        return this.cmManPanel;
    }

    public CmManRolePanel getCmManRolePanel() {
        return this.cmManRolePanel;
    }

    public RanksPanel getRanksPanel() {
        return this.ranksPanel;
    }

    public LookupPanel getLookupPanel() {
        return this.lookupPanel;
    }

    public TobSpecPanel getTobSpecPanel() {
        return this.tobSpecPanel;
    }
}

