/*
 * Decompiled with CFR 0.152.
 */
package com.InfernalFC;

import com.InfernalFC.InfernalFCConfig;
import com.InfernalFC.InfernalFCPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class InfernalFCOverlay
extends OverlayPanel {
    private final Client client;
    private final InfernalFCPlugin plugin;
    @Inject
    private InfernalFCConfig config;

    @Inject
    private InfernalFCOverlay(Client client, InfernalFCPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.client = client;
        this.plugin = plugin;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Event overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        Object text = this.config.eventPass();
        if (this.config.dtm()) {
            text = (String)text + " " + InfernalFCOverlay.localToGMT();
        }
        if (!((String)text).equals(" ") && !((String)text).equals("  ")) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text((String)text).color(this.config.passColor()).build());
            this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth((String)text) + 10, 0));
        }
        return super.render(graphics);
    }

    public static String localToGMT() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date) + " UTC";
    }
}

