/*
 * Decompiled with CFR 0.152.
 */
package com.profittracker;

import com.google.inject.Provides;
import com.profittracker.ProfitTrackerConfig;
import com.profittracker.ProfitTrackerGoldDrops;
import com.profittracker.ProfitTrackerInventoryValue;
import com.profittracker.ProfitTrackerOverlay;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Profit Tracker")
public class ProfitTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ProfitTrackerPlugin.class);
    ProfitTrackerGoldDrops goldDropsObject;
    ProfitTrackerInventoryValue inventoryValueObject;
    private long prevInventoryValue;
    private long totalProfit;
    private long startTickMillis;
    private boolean skipTickForProfitCalculation;
    private boolean inventoryValueChanged;
    private boolean inProfitTrackSession;
    private boolean runePouchContentsChanged;
    private int[] RUNE_POUCH_VARBITS = new int[]{1624, 1625, 1626, 14286, 29, 1622, 1623, 14285};
    @Inject
    private Client client;
    @Inject
    private ProfitTrackerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ProfitTrackerOverlay overlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.goldDropsObject = new ProfitTrackerGoldDrops(this.client, this.itemManager);
        this.inventoryValueObject = new ProfitTrackerInventoryValue(this.client, this.itemManager);
        this.initializeVariables();
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.startProfitTrackingSession();
        }
    }

    private void initializeVariables() {
        this.prevInventoryValue = -1L;
        this.totalProfit = 0L;
        this.startTickMillis = 0L;
        this.skipTickForProfitCalculation = true;
        this.inventoryValueChanged = false;
        this.inProfitTrackSession = false;
        this.runePouchContentsChanged = false;
    }

    private void startProfitTrackingSession() {
        this.initializeVariables();
        this.startTickMillis = System.currentTimeMillis();
        this.overlay.updateStartTimeMillies(this.startTickMillis);
        this.overlay.startSession();
        this.inProfitTrackSession = true;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.inProfitTrackSession) {
            return;
        }
        if (this.inventoryValueChanged || this.runePouchContentsChanged) {
            long tickProfit = this.calculateTickProfit();
            this.totalProfit += tickProfit;
            this.overlay.updateProfitValue(this.totalProfit);
            if (this.config.goldDrops() && tickProfit != 0L) {
                this.goldDropsObject.requestGoldDrop(tickProfit);
            }
            this.inventoryValueChanged = false;
            this.runePouchContentsChanged = false;
        }
    }

    private long calculateTickProfit() {
        long newProfit;
        long newInventoryValue = this.inventoryValueObject.calculateInventoryAndEquipmentValue();
        if (!this.skipTickForProfitCalculation) {
            newProfit = newInventoryValue - this.prevInventoryValue;
        } else {
            log.debug("Skipping profit calculation!");
            this.skipTickForProfitCalculation = false;
            newProfit = 0L;
        }
        this.prevInventoryValue = newInventoryValue;
        return newProfit;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        log.debug("onItemContainerChanged container id: " + event.getContainerId());
        int containerId = event.getContainerId();
        if (containerId == InventoryID.INVENTORY.getId() || containerId == InventoryID.EQUIPMENT.getId()) {
            this.inventoryValueChanged = true;
        }
        if (containerId == InventoryID.BANK.getId()) {
            this.skipTickForProfitCalculation = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.runePouchContentsChanged = Arrays.stream(this.RUNE_POUCH_VARBITS).anyMatch(vb -> event.getVarbitId() == vb);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        log.debug(String.format("Click! ID: %d ,menuOption: %s, menuTarget: %s", event.getId(), event.getMenuOption(), event.getMenuTarget()));
        if (event.getId() == 10529 || event.getId() == 43696 || event.getId() == 10530) {
            this.skipTickForProfitCalculation = true;
        }
    }

    @Provides
    ProfitTrackerConfig provideConfig(ConfigManager configManager) {
        return (ProfitTrackerConfig)configManager.getConfig(ProfitTrackerConfig.class);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        this.goldDropsObject.onScriptPreFired(scriptPreFired);
    }
}

