/*
 * Decompiled with CFR 0.152.
 */
package com.profittracker;

import com.profittracker.ProfitTrackerConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ProfitTrackerOverlay
extends Overlay {
    private long profitValue;
    private long startTimeMillies;
    private boolean inProfitTrackSession;
    private final ProfitTrackerConfig ptConfig;
    private final PanelComponent panelComponent = new PanelComponent();

    public static String FormatIntegerWithCommas(long value) {
        DecimalFormat df = new DecimalFormat("###,###,###");
        return df.format(value);
    }

    @Inject
    private ProfitTrackerOverlay(ProfitTrackerConfig config) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.profitValue = 0L;
        this.ptConfig = config;
        this.startTimeMillies = 0L;
        this.inProfitTrackSession = false;
    }

    public Dimension render(Graphics2D graphics) {
        String titleText = "Profit Tracker:";
        long secondsElapsed = this.startTimeMillies > 0L ? (System.currentTimeMillis() - this.startTimeMillies) / 1000L : 0L;
        long profitRateValue = ProfitTrackerOverlay.calculateProfitHourly(secondsElapsed, this.profitValue);
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(TitleComponent.builder().text(titleText).color(Color.GREEN).build());
        if (!this.inProfitTrackSession) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Reset plugin to start").color(Color.RED).build());
        }
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(titleText) + 40, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").right(ProfitTrackerOverlay.formatTimeIntervalFromSec(secondsElapsed)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Profit:").right(ProfitTrackerOverlay.FormatIntegerWithCommas(this.profitValue)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Rate:").right(profitRateValue + "K/H").build());
        return this.panelComponent.render(graphics);
    }

    public void updateProfitValue(long newValue) {
        SwingUtilities.invokeLater(() -> {
            this.profitValue = newValue;
        });
    }

    public void updateStartTimeMillies(long newValue) {
        SwingUtilities.invokeLater(() -> {
            this.startTimeMillies = newValue;
        });
    }

    public void startSession() {
        SwingUtilities.invokeLater(() -> {
            this.inProfitTrackSession = true;
        });
    }

    private static String formatTimeIntervalFromSec(long totalSecElapsed) {
        long sec = totalSecElapsed % 60L;
        long min = totalSecElapsed / 60L % 60L;
        long hr = totalSecElapsed / 3600L;
        return String.format("%02d:%02d:%02d", hr, min, sec);
    }

    static long calculateProfitHourly(long secondsElapsed, long profit) {
        long averageProfitForSecond = secondsElapsed > 0L ? profit / secondsElapsed : 0L;
        long averageProfitThousandForHour = averageProfitForSecond * 3600L / 1000L;
        return averageProfitThousandForHour;
    }
}

