/*
 * Decompiled with CFR 0.152.
 */
package com.profittracker;

import java.util.Arrays;
import java.util.stream.LongStream;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfitTrackerInventoryValue {
    private static final Logger log = LoggerFactory.getLogger(ProfitTrackerInventoryValue.class);
    static final int EMPTY_SLOT_ITEMID = -1;
    private final int[] RUNE_POUCH_ITEM_IDS = new int[]{12791, 24416, 27281, 27509};
    private final int[] RUNE_POUCH_AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
    private final int[] RUNE_POUCH_RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
    private final ItemManager itemManager;
    private final Client client;

    public ProfitTrackerInventoryValue(Client client, ItemManager itemManager) {
        this.client = client;
        this.itemManager = itemManager;
    }

    private long calculateItemValue(Item item) {
        int itemId = item.getId();
        if (itemId < -1) {
            log.debug("Bad item id!" + itemId);
            return 0L;
        }
        if (itemId == -1) {
            return 0L;
        }
        if (Arrays.stream(this.RUNE_POUCH_ITEM_IDS).anyMatch(pouchID -> itemId == pouchID)) {
            log.debug(String.format("calculateItemValue itemId = %d (Rune pouch variant)", itemId));
            return this.calculateRunePouchValue();
        }
        log.debug(String.format("calculateItemValue itemId = %d", itemId));
        return item.getQuantity() * this.itemManager.getItemPrice(itemId);
    }

    public long calculateContainerValue(InventoryID ContainerID) {
        ItemContainer container = this.client.getItemContainer(ContainerID);
        if (container == null) {
            return 0L;
        }
        Item[] items = container.getItems();
        long newInventoryValue = Arrays.stream(items).flatMapToLong(item -> LongStream.of(this.calculateItemValue((Item)item))).sum();
        return newInventoryValue;
    }

    public long calculateInventoryValue() {
        return this.calculateContainerValue(InventoryID.INVENTORY);
    }

    public long calculateEquipmentValue() {
        return this.calculateContainerValue(InventoryID.EQUIPMENT);
    }

    public long calculateRunePouchValue() {
        long runePouchValue = 0L;
        EnumComposition runePouchEnum = this.client.getEnum(982);
        for (int i = 0; i < this.RUNE_POUCH_AMOUNT_VARBITS.length; ++i) {
            runePouchValue += this.calculateRuneValue(this.client.getVarbitValue(this.RUNE_POUCH_RUNE_VARBITS[i]), this.client.getVarbitValue(this.RUNE_POUCH_AMOUNT_VARBITS[i]), runePouchEnum);
        }
        return runePouchValue;
    }

    public long calculateRuneValue(int runeId, int runeQuantity, EnumComposition runePouchEnum) {
        if (runeQuantity == 0) {
            return 0L;
        }
        log.debug(String.format("calculateRuneValue runeId = %d", runeId));
        return this.itemManager.getItemPrice(runePouchEnum.getIntValue(runeId)) * runeQuantity;
    }

    public long calculateInventoryAndEquipmentValue() {
        return this.calculateInventoryValue() + this.calculateEquipmentValue();
    }
}

