/*
 * Decompiled with CFR 0.152.
 */
package com.profittracker;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.Skill;
import net.runelite.api.SpritePixels;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfitTrackerGoldDrops {
    private static final Logger log = LoggerFactory.getLogger(ProfitTrackerGoldDrops.class);
    private static final int COINS_SPRITE_ID = -1337;
    private static final int XPDROP_SKILL = Skill.FISHING.ordinal();
    private static final int XPDROP_VALUE = 6;
    private final ItemManager itemManager;
    private final Client client;
    private long currentGoldDropValue;

    ProfitTrackerGoldDrops(Client client, ItemManager itemManager) {
        this.client = client;
        this.itemManager = itemManager;
        this.prepareCoinSprite();
        this.currentGoldDropValue = 0L;
    }

    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() != 996) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        int widgetId = intStack[intStackSize - 4];
        boolean isThisGoldDrop = this.currentGoldDropValue != 0L;
        long goldDropValue = this.currentGoldDropValue;
        this.currentGoldDropValue = 0L;
        this.handleXpDrop(widgetId, isThisGoldDrop, goldDropValue);
    }

    private void handleXpDrop(int xpDropWidgetId, boolean isThisGoldDrop, long goldDropValue) {
        Widget xpDropWidget = this.client.getWidget(WidgetInfo.TO_GROUP((int)xpDropWidgetId), WidgetInfo.TO_CHILD((int)xpDropWidgetId));
        if (xpDropWidget == null) {
            log.error("xpDropWidget was null");
            return;
        }
        Widget[] xpDropWidgetChildren = xpDropWidget.getChildren();
        if (xpDropWidgetChildren.length < 1) {
            log.error(String.format("Unexpected xpDropWidgets length! %d", xpDropWidgetChildren.length));
            return;
        }
        Widget dropTextWidget = xpDropWidgetChildren[0];
        if (isThisGoldDrop) {
            if (xpDropWidgetChildren.length < 2) {
                log.error(String.format("Unexpected xpDropWidgetChildren length for a gold drop! length! %d", xpDropWidgetChildren.length));
                return;
            }
            Widget dropSpriteWidget = xpDropWidgetChildren[1];
            this.xpDropToGoldDrop(dropTextWidget, dropSpriteWidget, goldDropValue);
        } else {
            this.resetXpDropTextColor(dropTextWidget);
        }
    }

    private void xpDropToGoldDrop(Widget dropTextWidget, Widget dropSpriteWidget, long goldDropValue) {
        dropTextWidget.setText(this.formatGoldDropText(goldDropValue));
        if (goldDropValue > 0L) {
            dropTextWidget.setTextColor(Color.GREEN.getRGB());
        } else {
            dropTextWidget.setTextColor(Color.RED.getRGB());
        }
        dropSpriteWidget.setSpriteId(-1337);
    }

    private void prepareCoinSprite() {
        AsyncBufferedImage coin_image_raw = this.itemManager.getImage(995, 10000, false);
        coin_image_raw.onLoaded(() -> {
            SpritePixels coin_sprite = ImageUtil.getImageSpritePixels((BufferedImage)coin_image_raw, (Client)this.client);
            this.client.getSpriteOverrides().put(-1337, coin_sprite);
        });
    }

    public void requestGoldDrop(long amount) {
        log.debug(String.format("goldDrop: %d", amount));
        this.currentGoldDropValue = amount;
        this.client.runScript(new Object[]{2091, XPDROP_SKILL, 6});
    }

    private void resetXpDropTextColor(Widget xpDropTextWidget) {
        EnumComposition colorEnum = this.client.getEnum(1169);
        int defaultColorId = this.client.getVarbitValue(4695);
        int color = colorEnum.getIntValue(defaultColorId);
        xpDropTextWidget.setTextColor(color);
    }

    private String formatGoldDropText(long goldDropValue) {
        if (Math.abs(goldDropValue) < 10000L) {
            return Long.toString(goldDropValue);
        }
        if (Math.abs(goldDropValue) < 1000000L) {
            return goldDropValue / 1000L + "K";
        }
        return "ALOT";
    }
}

