/*
 * Decompiled with CFR 0.152.
 */
package com.alteredstats;

import com.alteredstats.AlteredStatsConfig;
import com.alteredstats.AlteredStatsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Comparator;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.util.ColorUtil;

public class AlteredStatsOverlay
extends OverlayPanel {
    private final Client client;
    private final AlteredStatsConfig config;
    private final Skill[] skills = (Skill[])Arrays.stream(Skill.values()).sorted(Comparator.comparing(Skill::getName)).toArray(Skill[]::new);

    @Inject
    private AlteredStatsOverlay(Client client, AlteredStatsConfig config, AlteredStatsPlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Altered stats overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        Skill[] skills = this.skills;
        if (!this.config.includeHP()) {
            skills = (Skill[])Arrays.stream(this.skills).filter(s -> s != Skill.HITPOINTS).toArray(Skill[]::new);
        }
        for (Skill skill : skills) {
            int level;
            int boosted = this.client.getBoostedSkillLevel(skill);
            if (boosted == (level = this.client.getRealSkillLevel(skill)) && !this.config.showAllStats()) continue;
            this.setOverlayText(skill, boosted, level);
        }
        return super.render(graphics);
    }

    private void setOverlayText(Skill skill, int boosted, int base) {
        Object s;
        int delta = boosted - base;
        Color strColor = this.getTextColor(delta);
        switch (this.config.displayType()) {
            case LEVELS: {
                s = Integer.toString(boosted);
                break;
            }
            case LEVELS_WITH_BASES: {
                s = String.format("%s/%s", boosted, base);
                break;
            }
            default: {
                s = (delta < 0 ? "" : "+") + delta;
            }
        }
        String str = ColorUtil.prependColorTag((String)s, (Color)strColor);
        this.panelComponent.getChildren().add(LineComponent.builder().left(skill.getName()).right(str).rightColor(strColor).build());
    }

    private Color getTextColor(int boost) {
        if (boost == 0) {
            return Color.WHITE;
        }
        return boost < 0 ? Color.RED : Color.GREEN;
    }
}

