/*
 * Decompiled with CFR 0.152.
 */
package com.krazune.lineofsight;

import com.krazune.lineofsight.LineOfSightPluginConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class TilesOverlay
extends Overlay {
    Client client;
    LineOfSightPluginConfig config;

    @Inject
    public TilesOverlay(Client client, LineOfSightPluginConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        WorldPoint[][] sightPoints = this.getSightWorldPoints();
        if (this.config.outlineOnly()) {
            this.renderOutlineWorldPoints(graphics, sightPoints);
            return null;
        }
        this.renderWorldPoints(graphics, sightPoints);
        return null;
    }

    public WorldPoint[][] getSightWorldPoints() {
        int areaLength = this.config.overlayRange() * 2 + 1;
        WorldPoint[][] worldPoints = new WorldPoint[areaLength][areaLength];
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return worldPoints;
        }
        WorldArea area = player.getWorldArea();
        if (area == null) {
            return worldPoints;
        }
        int initialX = area.getX() - this.config.overlayRange();
        int initialY = area.getY() - this.config.overlayRange();
        int maxX = area.getX() + this.config.overlayRange();
        int maxY = area.getY() + this.config.overlayRange();
        int x = initialX;
        int i = 0;
        while (x <= maxX) {
            int y = initialY;
            int j = 0;
            while (y <= maxY) {
                WorldPoint newSightWorldPoint;
                if ((x != area.getX() || y != area.getY()) && area.hasLineOfSightTo(this.client, newSightWorldPoint = new WorldPoint(x, y, area.getPlane()))) {
                    worldPoints[i][j] = newSightWorldPoint;
                }
                ++y;
                ++j;
            }
            ++x;
            ++i;
        }
        return worldPoints;
    }

    private void renderOutlineWorldPoints(Graphics2D graphics, WorldPoint[][] sightPoints) {
        int areaLength = this.config.overlayRange() * 2 + 1;
        for (int x = 0; x < areaLength; ++x) {
            for (int y = 0; y < areaLength; ++y) {
                Polygon tilePolygon;
                if (sightPoints[x][y] == null) continue;
                if (this.config.showFill() && (tilePolygon = this.generatePolygonFromWorldPoint(sightPoints[x][y])) != null) {
                    graphics.setColor(this.config.fillColor());
                    graphics.fill(tilePolygon);
                }
                boolean topBorder = y == areaLength - 1 || sightPoints[x][y + 1] == null;
                boolean rightBorder = x == areaLength - 1 || sightPoints[x + 1][y] == null;
                boolean bottomBorder = y == 0 || sightPoints[x][y - 1] == null;
                boolean leftBorder = x == 0 || sightPoints[x - 1][y] == null;
                this.renderWorldPointBorders(graphics, sightPoints[x][y], topBorder, rightBorder, bottomBorder, leftBorder);
            }
        }
    }

    private Polygon generatePolygonFromWorldPoint(WorldPoint worldPoint) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (localPoint == null) {
            return null;
        }
        return Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint);
    }

    private void renderWorldPointBorders(Graphics2D graphics, WorldPoint worldPoint, boolean topBorder, boolean rightBorder, boolean bottomBorder, boolean leftBorder) {
        int y2;
        int x2;
        Point canvasPointB;
        int y1;
        int x1;
        Point canvasPointA;
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (localPoint == null) {
            return;
        }
        int plane = worldPoint.getPlane();
        graphics.setColor(this.config.borderColor());
        graphics.setStroke(new BasicStroke(this.config.borderWidth()));
        if (topBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() + 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (rightBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (bottomBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() + 64, localPoint.getY() - 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
        if (leftBorder && (canvasPointA = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)plane)) != null) {
            x1 = canvasPointA.getX();
            y1 = canvasPointA.getY();
            canvasPointB = Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() + 64), (int)plane);
            if (canvasPointB != null) {
                x2 = canvasPointB.getX();
                y2 = canvasPointB.getY();
                graphics.drawLine(x1, y1, x2, y2);
            }
        }
    }

    private void renderWorldPoints(Graphics2D graphics, WorldPoint[][] sightPoints) {
        int areaLength = this.config.overlayRange() * 2 + 1;
        Color transparent = new Color(0, 0, 0, 0);
        BasicStroke stroke = new BasicStroke(this.config.borderWidth());
        for (int x = 0; x < areaLength; ++x) {
            for (int y = 0; y < areaLength; ++y) {
                Polygon polygon;
                if (sightPoints[x][y] == null || (polygon = this.generatePolygonFromWorldPoint(sightPoints[x][y])) == null) continue;
                if (this.config.showFill()) {
                    OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)this.config.borderColor(), (Color)this.config.fillColor(), (Stroke)stroke);
                    continue;
                }
                if (x == 0 || x == areaLength - 1 || y == 0 || y == areaLength - 1 || sightPoints[x + 1][y] == null || sightPoints[x - 1][y] == null || sightPoints[x][y + 1] == null || sightPoints[x][y - 1] == null) {
                    OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)this.config.borderColor(), (Color)transparent, (Stroke)stroke);
                    continue;
                }
                sightPoints[x][y] = null;
            }
        }
    }
}

