/*
 * Decompiled with CFR 0.152.
 */
package com.hunllefhelper.ui;

import com.hunllefhelper.HunllefHelperPlugin;
import com.hunllefhelper.ui.components.Button;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HunllefHelperPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(HunllefHelperPluginPanel.class);
    private final HunllefHelperPlugin plugin;
    private final JPanel contentPanel;
    private final JPanel activeView;
    private final JPanel inactiveView;
    private final ArrayList<Button> activeButtons = new ArrayList();
    private final ArrayList<Button> inactiveButtons = new ArrayList();
    private JLabel timeLabel;
    private JLabel styleLabel;

    @Inject
    public HunllefHelperPluginPanel(HunllefHelperPlugin plugin) {
        super(false);
        this.plugin = plugin;
        JLabel title = new JLabel("Hunllef Helper");
        title.setBorder(new EmptyBorder(0, 0, 6, 0));
        title.setForeground(Color.WHITE);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.add(title, "North");
        this.add(this.contentPanel, "Center");
        this.activeView = this.createActiveView();
        this.inactiveView = this.createInactiveView();
    }

    public void setTime(int millis) {
        SwingUtilities.invokeLater(() -> {
            if (millis <= 9000000) {
                this.timeLabel.setText(String.format("%d", (millis + 1000) / 1000));
            } else {
                this.timeLabel.setText("Over 9000!");
            }
            this.timeLabel.repaint();
        });
    }

    public void setStyle(String styleName, Color color) {
        SwingUtilities.invokeLater(() -> {
            this.styleLabel.setText(styleName);
            this.styleLabel.setForeground(color);
            this.styleLabel.repaint();
        });
    }

    public void setCounterActiveState(boolean active) {
        SwingUtilities.invokeLater(() -> {
            this.contentPanel.removeAll();
            this.contentPanel.add((Component)(active ? this.activeView : this.inactiveView), "Center");
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
            if (active) {
                for (Button button : this.inactiveButtons) {
                    button.resetStyling();
                }
            } else {
                for (Button button : this.activeButtons) {
                    button.resetStyling();
                }
            }
        });
    }

    public void onActivate() {
        this.plugin.setKeyListeners();
    }

    public void onDeactivate() {
        this.plugin.setKeyListeners();
    }

    private JPanel createActiveView() {
        JPanel activePanel = new JPanel();
        activePanel.setLayout(new BorderLayout());
        activePanel.add((Component)this.createTimerPanel(), "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.createTickButtonsPanel(), "North");
        Button trampleButton = this.createTrampleButton();
        activePanel.add(trampleButton);
        centerPanel.add((Component)trampleButton, "Center");
        activePanel.add((Component)centerPanel, "Center");
        Button resetButton = this.createResetButton();
        this.activeButtons.add(resetButton);
        activePanel.add((Component)resetButton, "South");
        return activePanel;
    }

    private JPanel createInactiveView() {
        JPanel inactivePanel = new JPanel();
        inactivePanel.setLayout(new BorderLayout());
        JLabel instructionLabel = new JLabel("<html>Press 'Start' right after you got hit by the first Hunllef attack. Press the 'I got trampled!' button if you get trampled by Hunllef.</html>");
        instructionLabel.setBorder(new EmptyBorder(6, 0, 6, 0));
        inactivePanel.add((Component)instructionLabel, "North");
        Button startRangedButton = this.createStartRangedButton();
        this.inactiveButtons.add(startRangedButton);
        inactivePanel.add((Component)startRangedButton, "Center");
        Button startMageButton = this.createStartMageButton();
        this.inactiveButtons.add(startMageButton);
        inactivePanel.add((Component)startMageButton, "South");
        return inactivePanel;
    }

    private JPanel createTimerPanel() {
        JPanel timerPanel = new JPanel();
        timerPanel.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 20));
        this.timeLabel = new JLabel("", 0);
        this.timeLabel.setForeground(Color.WHITE);
        this.timeLabel.setFont(new Font(this.timeLabel.getFont().getName(), 0, 50));
        this.styleLabel = new JLabel("", 0);
        this.styleLabel.setForeground(Color.CYAN);
        this.styleLabel.setFont(new Font(this.styleLabel.getFont().getName(), 0, 50));
        timerPanel.add((Component)this.styleLabel, "North");
        timerPanel.add((Component)this.timeLabel, "North");
        timerPanel.setBorder(new EmptyBorder(6, 0, 6, 0));
        return timerPanel;
    }

    private Button createStartRangedButton() {
        Button button = new Button("Start");
        button.addMouseButton1PressedHandler(() -> this.plugin.start(true));
        return button;
    }

    private Button createStartMageButton() {
        Button button = new Button("Start mage");
        button.setPreferredSize(new Dimension(225, 60));
        button.addMouseButton1PressedHandler(() -> this.plugin.start(false));
        return button;
    }

    private JPanel createTickButtonsPanel() {
        JPanel tickPanel = new JPanel();
        tickPanel.setLayout(new BorderLayout());
        Button minus1TickButton = new Button("-1 tick");
        this.activeButtons.add(minus1TickButton);
        minus1TickButton.setPreferredSize(new Dimension(115, 60));
        minus1TickButton.addMouseButton1PressedHandler(() -> this.plugin.addTicks(-1));
        tickPanel.add((Component)minus1TickButton, "West");
        Button plus1TickButton = new Button("+1 tick");
        this.activeButtons.add(plus1TickButton);
        plus1TickButton.setPreferredSize(new Dimension(115, 60));
        plus1TickButton.addMouseButton1PressedHandler(() -> this.plugin.addTicks(1));
        tickPanel.add((Component)plus1TickButton, "East");
        return tickPanel;
    }

    private Button createTrampleButton() {
        Button button = new Button("I got trampled!");
        button.addMouseButton1PressedHandler(this.plugin::trample);
        return button;
    }

    private Button createResetButton() {
        Button button = new Button("Reset");
        button.setPreferredSize(new Dimension(225, 60));
        button.addMouseButton1PressedHandler(this.plugin::reset);
        return button;
    }
}

