/*
 * Decompiled with CFR 0.152.
 */
package com.hunllefhelper;

import com.google.inject.Provides;
import com.hunllefhelper.AudioPlayer;
import com.hunllefhelper.ConditionalHotkeyListener;
import com.hunllefhelper.PluginConstants;
import com.hunllefhelper.config.AudioMode;
import com.hunllefhelper.config.HunllefHelperConfig;
import com.hunllefhelper.config.PanelVisibility;
import com.hunllefhelper.ui.HunllefHelperPluginPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hunllef Helper")
public class HunllefHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HunllefHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private HunllefHelperConfig config;
    @Inject
    private AudioPlayer audioPlayer;
    @Inject
    private ConfigManager configManager;
    @Inject
    private KeyManager keyManager;
    private HunllefHelperPluginPanel panel;
    private ScheduledExecutorService executorService;
    private NavigationButton navigationButton;
    private final ArrayList<ConditionalHotkeyListener> keyListeners = new ArrayList();
    private int counter;
    private boolean isRanged;
    private boolean isPanelVisible;
    private boolean started;

    protected void startUp() throws Exception {
        this.migrate();
        this.audioPlayer.setVolume(this.config.audioVolume());
        this.audioPlayer.tryLoadAudio(this.config, PluginConstants.SOUNDS);
        this.panel = (HunllefHelperPluginPanel)((Object)this.injector.getInstance(HunllefHelperPluginPanel.class));
        this.panel.setCounterActiveState(false);
        this.navigationButton = NavigationButton.builder().tooltip("Hunllef Helper").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/nav-icon.png")).priority(100).panel((PluginPanel)this.panel).build();
        this.updatePanelVisibility(false);
        this.setKeyListeners();
    }

    protected void shutDown() throws Exception {
        this.removeKeyListeners();
        this.updateNavigationBar(false, false);
        this.shutdownExecutorService();
        this.panel = null;
        this.navigationButton = null;
        this.audioPlayer.unloadAudio();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.updatePanelVisibility(true);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        switch (event.getKey()) {
            case "audioMode": {
                this.audioPlayer.unloadAudio();
                this.audioPlayer.tryLoadAudio(this.config, PluginConstants.SOUNDS);
                break;
            }
            case "panelVisibility": {
                this.updatePanelVisibility(false);
                break;
            }
            case "audioVolume": {
                this.audioPlayer.setVolume(this.config.audioVolume());
                break;
            }
            case "onlyWithPanel": {
                this.setKeyListeners();
            }
        }
    }

    public void start(boolean withRanged) {
        this.started = true;
        this.isRanged = withRanged;
        if (withRanged) {
            this.panel.setStyle("Ranged", Color.GREEN);
        } else {
            this.panel.setStyle("Mage", Color.CYAN);
        }
        this.panel.setCounterActiveState(this.started);
        this.counter = 8400;
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(this::tickCounter, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    public void trample() {
        this.counter += 3000;
    }

    public void addTicks(int ticks) {
        this.counter += ticks * 600;
    }

    public void reset() {
        this.started = false;
        this.shutdownExecutorService();
        this.panel.setCounterActiveState(this.started);
    }

    public void setKeyListeners() {
        if (!this.config.hotkeysOnlyWithPanel() || this.navigationButton.isSelected()) {
            if (this.keyListeners.isEmpty()) {
                this.addKeyListeners();
            }
        } else {
            this.removeKeyListeners();
        }
    }

    @Provides
    HunllefHelperConfig provideConfig(ConfigManager configManager) {
        return (HunllefHelperConfig)configManager.getConfig(HunllefHelperConfig.class);
    }

    private void tickCounter() {
        this.counter -= 200;
        this.panel.setTime(this.counter);
        if (this.counter == 2000) {
            this.playSoundClip("/audio/two.wav");
            return;
        }
        if (this.counter == 1000) {
            this.playSoundClip("/audio/one.wav");
            return;
        }
        if (this.counter <= 0) {
            if (this.isRanged) {
                this.playSoundClip("/audio/mage.wav");
                this.panel.setStyle("Mage", Color.CYAN);
            } else {
                this.playSoundClip("/audio/range.wav");
                this.panel.setStyle("Ranged", Color.GREEN);
            }
            this.isRanged = !this.isRanged;
            this.counter += 12000;
        }
    }

    private void playSoundClip(String soundFile) {
        if (this.config.audioMode() == AudioMode.Disabled) {
            return;
        }
        this.executorService.submit(() -> this.audioPlayer.playSoundClip(soundFile));
    }

    private void updatePanelVisibility(boolean selectPanel) {
        boolean panelShouldBeVisible = this.shouldShowPanel();
        if (panelShouldBeVisible != this.isPanelVisible) {
            this.updateNavigationBar(panelShouldBeVisible, selectPanel);
            this.isPanelVisible = panelShouldBeVisible;
        }
    }

    private boolean shouldShowPanel() {
        switch (this.config.panelVisibility()) {
            case Always: {
                return true;
            }
            case InsideGauntlet: {
                return this.isInTheGauntlet();
            }
            case AtHunllef: {
                return this.isInHunllefRoom();
            }
        }
        return false;
    }

    private boolean isInTheGauntlet() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        int regionId = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getRegionID();
        return PluginConstants.REGION_IDS_GAUNTLET.contains(regionId);
    }

    private boolean isInHunllefRoom() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        WorldPoint playerLocation = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation());
        int regionId = playerLocation.getRegionID();
        if (regionId != 7512 && regionId != 7768) {
            return false;
        }
        int playerX = playerLocation.getRegionX();
        int playerY = playerLocation.getRegionY();
        return playerX >= 49 && playerX <= 62 && playerY >= 49 && playerY <= 62;
    }

    private void updateNavigationBar(boolean enable, boolean selectPanel) {
        if (enable) {
            this.clientToolbar.addNavigation(this.navigationButton);
            if (selectPanel) {
                SwingUtilities.invokeLater(() -> {
                    if (!this.navigationButton.isSelected()) {
                        this.navigationButton.getOnSelect().run();
                    }
                });
            }
        } else {
            this.reset();
            this.navigationButton.setSelected(false);
            this.clientToolbar.removeNavigation(this.navigationButton);
        }
    }

    private void shutdownExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            try {
                if (!this.executorService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    log.warn("Executor service dit not shut down within the allocated timeout.");
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.executorService = null;
        }
    }

    private void migrate() {
        Boolean autoHide = (Boolean)this.configManager.getConfiguration("hunllefhelper", "autoHide", Boolean.TYPE);
        if (autoHide != null) {
            if (!autoHide.booleanValue()) {
                this.configManager.setConfiguration("hunllefhelper", "panelVisibility", (Object)PanelVisibility.Always);
            }
            this.configManager.unsetConfiguration("hunllefhelper", "autoHide");
        }
    }

    private void addKeyListeners() {
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyStart(), () -> this.start(true), () -> !this.started));
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyStartMage(), () -> this.start(false), () -> !this.started));
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyMinusOneTick(), () -> this.addTicks(-1), () -> this.started));
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyPlusOneTick(), () -> this.addTicks(1), () -> this.started));
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyReset(), this::reset, () -> this.started));
        this.keyListeners.add(new ConditionalHotkeyListener(() -> this.config.hotkeyTrample(), this::trample, () -> this.started));
        for (KeyListener keyListener : this.keyListeners) {
            this.keyManager.registerKeyListener(keyListener);
        }
    }

    private void removeKeyListeners() {
        for (KeyListener keyListener : this.keyListeners) {
            this.keyManager.unregisterKeyListener(keyListener);
        }
        this.keyListeners.clear();
    }
}

