/*
 * Decompiled with CFR 0.152.
 */
package com.hunllefhelper;

import com.hunllefhelper.config.AudioMode;
import com.hunllefhelper.config.HunllefHelperConfig;
import java.util.HashMap;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    private HashMap<String, Clip> clips = new HashMap();
    private float volume = 1.0f;

    public void tryLoadAudio(HunllefHelperConfig config, String[] clipNames) {
        if (config.audioMode() == AudioMode.Disabled) {
            return;
        }
        for (String clipName : clipNames) {
            this.tryLoadClip(config.audioMode(), clipName);
        }
    }

    public void unloadAudio() {
        for (Clip clip : this.clips.values()) {
            clip.stop();
            clip.flush();
            clip.close();
        }
        this.clips.clear();
    }

    public synchronized void playSoundClip(String sound) {
        if (this.clips.containsKey(sound)) {
            Clip clip = this.clips.get(sound);
            clip.setFramePosition(0);
            clip.start();
        }
    }

    public void setVolume(int volume) {
        float volumeF = (float)volume / 100.0f;
        volumeF = Math.max(volumeF, 0.0f);
        if (this.volume != (volumeF = Math.min(volumeF, 2.0f))) {
            this.volume = volumeF;
            for (Clip clip : this.clips.values()) {
                this.setClipVolume(clip);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean tryLoadClip(AudioMode audioMode, String clipName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setClipVolume(Clip clip) {
        FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(20.0f * (float)Math.log10(this.volume));
    }
}

