/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.weaponanimationreplacer.Swap;
import com.weaponanimationreplacer.TransmogSet;
import com.weaponanimationreplacer.TransmogSetPanel;
import com.weaponanimationreplacer.WeaponAnimationReplacerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.plugins.screenmarkers.ScreenMarkerPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

public class WeaponAnimationReplacerPluginPanel
extends PluginPanel {
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final Color DEFAULT_BORDER_COLOR;
    private static final Color DEFAULT_FILL_COLOR;
    private static final int DEFAULT_BORDER_THICKNESS = 3;
    private final JLabel addMarker = new JLabel(ADD_ICON);
    private final JLabel title = new JLabel();
    private final PluginErrorPanel noMarkersPanel = new PluginErrorPanel();
    private final JPanel markerView = new JPanel(new GridBagLayout());
    private final WeaponAnimationReplacerPlugin plugin;
    private Color selectedColor = DEFAULT_BORDER_COLOR;
    private Color selectedFillColor = DEFAULT_FILL_COLOR;
    private int selectedBorderThickness = 3;
    Swap currentlyEditingThisSwap = null;
    int currentlyEditingThisProjectileSwapIndex = -1;

    public WeaponAnimationReplacerPluginPanel(WeaponAnimationReplacerPlugin weaponAnimationReplacerPlugin) {
        this.plugin = weaponAnimationReplacerPlugin;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("Transmog sets");
        this.title.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.title.setForeground(Color.WHITE);
        northPanel.add((Component)this.title, "West");
        northPanel.add((Component)this.addMarker, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.markerView.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.noMarkersPanel.setContent("There's nothing interesting here.", "Click the green \"+\" button.");
        this.noMarkersPanel.setVisible(false);
        this.markerView.add((Component)this.noMarkersPanel, constraints);
        ++constraints.gridy;
        this.addMarker.setToolTipText("Add a new transmog set.");
        this.addMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WeaponAnimationReplacerPluginPanel.this.plugin.addNewTransmogSet(0);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WeaponAnimationReplacerPluginPanel.this.addMarker.setIcon(ADD_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WeaponAnimationReplacerPluginPanel.this.addMarker.setIcon(ADD_ICON);
            }
        });
        centerPanel.add((Component)this.markerView, "Center");
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
    }

    public void rebuild() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.markerView.removeAll();
        int index = 0;
        for (TransmogSet transmogSet : this.plugin.getTransmogSets()) {
            this.markerView.add((Component)new TransmogSetPanel(this.plugin, transmogSet, this, index++), constraints);
            ++constraints.gridy;
            this.markerView.add(Box.createRigidArea(new Dimension(0, 10)), constraints);
            ++constraints.gridy;
        }
        boolean empty = constraints.gridy == 0;
        this.noMarkersPanel.setVisible(empty);
        this.title.setVisible(!empty);
        this.markerView.add((Component)this.noMarkersPanel, constraints);
        ++constraints.gridy;
        this.repaint();
        this.revalidate();
    }

    public void deleteNewRule(int index) {
    }

    public void addNewRule(int index) {
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getSelectedFillColor() {
        return this.selectedFillColor;
    }

    public int getSelectedBorderThickness() {
        return this.selectedBorderThickness;
    }

    static {
        DEFAULT_BORDER_COLOR = Color.GREEN;
        DEFAULT_FILL_COLOR = new Color(0, 255, 0, 0);
        BufferedImage addIcon = ImageUtil.loadImageResource(ScreenMarkerPlugin.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
    }
}

