/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.weaponanimationreplacer.AnimationReplacementRule_OLD;
import com.weaponanimationreplacer.AnimationSet;
import com.weaponanimationreplacer.ChatBoxFilterableSearch;
import com.weaponanimationreplacer.Constants;
import com.weaponanimationreplacer.GraphicEffect;
import com.weaponanimationreplacer.ProjectileCast;
import com.weaponanimationreplacer.ProjectileSwap;
import com.weaponanimationreplacer.Swap;
import com.weaponanimationreplacer.TransmogSet;
import com.weaponanimationreplacer.TransmogrificationManager;
import com.weaponanimationreplacer.WeaponAnimationReplacerConfig;
import com.weaponanimationreplacer.WeaponAnimationReplacerPluginPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.JagexColor;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Weapon/Gear/Anim Replacer", description="replace weapon animations (stand,walk,run,attack) with other ones. Config is in a plugin panel.", tags={"transmog", "fashionscape"})
public class WeaponAnimationReplacerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WeaponAnimationReplacerPlugin.class);
    public static final String GROUP_NAME = "WeaponAnimationReplacer";
    private static final String TRANSMOG_SET_KEY = "transmogSets";
    @Inject
    Client client;
    @Inject
    EventBus eventBus;
    @Inject
    private ChatBoxFilterableSearch itemSearch;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private TransmogrificationManager transmogManager;
    @Inject
    private Gson runeliteGson;
    @Inject
    ClientUI clientUI;
    @Inject
    ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    ClientThread clientThread;
    @Inject
    ColorPickerManager colorPickerManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private WeaponAnimationReplacerConfig config;
    List<TransmogSet> transmogSets = null;
    WeaponAnimationReplacerPluginPanel pluginPanel;
    private NavigationButton navigationButton;
    private List<Integer> equippedItemsFromKit = new ArrayList<Integer>();
    private final List<Integer> naturalPlayerPoseAnimations = new ArrayList<Integer>();
    private AnimationReplacements currentAnimations = new AnimationReplacements();
    private GraphicEffect currentScytheGraphicEffect = null;
    int scytheSwingCountdown = -1;
    int delayedGfxToApply = -1;
    int delayedGfxHeightToApply = -1;
    Actor actorToApplyDelayedGfxTo = null;
    int timeToApplyDelayedGfx = -1;
    private boolean handlePossibleNoProjectileSpellInClientTick = false;
    private List<ProjectileSwap> projectileSwaps = Collections.emptyList();
    int previewItem = -1;
    AnimationReplacements previewAnimationReplacements = null;
    private Gson customGson = null;
    static final Map<String, String> renames = new HashMap<String, String>();
    private boolean norecurse = false;
    private int lastRealAnimation = -1;

    Gson getGson() {
        if (this.customGson != null) {
            return this.customGson;
        }
        GsonBuilder gsonBuilder = this.runeliteGson.newBuilder();
        gsonBuilder.registerTypeAdapter(new TypeToken<Map>(){}.getType(), (Object)new JsonSerializer<Map<?, ?>>(){

            public JsonElement serialize(Map<?, ?> map, Type typeOfSrc, JsonSerializationContext context) {
                if (map.isEmpty()) {
                    return null;
                }
                JsonObject object = new JsonObject();
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    JsonElement element = context.serialize(entry.getValue());
                    object.add(String.valueOf(entry.getKey()), element);
                }
                return object;
            }
        });
        gsonBuilder.registerTypeAdapter(new TypeToken<List>(){}.getType(), (Object)new JsonSerializer<List<?>>(){

            public JsonElement serialize(List<?> list, Type typeOfSrc, JsonSerializationContext context) {
                if (list.isEmpty()) {
                    return null;
                }
                JsonArray array = new JsonArray();
                for (Object child : list) {
                    JsonElement element = context.serialize(child);
                    array.add(element);
                }
                return array;
            }
        });
        Type animationSetTypeToken = new TypeToken<AnimationSet>(){}.getType();
        JsonSerializer<AnimationSet> serializer = new JsonSerializer<AnimationSet>(){

            public JsonElement serialize(AnimationSet set, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(set.name);
            }
        };
        gsonBuilder.registerTypeAdapter(animationSetTypeToken, (Object)serializer);
        JsonDeserializer<AnimationSet> deserializer = new JsonDeserializer<AnimationSet>(){

            public AnimationSet deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                if (jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isString()) {
                    AnimationSet animationSet;
                    String s = jsonElement.getAsString();
                    String newS = renames.get(s);
                    if (newS != null) {
                        log.debug("updating \"" + s + "\" to \"" + newS + "\"");
                        s = newS;
                    }
                    if ((animationSet = AnimationSet.getAnimationSet(s)) == null) {
                        return AnimationSet.animationSets.get(0);
                    }
                    return animationSet;
                }
                throw new JsonParseException("animationset is supposed to be a string.");
            }
        };
        gsonBuilder.registerTypeAdapter(animationSetTypeToken, (Object)deserializer);
        gsonBuilder.registerTypeAdapter(new TypeToken<Swap.AnimationType>(){}.getType(), (jsonElement, type, jsonDeserializationContext) -> {
            if (jsonElement instanceof JsonObject) {
                jsonElement = ((JsonObject)jsonElement).get("type");
            }
            return Swap.AnimationType.valueOf(jsonElement.getAsString());
        });
        this.customGson = gsonBuilder.create();
        return this.customGson;
    }

    protected void startUp() {
        this.clientThread.invokeLater(() -> {
            this.transmogManager.startUp();
            this.eventBus.register((Object)this.transmogManager);
            Constants.loadData(this.getGson());
            this.reloadTransmogSetsFromConfig();
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.onPlayerChanged(new PlayerChanged(this.client.getLocalPlayer()));
            } else {
                this.equippedItemsFromKit.clear();
                this.naturalPlayerPoseAnimations.clear();
                this.currentAnimations = new AnimationReplacements();
            }
            this.currentScytheGraphicEffect = null;
            this.scytheSwingCountdown = -1;
            this.previewItem = -1;
            this.norecurse = false;
            if (this.client.getGameState().getState() >= GameState.LOGIN_SCREEN.getState()) {
                this.showSidePanel(!this.config.hideSidePanel());
            }
        });
    }

    private void migrate() {
        int serialVersion;
        String serialVersionString = this.configManager.getConfiguration(GROUP_NAME, "serialVersion");
        int n = serialVersion = serialVersionString != null ? Integer.parseInt(serialVersionString) : -1;
        if (serialVersion == -1) {
            if (this.configManager.getConfiguration(GROUP_NAME, TRANSMOG_SET_KEY) == null) {
                String configuration = this.configManager.getConfiguration(GROUP_NAME, "rules");
                if (configuration == null) {
                    return;
                }
                List<TransmogSet> transmogSets = this.migrate(configuration);
                this.transmogSets = transmogSets;
                this.saveTransmogSets();
                this.configManager.setConfiguration(GROUP_NAME, "rulesbackup", configuration);
                this.configManager.unsetConfiguration(GROUP_NAME, "rules");
            }
            this.updateForSortOrder();
        }
        if (serialVersion <= 1) {
            this.fixBadAutoAnimationReplacements();
        }
        this.configManager.setConfiguration(GROUP_NAME, "serialVersion", (Object)2);
    }

    private void fixBadAutoAnimationReplacements() {
        List<TransmogSet> transmogSets;
        try {
            transmogSets = this.getTransmogSetsFromConfig();
        }
        catch (JsonParseException | IllegalStateException e) {
            log.error("issue parsing json: " + this.configManager.getConfiguration(GROUP_NAME, TRANSMOG_SET_KEY), e);
            return;
        }
        for (TransmogSet transmogSet : transmogSets) {
            for (Swap swap : transmogSet.getSwaps()) {
                for (Swap.AnimationReplacement animationReplacement : swap.animationReplacements) {
                    if (animationReplacement.animationtypeReplacement == null || Swap.AnimationType.ATTACK.appliesTo(animationReplacement.animationtypeReplacement)) continue;
                    animationReplacement.animationtypeReplacement = null;
                }
            }
        }
        this.transmogSets = transmogSets;
        this.saveTransmogSets();
    }

    private void updateForSortOrder() {
        List<TransmogSet> transmogSets;
        try {
            transmogSets = this.getTransmogSetsFromConfig();
        }
        catch (JsonParseException | IllegalStateException e) {
            log.error("issue parsing json: " + this.configManager.getConfiguration(GROUP_NAME, TRANSMOG_SET_KEY), e);
            return;
        }
        for (TransmogSet transmogSet : transmogSets) {
            for (Swap swap : transmogSet.getSwaps()) {
                swap.updateForSortOrderAndUniqueness(this);
            }
        }
        this.transmogSets = transmogSets;
        this.saveTransmogSets();
    }

    List<TransmogSet> migrate(String config) {
        List rules = (List)this.getGson().fromJson(config, new TypeToken<ArrayList<AnimationReplacementRule_OLD>>(){}.getType());
        ArrayList<TransmogSet> transmogSets = new ArrayList<TransmogSet>();
        for (AnimationReplacementRule_OLD rule : rules) {
            TransmogSet transmogSet = new TransmogSet(Collections.singletonList(new Swap(rule.itemRestrictions.stream().map(r -> r.itemId).collect(Collectors.toList()), Collections.singletonList(rule.modelSwap), rule.animationReplacements, Collections.emptyList(), Collections.emptyList())));
            transmogSet.setName(rule.name);
            transmogSets.add(transmogSet);
        }
        return transmogSets;
    }

    protected void shutDown() {
        this.showSidePanel(false);
        this.clientThread.invokeLater(() -> {
            this.eventBus.unregister((Object)this.transmogManager);
            this.transmogManager.shutDown();
            if (!this.naturalPlayerPoseAnimations.isEmpty()) {
                for (Constants.ActorAnimation animation : Constants.ActorAnimation.values()) {
                    animation.setAnimation((Actor)this.client.getLocalPlayer(), this.naturalPlayerPoseAnimations.get(animation.ordinal()));
                }
            }
        });
        this.transmogSets = null;
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.chatboxPanelManager.close();
        this.clientThread.invokeLater(() -> {
            this.reloadTransmogSetsFromConfig();
            this.handleTransmogSetChange();
            if (this.pluginPanel != null) {
                SwingUtilities.invokeLater(this.pluginPanel::rebuild);
            }
        });
    }

    private void reloadTransmogSetsFromConfig() {
        this.migrate();
        try {
            this.transmogSets = this.getTransmogSetsFromConfig();
        }
        catch (JsonParseException | IllegalStateException ex) {
            log.error("issue parsing json: " + this.configManager.getConfiguration(GROUP_NAME, TRANSMOG_SET_KEY), ex);
            this.transmogSets = new ArrayList<TransmogSet>();
        }
    }

    @Provides
    public WeaponAnimationReplacerConfig provideConfig(ConfigManager configManager) {
        return (WeaponAnimationReplacerConfig)configManager.getConfig(WeaponAnimationReplacerConfig.class);
    }

    public List<TransmogSet> getTransmogSetsFromConfig() {
        ArrayList transmogSets;
        String configuration = this.configManager.getConfiguration(GROUP_NAME, TRANSMOG_SET_KEY);
        if (configuration == null) {
            return this.getDefaultTransmogSets();
        }
        if (configuration.startsWith("NOT_JSON")) {
            configuration = configuration.substring("NOT_JSON".length());
        }
        if ((transmogSets = (ArrayList)this.getGson().fromJson(configuration, new TypeToken<ArrayList<TransmogSet>>(){}.getType())) == null) {
            transmogSets = new ArrayList();
        }
        return transmogSets;
    }

    public void saveTransmogSets() {
        if (this.transmogSets == null) {
            return;
        }
        String s = "NOT_JSON" + this.getGson().toJson(this.transmogSets);
        this.configManager.setConfiguration(GROUP_NAME, TRANSMOG_SET_KEY, s);
    }

    public void handleTransmogSetChange() {
        this.saveTransmogSets();
        if (this.client.getLocalPlayer() != null) {
            this.transmogManager.changeTransmog();
            this.updateAnimations();
        }
    }

    public void deleteTransmogSet(int index) {
        this.transmogSets.remove(index);
        this.handleTransmogSetChange();
        SwingUtilities.invokeLater(this.pluginPanel::rebuild);
    }

    public void addNewTransmogSet(int index) {
        this.transmogSets.add(index, TransmogSet.createTemplate());
        this.saveTransmogSets();
        SwingUtilities.invokeLater(this.pluginPanel::rebuild);
    }

    public void moveTransmogSet(int index, boolean up) {
        if (!up && index == this.transmogSets.size() - 1 || up && index == 0) {
            return;
        }
        TransmogSet swap = this.transmogSets.remove(index);
        this.transmogSets.add(index + (up ? -1 : 1), swap);
        this.handleTransmogSetChange();
        SwingUtilities.invokeLater(this.pluginPanel::rebuild);
    }

    private List<TransmogSet> getDefaultTransmogSets() {
        String configuration = "[{\"name\":\"Monkey run\",\"enabled\":false,\"minimized\":false,\"swaps\":[{\"itemRestrictions\":[-1],\"modelSwaps\":[-1],\"animationReplacements\":[{\"animationSet\":\"Cursed banana\",\"animationtypeToReplace\":\"ALL\"}],\"graphicEffects\":[]}]},{\"name\":\"Elder Maul Scythe\",\"enabled\":false,\"minimized\":false,\"swaps\":[{\"itemRestrictions\":[22324,4151,12006,4587,24551],\"modelSwaps\":[22325],\"animationReplacements\":[{\"animationSet\":\"Elder maul\",\"animationtypeToReplace\":\"ALL\"},{\"animationSet\":\"Scythe of Vitur\",\"animationtypeToReplace\":\"ATTACK\",\"animationtypeReplacement\":{\"type\":\"ATTACK_SLASH\",\"id\":8056}}],\"graphicEffects\":[{\"type\":\"SCYTHE_SWING\",\"color\":{\"value\":-4030079,\"falpha\":0.0}}]}]},{\"name\":\"Shoulder Halberd\",\"enabled\":false,\"minimized\":false,\"swaps\":[{\"itemRestrictions\":[3204,23987],\"modelSwaps\":[-1],\"animationReplacements\":[{\"animationSet\":\"Dharok's greataxe\",\"animationtypeToReplace\":\"STAND_PLUS_MOVEMENT\"}],\"graphicEffects\":[]}]},{\"name\":\"Saeldor Slash\",\"enabled\":false,\"minimized\":false,\"swaps\":[{\"itemRestrictions\":[24551,23995,23997],\"modelSwaps\":[-1],\"animationReplacements\":[{\"animationSet\":\"Inquisitor's mace\",\"animationtypeToReplace\":\"ATTACK_SLASH\",\"animationtypeReplacement\":{\"type\":\"ATTACK_CRUSH\",\"id\":4503}}],\"graphicEffects\":[]}]},{\"name\":\"Rich voider\",\"enabled\":false,\"minimized\":false,\"swaps\":[{\"itemRestrictions\":[8839,8840,8842,11664,13072,13073],\"modelSwaps\":[11826,11828,11830,7462,13237,22249,21898],\"animationReplacements\":[],\"graphicEffects\":[]}]}]";
        return (List)this.getGson().fromJson(configuration, new TypeToken<ArrayList<TransmogSet>>(){}.getType());
    }

    private void swapPlayerAnimation() {
        Player player = this.client.getLocalPlayer();
        int playerAnimation = player.getAnimation();
        if (playerAnimation == -1) {
            return;
        }
        Optional<Swap.AnimationType> type = AnimationSet.animationSets.stream().map(set -> set.getType(playerAnimation)).filter(t -> t != null).findFirst();
        if (!type.isPresent()) {
            return;
        }
        Integer replacementAnim = this.currentAnimations.getAnimation(type.get());
        if (replacementAnim != null) {
            log.debug("replacing animation {} with {}", (Object)playerAnimation, (Object)replacementAnim);
            player.setAnimation(replacementAnim.intValue());
        }
        if (this.currentScytheGraphicEffect != null && Swap.AnimationType.ATTACK.appliesTo(type.get())) {
            this.scytheSwingCountdown = 20;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.handlePossibleNoProjectileSpellInClientTick) {
            this.replaceNoProjectileSpell();
        }
        if (this.client.getGameCycle() == this.timeToApplyDelayedGfx) {
            this.actorToApplyDelayedGfxTo.setGraphic(this.delayedGfxToApply);
            this.actorToApplyDelayedGfxTo.setSpotAnimFrame(0);
            this.actorToApplyDelayedGfxTo.setGraphicHeight(this.delayedGfxHeightToApply);
        }
        if (this.scytheSwingCountdown == 0) {
            this.createScytheSwing();
        } else {
            --this.scytheSwingCountdown;
        }
    }

    private void replaceNoProjectileSpell() {
        this.handlePossibleNoProjectileSpellInClientTick = false;
        Player player = this.client.getLocalPlayer();
        WorldPoint playerPos = player.getWorldLocation();
        if (playerPos == null) {
            return;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return;
        }
        if (player.getInteracting() == null) {
            return;
        }
        for (ProjectileSwap projectileSwap : this.projectileSwaps) {
            int projectileTravelTime;
            ProjectileCast toReplace = projectileSwap.getToReplace();
            if (toReplace.getCastAnimation() != this.lastRealAnimation || toReplace.getProjectileId() != -1 || toReplace.getCastGfx() != -1 && toReplace.getCastGfx() != player.getGraphic()) continue;
            boolean isBarrage = false;
            int chebyshevDistance = this.chebyshevDistance(player, player.getInteracting(), isBarrage);
            ProjectileCast toReplaceWith = projectileSwap.getToReplaceWith();
            switch (toReplace.getCastAnimation()) {
                case 811: {
                    projectileTravelTime = 120 - toReplaceWith.getStartMovement();
                    int graphicDelay = 48 + 10 * chebyshevDistance;
                    break;
                }
                case 1978: 
                case 1979: {
                    projectileTravelTime = -5 + 10 * chebyshevDistance;
                    int graphicDelay = 48 + 10 * chebyshevDistance;
                    break;
                }
                case 8972: 
                case 8974: 
                case 8977: {
                    projectileTravelTime = 60;
                    int graphicDelay = 60;
                    break;
                }
                default: {
                    return;
                }
            }
            int endCycle = this.client.getGameCycle() + toReplaceWith.getStartMovement() + projectileTravelTime;
            int targetX = player.getInteracting().getLocalLocation().getX();
            int targetY = player.getInteracting().getLocalLocation().getY();
            int startHeight = Perspective.getTileHeight((Client)this.client, (LocalPoint)player.getLocalLocation(), (int)player.getWorldLocation().getPlane()) + toReplaceWith.height;
            this.replaceSpell(projectileSwap, player, playerPos.getPlane(), playerPosLocal, startHeight, endCycle, player.getInteracting(), targetX, targetY);
            break;
        }
    }

    int chebyshevDistance(Player player, Actor target, boolean isBarrage) {
        NPC npc;
        int targetSize;
        if (target == null) {
            return -1;
        }
        LocalPoint playerLocation = player.getLocalLocation();
        LocalPoint targetLocation = target.getLocalLocation();
        int px = playerLocation.getSceneX();
        int py = playerLocation.getSceneY();
        int tx = targetLocation.getSceneX();
        int ty = targetLocation.getSceneY();
        if (target instanceof NPC && !isBarrage && (targetSize = (npc = (NPC)target).getTransformedComposition().getSize()) > 1) {
            int nDiff = py - (ty + targetSize - 1);
            int sDiff = ty - py;
            int wDiff = tx - px;
            int eDiff = px - (tx + targetSize - 1);
            return Math.max(Math.max(nDiff, sDiff), Math.max(wDiff, eDiff));
        }
        return Math.max(Math.abs(tx - px), Math.abs(ty - py));
    }

    @Subscribe(priority=-1.0f)
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        if (this.norecurse) {
            return;
        }
        Projectile projectile = projectileMoved.getProjectile();
        if (this.client.getGameCycle() >= projectile.getStartCycle()) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        WorldPoint playerPos = player.getWorldLocation();
        if (playerPos == null) {
            return;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return;
        }
        if (projectile.getX1() != playerPosLocal.getX() || projectile.getY1() != playerPosLocal.getY()) {
            return;
        }
        int correctedLastRealAnimation = this.lastRealAnimation < 710 || this.lastRealAnimation > 729 ? this.lastRealAnimation : (this.lastRealAnimation == 710 ? 1161 : (this.lastRealAnimation == 711 ? 1162 : (this.lastRealAnimation == 716 ? 1163 : (this.lastRealAnimation == 717 ? 1164 : (this.lastRealAnimation == 718 ? 1165 : (this.lastRealAnimation == 724 ? 1166 : (this.lastRealAnimation == 727 ? 1167 : (this.lastRealAnimation == 728 ? 1168 : (this.lastRealAnimation == 729 ? 1169 : this.lastRealAnimation)))))))));
        for (ProjectileSwap projectileSwap : this.projectileSwaps) {
            ProjectileCast toReplace = projectileSwap.getToReplace();
            if (toReplace.getCastAnimation() != correctedLastRealAnimation || correctedLastRealAnimation == -1 || toReplace.getProjectileId() != projectile.getId() || toReplace.getCastGfx() != -1 && toReplace.getCastGfx() != player.getGraphic()) continue;
            this.handlePossibleNoProjectileSpellInClientTick = false;
            int endCycle = projectile.getEndCycle();
            Actor interacting = projectile.getInteracting();
            int x = projectile.getTarget().getX();
            int y = projectile.getTarget().getY();
            int height = projectile.getHeight() - toReplace.height + projectileSwap.getToReplaceWith().height;
            this.replaceSpell(projectileSwap, player, playerPos.getPlane(), playerPosLocal, height, endCycle, interacting, x, y);
            projectile.setEndCycle(0);
            break;
        }
    }

    private void replaceSpell(ProjectileSwap projectileSwap, Player player, int plane, LocalPoint playerPosLocal, int startHeight, int endCycle, Actor interacting, int targetX, int targetY) {
        if (interacting.getLocalLocation().getX() != targetX || interacting.getLocalLocation().getY() != targetY) {
            // empty if block
        }
        ProjectileCast toReplace = projectileSwap.getToReplace();
        ProjectileCast toReplaceWith = projectileSwap.getToReplaceWith();
        player.setAnimation(toReplaceWith.getCastAnimation());
        if (toReplaceWith.getProjectileId() != -1) {
            int startCycle = this.client.getGameCycle() + toReplaceWith.getStartMovement();
            this.norecurse = true;
            Projectile p = this.client.createProjectile(toReplaceWith.getProjectileId(), plane, playerPosLocal.getX(), playerPosLocal.getY(), startHeight, startCycle, endCycle, toReplaceWith.getSlope(), toReplaceWith.getStartHeight(), toReplaceWith.getEndHeight(), interacting, targetX, targetY);
            this.client.getProjectiles().addLast((Object)p);
            this.norecurse = false;
        }
        player.setGraphic(toReplaceWith.getCastGfx());
        player.setSpotAnimFrame(0);
        if (player.getInteracting() != null) {
            if (toReplace.getHitGfx() != -1) {
                int graphic = player.getInteracting().getGraphic();
                if (graphic == toReplace.getHitGfx() || graphic == 85) {
                    player.getInteracting().setGraphic(toReplaceWith.getHitGfx());
                    player.getInteracting().setGraphicHeight(toReplaceWith.getHitGfxHeight());
                }
            } else {
                this.delayedGfxToApply = toReplaceWith.getHitGfx();
                this.delayedGfxHeightToApply = toReplaceWith.getHitGfxHeight();
                this.actorToApplyDelayedGfxTo = player.getInteracting();
                this.timeToApplyDelayedGfx = endCycle;
            }
        }
    }

    private void createScytheSwing() {
        Color scytheSwingColor;
        int id;
        this.scytheSwingCountdown = -1;
        WorldPoint point = this.client.getLocalPlayer().getWorldLocation();
        Actor interacting = this.client.getLocalPlayer().getInteracting();
        int x = 0;
        int y = 0;
        if (interacting == null || !(interacting instanceof NPC)) {
            int orientation = this.client.getLocalPlayer().getOrientation();
            if (orientation > 442 && orientation < 582) {
                x = -1;
                id = 4006;
            } else if (orientation > 1466 && orientation < 1606) {
                x = 1;
                id = 4003;
            } else if (orientation > 512 && orientation < 1536) {
                y = 1;
                id = 4004;
            } else {
                y = -1;
                id = 4005;
            }
        } else {
            boolean directeast;
            WorldPoint targetPoint = interacting.getWorldLocation();
            int targetSize = ((NPC)interacting).getTransformedComposition().getSize();
            int halfTargetSizeRoundedDown = (targetSize - 1) / 2;
            int playerx = point.getX();
            int playery = point.getY();
            int npcw = targetPoint.getX();
            int npcn = targetPoint.getY() + targetSize - 1;
            int npce = targetPoint.getX() + targetSize - 1;
            int npcs = targetPoint.getY();
            boolean directwest = playerx == npcw - 1 && playery == npcs + halfTargetSizeRoundedDown;
            boolean bl = directeast = playerx == npce + 1 && playery == npcs + halfTargetSizeRoundedDown;
            if (directwest) {
                x = 1;
                id = 4003;
            } else if (directeast) {
                x = -1;
                id = 4006;
            } else if (playery >= npcs + halfTargetSizeRoundedDown) {
                y = -1;
                id = 4005;
            } else {
                y = 1;
                id = 4004;
            }
        }
        point = new WorldPoint(point.getX() + x, point.getY() + y, point.getPlane());
        RuneLiteObject runeLiteObject = this.client.createRuneLiteObject();
        Color color = scytheSwingColor = this.currentScytheGraphicEffect != null ? this.currentScytheGraphicEffect.color : null;
        if (scytheSwingColor != null) {
            Model model = ((ModelData)this.client.loadModelData(id).cloneVertices().cloneColors().recolor((short)960, JagexColor.rgbToHSL((int)scytheSwingColor.getRGB(), (double)1.0)).translate(0, -85, 0)).light();
            runeLiteObject.setModel(model);
        } else {
            runeLiteObject.setModel(this.client.loadModel(id));
        }
        runeLiteObject.setAnimation(this.client.loadAnimation(1204));
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        runeLiteObject.setLocation(localPoint, this.client.getPlane());
        runeLiteObject.setActive(true);
    }

    public void demoCast(ProjectileCast pc) {
        Player p = this.client.getLocalPlayer();
        if (p == null) {
            return;
        }
        if (pc.projectileId != -1) {
            WorldPoint wl = p.getWorldLocation();
            LocalPoint ll = p.getLocalLocation();
            int targetx = ll.getX() + (int)(700.0 * Math.cos((double)(-512 - p.getOrientation()) / 2048.0 * 2.0 * Math.PI));
            int targety = ll.getY() + (int)(700.0 * Math.sin((double)(-512 - p.getOrientation()) / 2048.0 * 2.0 * Math.PI));
            int height = Perspective.getTileHeight((Client)this.client, (LocalPoint)p.getLocalLocation(), (int)p.getWorldLocation().getPlane()) + pc.height;
            this.norecurse = true;
            Projectile projectile = this.client.createProjectile(pc.projectileId, wl.getPlane(), ll.getX(), ll.getY(), height, this.client.getGameCycle() + pc.startMovement, this.client.getGameCycle() + 100, pc.slope, pc.startHeight, pc.endHeight, null, targetx, targety);
            this.client.getProjectiles().addLast((Object)projectile);
            this.norecurse = false;
        }
        if (pc.castAnimation != -1) {
            p.setAnimation(pc.castAnimation);
            p.setAnimationFrame(0);
        }
        if (pc.castGfx != -1) {
            p.createSpotAnim("demo".hashCode(), pc.castGfx, 92, 0);
        }
    }

    private void updateAnimations() {
        List<Swap> matchingSwaps = this.getApplicableSwaps();
        List<Swap.AnimationReplacement> replacements = matchingSwaps.stream().flatMap(swap -> swap.animationReplacements.stream().filter(replacement -> replacement.animationSet != null && replacement.animationtypeToReplace != null).sorted()).collect(Collectors.toList());
        this.currentAnimations = this.previewAnimationReplacements != null ? this.previewAnimationReplacements : new AnimationReplacements(replacements);
        this.setPlayerPoseAnimations();
        this.projectileSwaps = matchingSwaps.stream().flatMap(swap -> swap.getProjectileSwaps().stream()).filter(swap -> swap.getToReplace() != null && swap.getToReplaceWith() != null).collect(Collectors.toList());
        this.currentScytheGraphicEffect = matchingSwaps.stream().filter(swap -> swap.getGraphicEffects().stream().anyMatch(e -> e.type == GraphicEffect.Type.SCYTHE_SWING)).flatMap(swap -> swap.getGraphicEffects().stream()).findAny().orElse(null);
    }

    public String itemDisplayName(int itemId) {
        return Constants.getName(itemId, this.itemManager.getItemComposition(itemId).getName());
    }

    public String itemName(Integer itemId) {
        String s;
        if (itemId == null) {
            return "\"null\"";
        }
        String string = s = itemId == null ? "\"null\"" : "\"" + this.itemManager.getItemComposition(itemId.intValue()).getName() + "\"";
        if (s.equals("\"null\"")) {
            s = Integer.toString(itemId);
        }
        return s;
    }

    private void setPlayerPoseAnimations() {
        Player player = this.client.getLocalPlayer();
        if (player == null || this.naturalPlayerPoseAnimations.isEmpty()) {
            return;
        }
        if (AnimationSet.doNotReplaceIdles.contains(this.naturalPlayerPoseAnimations.get(Constants.ActorAnimation.IDLE.ordinal()))) {
            return;
        }
        for (Constants.ActorAnimation animation : Constants.ActorAnimation.values()) {
            Integer animationId = this.currentAnimations.getAnimation(animation.getType());
            if (animationId == null) {
                animationId = this.naturalPlayerPoseAnimations.get(animation.ordinal());
            }
            animation.setAnimation((Actor)player, animationId);
        }
    }

    @Subscribe(priority=-1000.0f)
    public void onAnimationChanged(AnimationChanged e) {
        Player player = this.client.getLocalPlayer();
        if (!e.getActor().equals(player)) {
            return;
        }
        this.lastRealAnimation = player.getAnimation();
        this.checkForPossibleNoProjectileSpell(player);
        this.swapPlayerAnimation();
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged e) {
        if (e.getSource() != this.client.getLocalPlayer()) {
            return;
        }
    }

    private void checkForPossibleNoProjectileSpell(Player player) {
        if (this.lastRealAnimation == 811 || this.lastRealAnimation == 1978 || this.lastRealAnimation == 1979 || this.lastRealAnimation == 8972 || this.lastRealAnimation == 8974 || this.lastRealAnimation == 8977) {
            this.handlePossibleNoProjectileSpellInClientTick = true;
        }
    }

    @Subscribe(priority=1.0f)
    public void onPlayerChanged(PlayerChanged playerChanged) {
        if (playerChanged.getPlayer() != this.client.getLocalPlayer()) {
            return;
        }
        this.equippedItemsFromKit = IntStream.of(this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds()).map(i -> this.itemManager.canonicalize(i - 512)).boxed().collect(Collectors.toList());
        this.recordNaturalPlayerPoseAnimations();
        this.transmogManager.reapplyTransmog();
        this.updateAnimations();
    }

    private void recordNaturalPlayerPoseAnimations() {
        this.naturalPlayerPoseAnimations.clear();
        Player player = this.client.getLocalPlayer();
        for (Constants.ActorAnimation animation : Constants.ActorAnimation.values()) {
            this.naturalPlayerPoseAnimations.add(animation.getAnimation((Actor)player));
        }
    }

    public void doItemSearch(Consumer<ChatBoxFilterableSearch.SelectionResult> onItemChosen, SearchType searchType) {
        this.doItemSearch(onItemChosen, () -> {}, searchType);
    }

    public void doItemSearch(Consumer<ChatBoxFilterableSearch.SelectionResult> onItemChosen, Runnable onItemDeleted, SearchType searchType) {
        this.doItemSearch(onItemChosen, onItemDeleted, searchType, null);
    }

    public void doItemSearch(Consumer<ChatBoxFilterableSearch.SelectionResult> onItemChosen, Runnable onItemDeleted, SearchType searchType, Swap swap) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.pluginPanel), "This plugin uses the in-game item search panel; you must be logged in to use this.", "Log in to choose items", 0);
            return;
        }
        this.chatboxPanelManager.close();
        this.clientThread.invokeLater(() -> {
            this.itemSearch.tooltipText("select");
            this.itemSearch.onItemSelected(onItemChosen);
            this.itemSearch.onItemDeleted(onItemDeleted);
            this.itemSearch.setType(searchType);
            this.itemSearch.onItemMouseOvered(searchType == SearchType.MODEL_SWAP ? itemId -> this.setPreviewItem((Integer)itemId, swap != null && (swap.animationReplacements.isEmpty() || swap.animationReplacements.size() == 1 && swap.animationReplacements.get((int)0).auto != -1)) : (searchType == SearchType.SPELL_R ? spellId -> {
                if (spellId != -1) {
                    this.demoCast(Constants.projectilesById[spellId]);
                }
            } : null));
            this.itemSearch.build();
            this.clientUI.requestFocus();
        });
    }

    private void setPreviewItem(Integer itemId, boolean previewAnimations) {
        this.previewItem = itemId;
        this.transmogManager.changeTransmog();
        AnimationSet animationSet = Constants.getAnimationSet(itemId);
        this.previewAnimationReplacements = animationSet == null || !previewAnimations ? null : new AnimationReplacements(Collections.singletonList(new Swap.AnimationReplacement(animationSet, Swap.AnimationType.ALL)));
        this.updateAnimations();
    }

    public AsyncBufferedImage getItemImage(int itemId) {
        return this.itemManager.getImage(itemId);
    }

    public BufferedImage getSpellImage(ProjectileCast projectileCast) {
        return projectileCast.getSpriteIdIcon() != -1 ? this.spriteManager.getSprite(projectileCast.getSpriteIdIcon(), 0) : this.itemManager.getImage(projectileCast.getItemIdIcon());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            if (this.transmogSets != null) {
                this.showSidePanel(!this.config.hideSidePanel());
            }
        } else if (event.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getLocalPlayer() == null) {
                return;
            }
            if (this.client.getLocalPlayer().getPlayerComposition() != null) {
                this.transmogManager.reapplyTransmog();
            }
        }
    }

    public void demoAnimation(Integer animation) {
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            player.setAnimation(animation.intValue());
            player.setAnimationFrame(0);
            if (this.currentScytheGraphicEffect != null) {
                this.scytheSwingCountdown = 20;
            }
        }
    }

    public Integer getWikiScrapeSlot(int itemId) {
        ItemStats itemStats = this.itemManager.getItemStats(itemId, false);
        if (itemStats == null) {
            return null;
        }
        ItemEquipmentStats equipment = itemStats.getEquipment();
        if (equipment == null) {
            return null;
        }
        return equipment.getSlot();
    }

    public Integer[] getApplicableModelSwaps() {
        SlotAndKitId slotForItem;
        Integer[] genericTransmog = new Integer[KitType.values().length];
        Integer[] specificTransmog = new Integer[KitType.values().length];
        for (Swap swap : this.getApplicableSwaps()) {
            Integer[] transmogMap = swap.appliesSpecificallyToGear(this.equippedItemsFromKit, this) ? specificTransmog : genericTransmog;
            for (Integer modelSwap : swap.getModelSwaps()) {
                SlotAndKitId slotForItem2 = this.getSlotAndKitForItem(modelSwap, swap);
                if (slotForItem2 == null || transmogMap[slotForItem2.slot] != null) continue;
                transmogMap[slotForItem2.slot] = slotForItem2.kitId;
            }
        }
        for (int i = 0; i < specificTransmog.length; ++i) {
            if (specificTransmog[i] == null) continue;
            genericTransmog[i] = specificTransmog[i];
        }
        if (this.previewItem != -1 && (slotForItem = this.getSlotAndKitForItem(this.previewItem, null)) != null) {
            genericTransmog[slotForItem.slot] = slotForItem.kitId;
        }
        return genericTransmog;
    }

    private List<Swap> getApplicableSwaps() {
        return this.transmogSets.stream().filter(TransmogSet::isEnabled).flatMap(set -> set.getSwaps().stream()).filter(swap -> swap.appliesToGear(this.equippedItemsFromKit, this)).collect(Collectors.toList());
    }

    public Integer getMySlot(int modelSwap) {
        if (modelSwap < 0) {
            Constants.NegativeId negativeId = Constants.mapNegativeId(modelSwap);
            if (negativeId.type == Constants.NegativeIdsMap.HIDE_SLOT || negativeId.type == Constants.NegativeIdsMap.SHOW_SLOT) {
                return negativeId.id;
            }
            return null;
        }
        return this.getSlotForNonNegativeModelId(modelSwap);
    }

    public Integer getSlotForNonNegativeModelId(int modelSwap) {
        Integer slot = Constants.SLOT_OVERRIDES.get(modelSwap);
        if (slot != null && slot != -1) {
            return slot;
        }
        ItemStats itemStats = this.itemManager.getItemStats(modelSwap, false);
        if (itemStats == null || itemStats.getEquipment() == null) {
            return null;
        }
        return itemStats.getEquipment().getSlot();
    }

    public SlotAndKitId getSlotAndKitForItem(int modelSwap, Swap swap) {
        int slotOverride;
        if (modelSwap < 0) {
            Constants.NegativeId negativeId = Constants.mapNegativeId(modelSwap);
            if (negativeId.type == Constants.NegativeIdsMap.HIDE_SLOT) {
                return new SlotAndKitId(negativeId.id, 0);
            }
            if (negativeId.type == Constants.NegativeIdsMap.SHOW_SLOT) {
                return new SlotAndKitId(negativeId.id, -1);
            }
            return null;
        }
        int n = slotOverride = swap != null ? swap.getSlotOverride(modelSwap) : -1;
        if (slotOverride == -1) {
            Integer slot = this.getSlotForNonNegativeModelId(modelSwap);
            slotOverride = slot != null ? slot : Constants.WEAPON_SLOT;
        }
        return new SlotAndKitId(slotOverride, modelSwap);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals(GROUP_NAME) && e.getKey().equals("hideSidePanel")) {
            this.showSidePanel(!this.config.hideSidePanel());
        }
    }

    private void showSidePanel(boolean showSidePanel) {
        SwingUtilities.invokeLater(() -> {
            if (showSidePanel) {
                if (this.navigationButton != null) {
                    return;
                }
                this.pluginPanel = new WeaponAnimationReplacerPluginPanel(this);
                this.pluginPanel.rebuild();
                BufferedImage icon = ImageUtil.loadImageResource(WeaponAnimationReplacerPlugin.class, (String)"panel_icon.png");
                this.navigationButton = NavigationButton.builder().tooltip("Weapon Animation Replacer").icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
                this.clientToolbar.addNavigation(this.navigationButton);
            } else {
                if (this.navigationButton == null) {
                    return;
                }
                this.clientToolbar.removeNavigation(this.navigationButton);
                this.navigationButton = null;
                this.pluginPanel = null;
            }
        });
    }

    public List<TransmogSet> getTransmogSets() {
        return this.transmogSets;
    }

    static {
        renames.put("Godsword", "Godsword (Armadyl)");
        renames.put("unarmed", "Unarmed");
        renames.put("shortsword/scim/saeldor", "Dragon longsword/Saeldor");
        renames.put("staff2/wand", "Staff2/Wand");
        renames.put("Knife", "Knife (non-dragon)");
    }

    public static final class SlotAndKitId {
        private final int slot;
        private final int kitId;

        public SlotAndKitId(int slot, int kitId) {
            this.slot = slot;
            this.kitId = kitId;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getKitId() {
            return this.kitId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlotAndKitId)) {
                return false;
            }
            SlotAndKitId other = (SlotAndKitId)o;
            if (this.getSlot() != other.getSlot()) {
                return false;
            }
            return this.getKitId() == other.getKitId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSlot();
            result = result * 59 + this.getKitId();
            return result;
        }

        public String toString() {
            return "WeaponAnimationReplacerPlugin.SlotAndKitId(slot=" + this.getSlot() + ", kitId=" + this.getKitId() + ")";
        }
    }

    public static enum SearchType {
        TRIGGER_ITEM,
        MODEL_SWAP,
        SPELL_L,
        SPELL_R;

    }

    private static final class AnimationReplacements {
        private final Map<Swap.AnimationType, Integer> replacements = new HashMap<Swap.AnimationType, Integer>();

        public AnimationReplacements() {
            this(Collections.emptyList());
        }

        public AnimationReplacements(List<Swap.AnimationReplacement> replacements) {
            for (int i = replacements.size() - 1; i >= 0; --i) {
                this.applyReplacement(replacements.get(i));
            }
        }

        public void applyReplacement(Swap.AnimationReplacement replacement) {
            this.replaceAnimations(replacement.animationSet, replacement.animationtypeToReplace, replacement.animationtypeReplacement);
        }

        private void replaceAnimations(AnimationSet animationSet, Swap.AnimationType toReplace, Swap.AnimationType replacement) {
            block5: {
                block6: {
                    block4: {
                        Swap.AnimationType attackAnimation;
                        if (toReplace != Swap.AnimationType.ATTACK) break block4;
                        int defaultAttack = -1;
                        Iterator<Swap.AnimationType> iterator = animationSet.getAttackAnimations().iterator();
                        while (iterator.hasNext() && (defaultAttack = animationSet.getAnimation(attackAnimation = iterator.next())) == -1) {
                        }
                        ArrayList<Swap.AnimationType> children = new ArrayList<Swap.AnimationType>(Swap.AnimationType.ATTACK.children);
                        children.add(Swap.AnimationType.ATTACK);
                        for (Swap.AnimationType child : children) {
                            int id = animationSet.getAnimation(replacement == null ? child : replacement);
                            if (id == -1) {
                                id = defaultAttack;
                            }
                            if (id == -1) continue;
                            this.replacements.put(child, id);
                        }
                        break block5;
                    }
                    if (toReplace.hasChildren()) break block6;
                    int id = animationSet.getAnimation(replacement == null ? toReplace : replacement);
                    if (id == -1) break block5;
                    this.replacements.put(toReplace, id);
                    break block5;
                }
                for (Swap.AnimationType child : toReplace.children) {
                    this.replaceAnimations(animationSet, child, replacement);
                }
            }
        }

        public Integer getAnimation(Swap.AnimationType type) {
            return this.replacements.get((Object)type);
        }
    }
}

