/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.weaponanimationreplacer.Constants;
import com.weaponanimationreplacer.WeaponAnimationReplacerPlugin;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.RuneScapeProfileChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TransmogrificationManager {
    private static final Logger log = LoggerFactory.getLogger(TransmogrificationManager.class);
    public static final int SHOW_SLOT = -1;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private WeaponAnimationReplacerPlugin plugin;
    private int[] currentActualState;
    private int transmogHash = 0;
    private int baseArmsKit = -1;
    private int baseHairKit = -1;
    private int baseJawKit = -1;
    private static final int DEFAULT_MALE_ARMS = 284;
    private static final int DEFAULT_FEMALE_ARMS = 320;
    private static final int DEFAULT_MALE_HAIR = 256;
    private static final int DEFAULT_FEMALE_HAIR = 301;
    private static final int DEFAULT_MALE_JAW = 270;

    public void startUp() {
        this.onRuneScapeProfileChanged(new RuneScapeProfileChanged());
    }

    public void shutDown() {
        this.removeTransmog();
        this.currentActualState = null;
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        Integer baseArmsKit = (Integer)this.configManager.getRSProfileConfiguration("WeaponAnimationReplacer", "baseArmsKit", Integer.class);
        this.baseArmsKit = baseArmsKit != null ? baseArmsKit : -1;
        Integer baseHairKit = (Integer)this.configManager.getRSProfileConfiguration("WeaponAnimationReplacer", "baseHairKit", Integer.class);
        this.baseHairKit = baseHairKit != null ? baseHairKit : -1;
        Integer baseJawKit = (Integer)this.configManager.getRSProfileConfiguration("WeaponAnimationReplacer", "baseJawKit", Integer.class);
        this.baseJawKit = baseJawKit != null ? baseJawKit : -1;
    }

    public void reapplyTransmog() {
        int currentHash = Arrays.hashCode(this.client.getLocalPlayer().getPlayerComposition().getEquipmentIds());
        if (currentHash == this.transmogHash) {
            return;
        }
        this.currentActualState = null;
        this.changeTransmog();
    }

    void changeTransmog() {
        Integer head;
        Integer torso;
        Integer jaw;
        Integer hair;
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.getLocalPlayer() == null) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        int[] kits = player.getPlayerComposition().getEquipmentIds();
        if (this.currentActualState != null) {
            System.arraycopy(this.currentActualState, 0, kits, 0, kits.length);
        } else {
            this.storeState(kits);
        }
        Integer[] swaps = this.plugin.getApplicableModelSwaps();
        Integer arms = swaps[Constants.ARMS_SLOT];
        if (arms != null && arms == -1) {
            swaps[Constants.ARMS_SLOT] = this.getBaseArms() - 512;
        }
        if ((hair = swaps[Constants.HAIR_SLOT]) != null && hair == -1) {
            swaps[Constants.HAIR_SLOT] = this.getBaseHair() - 512;
        }
        if ((jaw = swaps[Constants.JAW_SLOT]) != null && jaw == -1) {
            swaps[Constants.JAW_SLOT] = this.getBaseJaw() - 512;
        }
        if ((torso = swaps[Constants.TORSO_SLOT]) != null && swaps[Constants.ARMS_SLOT] == null) {
            swaps[Constants.ARMS_SLOT] = Constants.SHOWS_ARMS.contains(torso) ? this.getBaseArms() - 512 : 0;
        }
        if ((head = swaps[Constants.HEAD_SLOT]) != null) {
            if (swaps[Constants.HAIR_SLOT] == null) {
                swaps[Constants.HAIR_SLOT] = !Constants.HIDES_HAIR.contains(head) ? this.getBaseHair() - 512 : 0;
            }
            if (swaps[Constants.JAW_SLOT] == null && kits[Constants.JAW_SLOT] <= 512) {
                swaps[Constants.JAW_SLOT] = !Constants.HIDES_JAW.contains(head) ? this.getBaseJaw() - 512 : 0;
            }
        }
        for (int i = 0; i < swaps.length; ++i) {
            if (swaps[i] == null) continue;
            kits[i] = swaps[i] + 512;
        }
        player.getPlayerComposition().setHash();
        this.transmogHash = Arrays.hashCode(kits);
    }

    private void storeState(int[] kits) {
        int jaw;
        int hair;
        int arms = kits[Constants.ARMS_SLOT];
        if (arms != 0 && arms != this.baseArmsKit) {
            this.baseArmsKit = arms;
            this.configManager.setRSProfileConfiguration("WeaponAnimationReplacer", "baseArmsKit", (Object)this.baseArmsKit);
        }
        if ((hair = kits[Constants.HAIR_SLOT]) != 0 && hair != this.baseHairKit) {
            this.baseHairKit = hair;
            this.configManager.setRSProfileConfiguration("WeaponAnimationReplacer", "baseHairKit", (Object)this.baseHairKit);
        }
        if ((jaw = kits[Constants.JAW_SLOT]) != 0 && jaw != this.baseJawKit) {
            this.baseJawKit = jaw;
            this.configManager.setRSProfileConfiguration("WeaponAnimationReplacer", "baseJawKit", (Object)this.baseJawKit);
        }
        this.currentActualState = (int[])kits.clone();
    }

    void removeTransmog() {
        if (this.currentActualState == null) {
            return;
        }
        PlayerComposition comp = this.client.getLocalPlayer().getPlayerComposition();
        int[] kits = comp.getEquipmentIds();
        System.arraycopy(this.currentActualState, 0, kits, 0, kits.length);
        comp.setHash();
    }

    private int getBaseJaw() {
        if (this.client.getLocalPlayer().getPlayerComposition().getGender() == 1) {
            return 0;
        }
        return this.getBaseModel(this.baseJawKit, 0, 270);
    }

    private int getBaseHair() {
        return this.getBaseModel(this.baseHairKit, 301, 256);
    }

    private int getBaseArms() {
        return this.getBaseModel(this.baseArmsKit, 320, 284);
    }

    private int getBaseModel(int baseKit, int defaultFemaleModel, int defaultMaleModel) {
        return baseKit != -1 ? baseKit : (this.client.getLocalPlayer().getPlayerComposition().getGender() == 1 ? defaultFemaleModel : defaultMaleModel);
    }
}

