/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.google.common.primitives.Ints;
import com.weaponanimationreplacer.AnimationSet;
import com.weaponanimationreplacer.ChatBoxFilterableSearch;
import com.weaponanimationreplacer.Constants;
import com.weaponanimationreplacer.GraphicEffect;
import com.weaponanimationreplacer.ProjectileCast;
import com.weaponanimationreplacer.ProjectileSwap;
import com.weaponanimationreplacer.Swap;
import com.weaponanimationreplacer.TransmogSet;
import com.weaponanimationreplacer.WeaponAnimationReplacerPlugin;
import com.weaponanimationreplacer.WeaponAnimationReplacerPluginPanel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import net.runelite.api.Projectile;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.kit.KitType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.ColorJButton;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransmogSetPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TransmogSetPanel.class);
    private static final int DEFAULT_FILL_OPACITY = 75;
    private static final Border NAME_BOTTOM_BORDER = new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorScheme.DARK_GRAY_COLOR), BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR));
    private static final ImageIcon MOVE_RULE_UP_ICON;
    private static final ImageIcon MOVE_RULE_UP_ICON_HOVER;
    private static final ImageIcon MOVE_RULE_DOWN_ICON;
    private static final ImageIcon MOVE_RULE_DOWN_ICON_HOVER;
    private static final ImageIcon DELETE_RULE_ICON;
    private static final ImageIcon DELETE_RULE_ICON_HOVER;
    private static final ImageIcon EDIT_ICON;
    private static final ImageIcon EDIT_ICON_HOVER;
    private static final ImageIcon ADD_ICON;
    private static final ImageIcon ADD_HOVER_ICON;
    private static final ImageIcon GEAR_ICON;
    private static final ImageIcon GEAR_HOVER_ICON;
    private static final ImageIcon VISIBLE_ICON;
    private static final ImageIcon INVISIBLE_ICON;
    private final WeaponAnimationReplacerPlugin plugin;
    private final int index;
    private final TransmogSet transmogSet;
    private final FlatTextField nameInput = new FlatTextField();
    private WeaponAnimationReplacerPluginPanel pluginPanel;
    private Component bottomPanel;

    TransmogSetPanel(WeaponAnimationReplacerPlugin plugin, TransmogSet transmogSet, WeaponAnimationReplacerPluginPanel pluginPanel, int index) {
        this.plugin = plugin;
        this.transmogSet = transmogSet;
        this.pluginPanel = pluginPanel;
        this.index = index;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.add((Component)this.createNamePanel(), "North");
        if (!transmogSet.isMinimized()) {
            this.add((Component)this.createBottomPanel(), "Center");
        }
    }

    private JPanel createBottomPanel() {
        JPanel bottomContainer = new JPanel();
        bottomContainer.setLayout(new BoxLayout(bottomContainer, 1));
        bottomContainer.setBorder(new EmptyBorder(8, 0, 8, 0));
        bottomContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        for (int i = 0; i < this.transmogSet.getSwaps().size(); ++i) {
            bottomContainer.add(this.createSwapPanel(this.transmogSet.getSwaps().get(i), i, this.transmogSet.getSwaps().size()));
        }
        JButton addSwapButton = new JButton("add swap");
        addSwapButton.addActionListener(e -> this.addNewSwap(this.transmogSet));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(addSwapButton);
        bottomContainer.add(p);
        this.bottomPanel = bottomContainer;
        return bottomContainer;
    }

    private Component createSwapPanel(Swap swap, int index, int total) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel restrictionAndModelSwapPanel = this.getRestrictionAndModelSwapPanel();
        restrictionAndModelSwapPanel.add(this.createSwapOptionsPanel(this.transmogSet, swap, index != 0, index != total - 1));
        List<Integer> itemRestrictions = swap.getItemRestrictions();
        if (itemRestrictions.isEmpty()) {
            itemRestrictions = Collections.singletonList(-1);
        }
        for (Integer n : itemRestrictions) {
            restrictionAndModelSwapPanel.add(this.createItemRestrictionButton(swap, n));
        }
        restrictionAndModelSwapPanel.add(new JLabel("->"));
        List<Integer> modelSwaps = swap.getModelSwaps();
        if (modelSwaps.isEmpty()) {
            modelSwaps = Collections.singletonList(-1);
        }
        for (Integer modelSwap : modelSwaps) {
            restrictionAndModelSwapPanel.add(this.createModelSwapButton(swap, modelSwap));
        }
        panel.add((Component)restrictionAndModelSwapPanel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (!swap.animationReplacements.isEmpty()) {
            for (int i = 0; i < swap.animationReplacements.size(); ++i) {
                jPanel.add(this.createAnimationReplacementPanel(swap, i, swap.animationReplacements.size()));
            }
        }
        if (!swap.getProjectileSwaps().isEmpty()) {
            for (int i = 0; i < swap.getProjectileSwaps().size(); ++i) {
                jPanel.add(this.createProjectileSwapPanel(swap, i, swap.getProjectileSwaps().size()));
            }
        }
        if (!swap.getGraphicEffects().isEmpty()) {
            for (int i = 0; i < swap.getGraphicEffects().size(); ++i) {
                jPanel.add(this.createGraphicsEffectPanel(swap, i, swap.getGraphicEffects().size()));
            }
        }
        panel.add((Component)jPanel, "Center");
        return panel;
    }

    private JPanel getRestrictionAndModelSwapPanel() {
        JPanel restrictionAndModelSwapPanel = new JPanel(new FlowLayout(0){

            @Override
            public Dimension minimumLayoutSize(Container target) {
                int parentWidth = target.getParent().getWidth();
                if (parentWidth == 0) {
                    parentWidth = 215;
                }
                int nmembers = target.getComponentCount();
                int y = 0;
                int x = TransmogSetPanel.this.getInsets().left + TransmogSetPanel.this.getInsets().right + this.getHgap() * 2;
                for (int i = 0; i < nmembers; ++i) {
                    Component component = target.getComponent(i);
                    int newX = (int)((double)x + component.getPreferredSize().getWidth());
                    if (newX > parentWidth) {
                        y += 40;
                        newX = (int)(component.getPreferredSize().getWidth() + (double)this.getHgap());
                    }
                    x = newX + this.getHgap();
                }
                return new Dimension(super.minimumLayoutSize((Container)target).width, y + 40);
            }

            @Override
            public Dimension preferredLayoutSize(Container target) {
                return this.minimumLayoutSize(target);
            }
        }){};
        return restrictionAndModelSwapPanel;
    }

    private Component createItemRestrictionButton(Swap swap, int initialItemId) {
        return this.createItemSelectionButton(initialItemId, () -> swap.removeTriggerItem(initialItemId), (result, plugin) -> swap.addTriggerItem(result.itemId, result.slot, (WeaponAnimationReplacerPlugin)((Object)plugin)), WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM, "Any", null, null);
    }

    private Component createModelSwapButton(Swap swap, int initialItemId) {
        int slotOverride = swap.getSlotOverride(initialItemId);
        String overlayString = slotOverride != -1 ? KitType.values()[slotOverride].name() : null;
        return this.createItemSelectionButton(initialItemId, () -> swap.removeModelSwap(initialItemId), (result, plugin) -> swap.addModelSwap(result.itemId, (WeaponAnimationReplacerPlugin)((Object)plugin), result.slot), WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP, "None", overlayString, swap);
    }

    private Component createSpellSwapLButton(ProjectileSwap swap) {
        return this.createItemSelectionButton(swap.toReplace, () -> {
            swap.toReplace = -1;
        }, (result, plugin) -> {
            swap.toReplace = result.itemId;
        }, WeaponAnimationReplacerPlugin.SearchType.SPELL_L, "None", null, null);
    }

    private Component createSpellSwapRButton(ProjectileSwap swap) {
        return this.createItemSelectionButton(swap.toReplaceWith, () -> {
            swap.toReplaceWith = -1;
        }, (result, plugin) -> {
            swap.toReplaceWith = result.itemId;
            swap.toReplaceWithCustom = null;
        }, WeaponAnimationReplacerPlugin.SearchType.SPELL_R, "None", swap.toReplaceWithCustom != null ? "c" : null, null);
    }

    private ItemSelectionButton createItemSelectionButton(int initialId, Runnable onRemove, BiConsumer<ChatBoxFilterableSearch.SelectionResult, WeaponAnimationReplacerPlugin> onAdd, WeaponAnimationReplacerPlugin.SearchType type, String whenEmpty, String overlayString, Swap swap) {
        ItemSelectionButton weaponIdInput = new ItemSelectionButton();
        weaponIdInput.nameWhenEmpty = whenEmpty;
        weaponIdInput.overlayString = overlayString;
        if (type == WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM || type == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP) {
            weaponIdInput.setItem(initialId);
        } else {
            weaponIdInput.setSpell(initialId);
        }
        Runnable deleteItem = () -> this.plugin.clientThread.invoke(() -> {
            onRemove.run();
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        });
        Runnable addItem = () -> this.plugin.doItemSearch(result -> {
            onAdd.accept((ChatBoxFilterableSearch.SelectionResult)result, this.plugin);
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }, deleteItem, type, swap);
        weaponIdInput.addActionListener(e -> ((e.getModifiers() & 2) > 0 ? deleteItem : addItem).run());
        JPopupMenu rightClickMenu = new JPopupMenu();
        JMenuItem addItemsMenuItem = new JMenuItem("Add more items");
        addItemsMenuItem.addActionListener(e -> addItem.run());
        rightClickMenu.add(addItemsMenuItem);
        JMenuItem removeItemMenuItem = new JMenuItem("Remove (ctrl-click)");
        removeItemMenuItem.addActionListener(e -> deleteItem.run());
        rightClickMenu.add(removeItemMenuItem);
        weaponIdInput.setComponentPopupMenu(rightClickMenu);
        return weaponIdInput;
    }

    private Component createSwapOptionsPanel(TransmogSet transmogSet, Swap swap, boolean moveUp, boolean moveDown) {
        final IconLabelButton label = new IconLabelButton(GEAR_ICON, GEAR_HOVER_ICON, () -> {}, "Options");
        final JPopupMenu menu = new JPopupMenu();
        Color labelForeground = label.getForeground();
        menu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.addMenuItem(menu, "Add trigger item", e -> this.addTriggerItem(swap));
        this.addMenuItem(menu, "Add model swap", e -> this.addModelSwap(swap));
        this.addMenuItem(menu, "Add animation swap", e -> this.addAnimationReplacement(swap));
        this.addMenuItem(menu, "Add projectile swap", e -> this.addProjectileSwap(swap));
        this.addMenuItem(menu, "Add graphic effect", e -> this.addGraphicEffect(swap));
        if (moveUp) {
            this.addMenuItem(menu, "Move up", e -> this.moveSwap(transmogSet, swap, -1));
        }
        if (moveDown) {
            this.addMenuItem(menu, "Move down", e -> this.moveSwap(transmogSet, swap, 1));
        }
        this.addMenuItem(menu, "Remove swap", e -> this.removeSwap(transmogSet, swap));
        label.addMouseListener(new MouseAdapter(){
            private Color lastForeground;

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Component source = (Component)mouseEvent.getSource();
                Point location = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(location, source);
                menu.show(source, location.x, location.y);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.lastForeground = label.getForeground();
                label.setForeground(ColorScheme.BRAND_ORANGE);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                label.setForeground(this.lastForeground);
            }
        });
        return label;
    }

    private void addNewSwap(TransmogSet transmogSet) {
        transmogSet.addNewSwap();
        SwingUtilities.invokeLater(this::rebuild);
    }

    private void removeSwap(TransmogSet transmogSet, Swap swap) {
        transmogSet.removeSwap(swap);
        this.plugin.clientThread.invokeLater(this.plugin::handleTransmogSetChange);
        SwingUtilities.invokeLater(this::rebuild);
    }

    private void moveSwap(TransmogSet transmogSet, Swap swap, int i) {
        transmogSet.moveSwap(swap, i);
        this.plugin.clientThread.invokeLater(this.plugin::handleTransmogSetChange);
        SwingUtilities.invokeLater(this::rebuild);
    }

    private void addAnimationReplacement(Swap swap) {
        this.plugin.clientThread.invokeLater(() -> {
            swap.addNewAnimationReplacement();
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        });
    }

    private void addProjectileSwap(Swap swap) {
        swap.addNewProjectileSwap();
        this.plugin.clientThread.invokeLater(this.plugin::handleTransmogSetChange);
        SwingUtilities.invokeLater(this::rebuild);
    }

    private void addGraphicEffect(Swap swap) {
        swap.addNewGraphicEffect();
        this.plugin.clientThread.invokeLater(this.plugin::handleTransmogSetChange);
        SwingUtilities.invokeLater(this::rebuild);
    }

    private void addModelSwap(Swap swap) {
        this.plugin.doItemSearch(result -> {
            swap.addModelSwap(result.itemId, this.plugin, result.slot);
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }, () -> {}, WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP, swap);
    }

    private void addTriggerItem(Swap swap) {
        this.plugin.doItemSearch(result -> {
            swap.addTriggerItem(result.itemId, this.plugin);
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }, WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM);
    }

    private void addMenuItem(JPopupMenu menu, String name, ActionListener actionListener) {
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.addActionListener(actionListener);
        menu.add(menuItem);
    }

    private void rebuild() {
        if (this.bottomPanel != null) {
            this.remove(this.bottomPanel);
            this.bottomPanel = null;
        }
        if (!this.transmogSet.isMinimized()) {
            this.add((Component)this.createBottomPanel(), "Center");
        }
        this.pluginPanel.revalidate();
    }

    private Component createAnimationReplacementPanel(Swap swap, int i, int size) {
        final Swap.AnimationReplacement animationReplacement = swap.animationReplacements.get(i);
        JPanel animationReplacementPanel = new JPanel();
        animationReplacementPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        animationReplacementPanel.setLayout(new BoxLayout(animationReplacementPanel, 1));
        animationReplacementPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (animationReplacement.auto != -1) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            JLabel autoLabel = new JLabel("(auto-generated animation swap)");
            p.add(autoLabel);
            animationReplacementPanel.add(p);
        }
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        row1.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        row1.add(new JLabel("Replace "));
        JComboBox<Swap.AnimationType> animToReplace = new JComboBox<Swap.AnimationType>(Swap.AnimationType.comboBoxOrder.toArray(new Swap.AnimationType[0]));
        animToReplace.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(value == null ? "<choose>" : ((Swap.AnimationType)((Object)value)).getComboBoxName());
                return rendererComponent;
            }
        });
        animToReplace.setSelectedItem((Object)animationReplacement.animationtypeToReplace);
        animToReplace.setPrototypeDisplayValue(Swap.AnimationType.RUN);
        animToReplace.addActionListener(e -> this.plugin.clientThread.invokeLater(() -> {
            animationReplacement.animationtypeToReplace = (Swap.AnimationType)((Object)((Object)((Object)animToReplace.getSelectedItem())));
            animationReplacement.auto = -1;
            if (!Swap.AnimationType.ATTACK.appliesTo(animationReplacement.animationtypeToReplace)) {
                animationReplacement.animationtypeReplacement = null;
            }
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }));
        row1.add(animToReplace);
        animationReplacementPanel.add(row1);
        JPanel row2 = new JPanel();
        row2.setLayout(new BoxLayout(row2, 0));
        row2.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        row2.add(new JLabel("with"));
        JComboBox<AnimationSet> animationSetToUse = new JComboBox<AnimationSet>(AnimationSet.animationSets.toArray(new AnimationSet[0]));
        animationSetToUse.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(value == null ? "<choose>" : ((AnimationSet)value).getComboBoxName());
                return rendererComponent;
            }
        });
        animationSetToUse.setSelectedItem(animationReplacement.animationSet);
        animationSetToUse.addActionListener(e -> this.plugin.clientThread.invokeLater(() -> {
            animationReplacement.animationSet = (AnimationSet)animationSetToUse.getSelectedItem();
            animationReplacement.auto = -1;
            if (Swap.AnimationType.ATTACK.appliesTo(animationReplacement.animationtypeToReplace) && animationReplacement.animationSet != null) {
                List<Swap.AnimationType> actions = animationReplacement.animationSet.getAttackAnimations();
                Optional<Swap.AnimationType> match = actions.stream().filter(action -> action == animationReplacement.animationtypeReplacement).findAny();
                if (match.isPresent()) {
                    animationReplacement.animationtypeReplacement = match.get();
                } else if (!actions.isEmpty()) {
                    animationReplacement.animationtypeReplacement = actions.get(0);
                }
            }
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }));
        row2.add(animationSetToUse);
        animationReplacementPanel.add(row2);
        if (Swap.AnimationType.ATTACK.appliesTo(animationReplacement.animationtypeToReplace) && animationReplacement.animationSet != null) {
            JPanel row3 = new JPanel();
            row3.setLayout(new BoxLayout(row3, 0));
            row3.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            row3.add(new JLabel("attack animation:"));
            final List<Swap.AnimationType> actions = animationReplacement.animationSet.getAttackAnimations();
            log.debug("actions is : " + actions);
            JComboBox<Swap.AnimationType> attackToUse = new JComboBox<Swap.AnimationType>(actions.toArray(new Swap.AnimationType[0]));
            attackToUse.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value == null || !actions.contains(value)) {
                        this.setText("<choose>");
                    } else {
                        this.setText(AnimationSet.getDescription(animationReplacement.animationSet, (Swap.AnimationType)((Object)value)));
                    }
                    return rendererComponent;
                }
            });
            attackToUse.setSelectedItem((Object)animationReplacement.animationtypeReplacement);
            animationReplacement.animationtypeReplacement = (Swap.AnimationType)((Object)attackToUse.getSelectedItem());
            attackToUse.addActionListener(e -> this.plugin.clientThread.invokeLater(() -> {
                animationReplacement.animationtypeReplacement = (Swap.AnimationType)((Object)((Object)((Object)attackToUse.getSelectedItem())));
                animationReplacement.auto = -1;
                this.plugin.handleTransmogSetChange();
                this.plugin.demoAnimation(animationReplacement.animationSet.getAnimation(animationReplacement.animationtypeReplacement));
            }));
            row3.add(attackToUse);
            animationReplacementPanel.add(row3);
        }
        return new EntryPanel(false, true, true, i == size - 1, animationReplacementPanel, () -> {
            swap.animationReplacements.remove(i);
            this.plugin.clientThread.invoke(this.plugin::handleTransmogSetChange);
            SwingUtilities.invokeLater(this::rebuild);
        }, () -> this.plugin.clientThread.invokeLater(() -> {
            swap.addNewAnimationReplacement();
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }), enabled -> this.plugin.clientThread.invoke(this.plugin::handleTransmogSetChange));
    }

    private Component createProjectileSwapPanel(Swap swap, int i, int size) {
        ProjectileSwap projectileSwap = swap.getProjectileSwaps().get(i);
        JPanel animationReplacementPanel = new JPanel();
        animationReplacementPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        animationReplacementPanel.setLayout(new BoxLayout(animationReplacementPanel, 1));
        animationReplacementPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        row1.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel projectileSwapPanel = this.getRestrictionAndModelSwapPanel();
        projectileSwapPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        projectileSwapPanel.add(this.createSpellSwapLButton(projectileSwap));
        projectileSwapPanel.add(new JLabel("->"));
        projectileSwapPanel.add(this.createSpellSwapRButton(projectileSwap));
        projectileSwapPanel.add(this.createSpellEditPanel(projectileSwap, swap, i));
        row1.add(projectileSwapPanel);
        animationReplacementPanel.add(row1);
        if (this.pluginPanel.currentlyEditingThisSwap == swap && this.pluginPanel.currentlyEditingThisProjectileSwapIndex == i) {
            JPanel row = this.createProjectileEditPanel(projectileSwap);
            animationReplacementPanel.add(row);
        }
        return new EntryPanel(false, true, true, i == size - 1, animationReplacementPanel, () -> {
            swap.getProjectileSwaps().remove(i);
            this.plugin.clientThread.invoke(this.plugin::handleTransmogSetChange);
            SwingUtilities.invokeLater(this::rebuild);
        }, () -> this.plugin.clientThread.invokeLater(() -> {
            swap.addNewProjectileSwap();
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }), enabled -> this.plugin.clientThread.invoke(this.plugin::handleTransmogSetChange));
    }

    private JPanel createProjectileEditPanel(ProjectileSwap projectileSwap) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ProjectileCast defaultValue = projectileSwap.getToReplaceWith() != null ? projectileSwap.getToReplaceWith() : ProjectileCast.p().build();
        this.createProjectileEditPanelRow("anim id", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setCastAnimation((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.castAnimation, panel);
        this.createProjectileEditPanelRow("cast gfx", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setCastGfx((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.castGfx, panel);
        this.createProjectileEditPanelRow("hit gfx", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setHitGfx((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.client.getLocalPlayer().createSpotAnim("demo".hashCode(), projectileSwap.toReplaceWithCustom.hitGfx, 0, 0);
        }, defaultValue.hitGfx, panel);
        this.createProjectileEditPanelRow("hit gfx height", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setHitGfxHeight((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.client.getLocalPlayer().createSpotAnim("demo".hashCode(), projectileSwap.toReplaceWithCustom.hitGfxHeight, 0, 0);
        }, defaultValue.hitGfxHeight, panel);
        this.createProjectileEditPanelRow("projectile id", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setProjectileId((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.projectileId, panel);
        this.createProjectileEditPanelRow("arc", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setSlope((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.slope, panel, -64, 64);
        this.createProjectileEditPanelRow("delay", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setStartMovement((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.startMovement, panel);
        this.createProjectileEditPanelRow("start offset", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setStartHeight((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.startHeight, panel);
        this.createProjectileEditPanelRow("start height", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setHeight((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.height, panel, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.createProjectileEditPanelRow("end height", ce -> {
            projectileSwap.createCustomIfNull();
            projectileSwap.toReplaceWithCustom.setEndHeight((Integer)((JSpinner)ce.getSource()).getValue());
            this.plugin.saveTransmogSets();
            this.plugin.demoCast(projectileSwap.getToReplaceWith());
        }, defaultValue.endHeight, panel);
        JButton demo = new JButton("demo");
        demo.addActionListener(al -> this.plugin.demoCast(projectileSwap.getToReplaceWith()));
        panel.add(demo);
        JButton projectileIdsButton = new JButton("projectile ids");
        projectileIdsButton.addActionListener(al -> new ProjectileIdsFrame().setVisible(true));
        panel.add(projectileIdsButton);
        return panel;
    }

    private void createProjectileEditPanelRow(String labelName, ChangeListener cl, int initialValue, JPanel panel) {
        this.createProjectileEditPanelRow(labelName, cl, initialValue, panel, -1, Integer.MAX_VALUE);
    }

    private void createProjectileEditPanelRow(String labelName, ChangeListener cl, int initialValue, JPanel panel, int min, int max) {
        JPanel row = new JPanel();
        row.setLayout(new BoxLayout(row, 0));
        JLabel label = new JLabel(labelName);
        row.add(label);
        JSpinner input = this.createIntSpinner(initialValue, cl, min, max);
        row.add(input);
        panel.add(row);
    }

    private JSpinner createIntSpinner(int value, ChangeListener onChange, int min, int max) {
        value = Ints.constrainToRange((int)value, (int)min, (int)max);
        SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, 1);
        JSpinner spinner = new JSpinner(model);
        JComponent editor = spinner.getEditor();
        JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
        int SPINNER_FIELD_WIDTH = 6;
        spinnerTextField.setColumns(SPINNER_FIELD_WIDTH);
        spinner.addChangeListener(onChange);
        return spinner;
    }

    private Component createSpellEditPanel(ProjectileSwap projectileSwap, Swap swap, int index) {
        JButton button = new JButton("", EDIT_ICON);
        button.addActionListener(e -> {
            if (this.pluginPanel.currentlyEditingThisSwap == swap && this.pluginPanel.currentlyEditingThisProjectileSwapIndex == index) {
                this.pluginPanel.currentlyEditingThisSwap = null;
                this.pluginPanel.currentlyEditingThisProjectileSwapIndex = -1;
            } else {
                this.pluginPanel.currentlyEditingThisSwap = swap;
                this.pluginPanel.currentlyEditingThisProjectileSwapIndex = index;
            }
            this.rebuild();
        });
        return button;
    }

    private Component createGraphicsEffectPanel(Swap swap, int i, int size) {
        final GraphicEffect graphicEffect = swap.getGraphicEffects().get(i);
        JPanel animationReplacementPanel = new JPanel();
        animationReplacementPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        animationReplacementPanel.setLayout(new BoxLayout(animationReplacementPanel, 1));
        animationReplacementPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel row1 = new JPanel();
        row1.setLayout(new BoxLayout(row1, 0));
        row1.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        row1.add(new JLabel("Effect: "));
        JComboBox<GraphicEffect.Type> graphicEffectTypeComboBox = new JComboBox<GraphicEffect.Type>(GraphicEffect.Type.values());
        graphicEffectTypeComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(value == null ? "<choose>" : ((GraphicEffect.Type)((Object)value)).name());
                return rendererComponent;
            }
        });
        graphicEffectTypeComboBox.setSelectedItem((Object)graphicEffect.type);
        graphicEffectTypeComboBox.setPrototypeDisplayValue(GraphicEffect.Type.SCYTHE_SWING);
        graphicEffectTypeComboBox.addActionListener(e -> this.plugin.clientThread.invokeLater(() -> {
            graphicEffect.type = (GraphicEffect.Type)((Object)((Object)((Object)graphicEffectTypeComboBox.getSelectedItem())));
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }));
        row1.add(graphicEffectTypeComboBox);
        animationReplacementPanel.add(row1);
        if (graphicEffect.type == GraphicEffect.Type.SCYTHE_SWING) {
            ColorJButton colorPickerBtn;
            JPanel row2 = new JPanel();
            row2.setLayout(new BoxLayout(row2, 0));
            row2.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            row2.add(new JLabel("Color:"));
            Color existing = graphicEffect.color;
            final boolean alphaHidden = true;
            if (existing == null) {
                colorPickerBtn = new ColorJButton("Pick a color", Color.BLACK);
            } else {
                String colorHex = "#" + (alphaHidden ? ColorUtil.colorToHexCode((Color)existing) : ColorUtil.colorToAlphaHexCode((Color)existing)).toUpperCase();
                colorPickerBtn = new ColorJButton(colorHex, existing);
            }
            colorPickerBtn.setFocusable(false);
            colorPickerBtn.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RuneliteColorPicker colorPicker = TransmogSetPanel.this.plugin.colorPickerManager.create(SwingUtilities.windowForComponent(TransmogSetPanel.this), colorPickerBtn.getColor(), "scythe swing color", alphaHidden);
                    colorPicker.setLocation(TransmogSetPanel.this.getLocationOnScreen());
                    colorPicker.setOnColorChange(c -> {
                        graphicEffect2.color = c;
                        colorPickerBtn.setColor(c);
                        colorPickerBtn.setText("#" + (alphaHidden ? ColorUtil.colorToHexCode((Color)c) : ColorUtil.colorToAlphaHexCode((Color)c)).toUpperCase());
                    });
                    colorPicker.setOnClose(c -> TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> {
                        graphicEffect2.color = c;
                        TransmogSetPanel.this.plugin.handleTransmogSetChange();
                        SwingUtilities.invokeLater(() -> TransmogSetPanel.this.rebuild());
                    }));
                    colorPicker.setVisible(true);
                }
            });
            row2.add((Component)colorPickerBtn);
            animationReplacementPanel.add(row2);
        }
        return new EntryPanel(false, false, true, i == size - 1, animationReplacementPanel, () -> {
            swap.getGraphicEffects().remove(i);
            this.plugin.clientThread.invoke(this.plugin::handleTransmogSetChange);
            SwingUtilities.invokeLater(this::rebuild);
        }, () -> this.plugin.clientThread.invokeLater(() -> {
            swap.addNewGraphicEffect();
            this.plugin.handleTransmogSetChange();
            SwingUtilities.invokeLater(this::rebuild);
        }), enabled -> {});
    }

    private JPanel createNamePanel() {
        JPanel nameWrapper = new JPanel(new BorderLayout());
        nameWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        nameWrapper.setBorder(NAME_BOTTOM_BORDER);
        JPanel nameActions = new JPanel(new BorderLayout(2, 0));
        nameActions.setBorder(new EmptyBorder(-1, 0, 0, 8));
        nameActions.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final IconLabelButton rename = new IconLabelButton(EDIT_ICON, EDIT_ICON_HOVER, () -> {}, "Edit name");
        rename.onClick = () -> {
            this.nameInput.setEditable(true);
            rename.setVisible(false);
            this.nameInput.getTextField().requestFocus();
            this.nameInput.getTextField().selectAll();
        };
        rename.setFont(FontManager.getRunescapeSmallFont());
        rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
        this.nameInput.setText(this.transmogSet.getName());
        this.nameInput.setBorder(null);
        this.nameInput.setEditable(false);
        this.nameInput.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInput.setPreferredSize(new Dimension(-1, 24));
        this.nameInput.getTextField().setForeground(Color.WHITE);
        this.nameInput.getTextField().setBorder(new EmptyBorder(-1, 8, 0, 0));
        this.nameInput.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(() -> {
                        TransmogSetPanel.this.transmogSet.setName(TransmogSetPanel.this.nameInput.getText());
                        TransmogSetPanel.this.plugin.saveTransmogSets();
                    });
                } else if (e.getKeyCode() == 27) {
                    TransmogSetPanel.this.nameInput.setText(TransmogSetPanel.this.transmogSet.getName());
                } else {
                    return;
                }
                TransmogSetPanel.this.nameInput.setEditable(false);
                TransmogSetPanel.this.plugin.clientUI.requestFocus();
                rename.setVisible(true);
            }
        });
        this.nameInput.getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtilities.invokeLater(() -> {
                    TransmogSetPanel.this.transmogSet.setName(TransmogSetPanel.this.nameInput.getText());
                    TransmogSetPanel.this.plugin.saveTransmogSets();
                });
                TransmogSetPanel.this.nameInput.setEditable(false);
                rename.setVisible(true);
            }
        });
        this.nameInput.getTextField().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!TransmogSetPanel.this.nameInput.getTextField().isEditable()) {
                    TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> {
                        TransmogSetPanel.this.transmogSet.setMinimized(!TransmogSetPanel.this.transmogSet.isMinimized());
                        SwingUtilities.invokeLater(() -> TransmogSetPanel.this.rebuild());
                    });
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker().darker());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                rename.setForeground(ColorScheme.LIGHT_GRAY_COLOR.darker());
            }
        });
        nameWrapper.add((Component)this.nameInput, "Center");
        nameWrapper.add((Component)rename, "East");
        return new EntryPanel(true, this.transmogSet.isEnabled(), false, this.transmogSet.isMinimized(), true, true, true, true, false, nameWrapper, () -> {
            int delete = JOptionPane.showConfirmDialog((Component)((Object)this.pluginPanel), "Are you sure you want to delete that?", "Delete?", 2);
            if (delete != 0) {
                return;
            }
            this.plugin.clientThread.invokeLater(() -> this.plugin.deleteTransmogSet(this.index));
        }, () -> this.plugin.clientThread.invokeLater(() -> this.plugin.addNewTransmogSet(this.index + 1)), b -> this.plugin.clientThread.invokeLater(() -> {
            this.transmogSet.setEnabled((boolean)b);
            this.plugin.handleTransmogSetChange();
        }));
    }

    static {
        BufferedImage upImg = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"up_small.png");
        MOVE_RULE_UP_ICON = new ImageIcon(upImg);
        MOVE_RULE_UP_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)upImg, (int)-150));
        BufferedImage downImg = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"down_small.png");
        MOVE_RULE_DOWN_ICON = new ImageIcon(downImg);
        MOVE_RULE_DOWN_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)downImg, (int)-150));
        BufferedImage deleteImg = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"delete.png");
        DELETE_RULE_ICON = new ImageIcon(deleteImg);
        DELETE_RULE_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)deleteImg, (int)-50));
        BufferedImage editImg = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"edit.png");
        EDIT_ICON = new ImageIcon(editImg);
        EDIT_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)editImg, (int)-150));
        BufferedImage addIcon = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"add_icon.png");
        ADD_ICON = new ImageIcon(addIcon);
        ADD_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)addIcon, (float)0.53f));
        BufferedImage gearIcon = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"gear_icon.png");
        GEAR_ICON = new ImageIcon(gearIcon);
        GEAR_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)gearIcon, (float)0.53f));
        BufferedImage visibleIcon = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"visible_icon.png");
        VISIBLE_ICON = new ImageIcon(visibleIcon);
        BufferedImage invisibleIcon = ImageUtil.loadImageResource(TransmogSetPanel.class, (String)"invisible_icon.png");
        INVISIBLE_ICON = new ImageIcon(invisibleIcon);
    }

    public class ItemSelectionButton
    extends JButton {
        String nameWhenEmpty = "None";
        String overlayString = null;

        public ItemSelectionButton() {
            this.setBackground(ColorScheme.LIGHT_GRAY_COLOR);
            this.setPreferredSize(new Dimension(35, 35));
            this.setMaximumSize(new Dimension(35, 35));
            this.setMinimumSize(new Dimension(30, 30));
        }

        public void setItem(int itemId) {
            if (itemId == -1) {
                this.setIcon(null);
                this.setText(this.nameWhenEmpty);
                this.setBorder(null);
            } else if (itemId < 0) {
                Constants.NegativeId negativeId = Constants.mapNegativeId(itemId);
                if (negativeId.type == Constants.NegativeIdsMap.HIDE_SLOT) {
                    TransmogSetPanel.this.plugin.clientThread.invoke(() -> {
                        AsyncBufferedImage itemImage = TransmogSetPanel.this.plugin.getItemImage(Constants.HiddenSlot.values()[negativeId.id].iconIdToShow);
                        AsyncBufferedImage bankFillerImage = TransmogSetPanel.this.plugin.getItemImage(20594);
                        SwingUtilities.invokeLater(() -> this.lambda$setItem$0((BufferedImage)itemImage, (BufferedImage)bankFillerImage));
                    });
                    this.setText(null);
                    SwingUtilities.invokeLater(() -> this.setToolTipText("hide " + KitType.values()[negativeId.id]));
                } else if (negativeId.type == Constants.NegativeIdsMap.SHOW_SLOT) {
                    AsyncBufferedImage itemImage = TransmogSetPanel.this.plugin.getItemImage(Constants.ShownSlot.values()[negativeId.id].iconIdToShow);
                    itemImage.addTo((JButton)this);
                    this.setText(null);
                    SwingUtilities.invokeLater(() -> this.setToolTipText("show " + KitType.values()[negativeId.id]));
                }
            } else {
                TransmogSetPanel.this.plugin.clientThread.invoke(() -> {
                    String name = TransmogSetPanel.this.plugin.itemDisplayName(itemId);
                    AsyncBufferedImage itemImage = TransmogSetPanel.this.plugin.getItemImage(Constants.getIconId(itemId));
                    Runnable processImage = () -> SwingUtilities.invokeLater(() -> {
                        if (this.overlayString != null) {
                            BufferedImage copy = new BufferedImage(itemImage.getWidth(), itemImage.getHeight(), itemImage.getType());
                            Graphics2D graphics = (Graphics2D)copy.getGraphics();
                            graphics.drawImage((Image)itemImage, 0, 0, null);
                            graphics.drawString(this.overlayString, 0, 24);
                            this.setIcon(new ImageIcon(copy));
                        } else {
                            this.setIcon(new ImageIcon((Image)itemImage));
                        }
                        this.setToolTipText(name);
                    });
                    itemImage.onLoaded(processImage);
                    processImage.run();
                });
            }
        }

        public void setSpell(int spellId) {
            if (spellId == -1) {
                this.setIcon(null);
                this.setText(this.nameWhenEmpty);
                this.setBorder(null);
            } else {
                ProjectileCast projectileCast = Constants.projectilesById[spellId];
                this.setText(null);
                TransmogSetPanel.this.plugin.clientThread.invoke(() -> {
                    BufferedImage spellImage = TransmogSetPanel.this.plugin.getSpellImage(projectileCast);
                    this.setIcon(new ImageIcon(spellImage));
                    String name = projectileCast.getName(TransmogSetPanel.this.plugin.itemManager);
                    SwingUtilities.invokeLater(() -> {
                        if (this.overlayString != null) {
                            BufferedImage copy = new BufferedImage(spellImage.getWidth(), spellImage.getHeight(), spellImage.getType());
                            Graphics2D graphics = (Graphics2D)copy.getGraphics();
                            graphics.drawImage((Image)spellImage, 0, 0, null);
                            graphics.drawString(this.overlayString, 0, 10);
                            this.setIcon(new ImageIcon(copy));
                        } else {
                            this.setIcon(new ImageIcon(spellImage));
                        }
                        this.setToolTipText(name);
                    });
                });
            }
        }

        private /* synthetic */ void lambda$setItem$0(BufferedImage itemImage, BufferedImage bankFillerImage) {
            BufferedImage copy = new BufferedImage(itemImage.getWidth(), itemImage.getHeight(), itemImage.getType());
            Graphics2D graphics = (Graphics2D)copy.getGraphics();
            graphics.drawImage((Image)itemImage, 0, 0, null);
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
            graphics.setComposite(ac);
            graphics.drawImage((Image)bankFillerImage, 0, 0, null);
            this.setIcon(new ImageIcon(copy));
        }
    }

    private class ProjectileIdsFrame
    extends JFrame {
        private JPanel panel;
        private final List<PCwI> liveProjectiles;
        private final List<PCwI> finishedProjectiles;
        private boolean paused;

        public ProjectileIdsFrame() {
            super("Projectile ids, most recently seen last");
            this.liveProjectiles = new ArrayList<PCwI>();
            this.finishedProjectiles = new ArrayList<PCwI>();
            this.paused = false;
            this.setSize(500, 500);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TransmogSetPanel.this.plugin.eventBus.unregister((Object)this);
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            TransmogSetPanel.this.plugin.eventBus.register((Object)this);
            this.add(this.panel);
        }

        @Subscribe
        public void onProjectileMoved(ProjectileMoved e) {
            if (this.paused) {
                return;
            }
            Projectile projectile = e.getProjectile();
            if (TransmogSetPanel.this.plugin.client.getGameCycle() >= projectile.getStartCycle()) {
                return;
            }
            this.liveProjectiles.add(new PCwI(new ProjectileCast(-1, "", -1, -1, -1, -1, projectile.getId(), projectile.getInteracting() != null ? projectile.getInteracting().getGraphic() : -1, projectile.getInteracting() != null ? projectile.getInteracting().getGraphicHeight() : -1, projectile.getStartCycle() - TransmogSetPanel.this.plugin.client.getGameCycle(), projectile.getStartHeight(), projectile.getHeight(), projectile.getEndHeight(), projectile.getSlope(), true), projectile.getEndCycle()));
        }

        @Subscribe
        public void onClientTick(ClientTick e) {
            boolean redraw = false;
            block0: for (int j = 0; j < this.liveProjectiles.size(); ++j) {
                PCwI liveProjectile = this.liveProjectiles.get(j);
                if (liveProjectile.i > TransmogSetPanel.this.plugin.client.getGameCycle()) continue;
                this.liveProjectiles.remove(j);
                --j;
                this.finishedProjectiles.add(new PCwI(liveProjectile.pc, 0));
                for (int i = 0; i < this.finishedProjectiles.size(); ++i) {
                    PCwI finishedProjectile = this.finishedProjectiles.get(i);
                    if (!finishedProjectile.pc.equals(liveProjectile.pc)) continue;
                    PCwI remove = this.finishedProjectiles.remove(i);
                    this.finishedProjectiles.add(new PCwI(remove.pc, remove.i + 1));
                    redraw = true;
                    continue block0;
                }
            }
            if (redraw) {
                SwingUtilities.invokeLater(() -> {
                    this.panel.removeAll();
                    JCheckBox pause = new JCheckBox("pause", this.paused);
                    pause.addChangeListener(ce -> {
                        this.paused = ((JCheckBox)ce.getSource()).isSelected();
                    });
                    this.panel.add(pause);
                    for (PCwI projectile : this.finishedProjectiles) {
                        JPanel panel1 = new JPanel();
                        panel1.setLayout(new BoxLayout(panel1, 0));
                        JButton demo = new JButton("demo");
                        demo.addActionListener(al -> TransmogSetPanel.this.plugin.demoCast(projectile.pc));
                        panel1.add(demo);
                        JButton use = new JButton("use");
                        use.addActionListener(al -> {
                            if (TransmogSetPanel.this.pluginPanel.currentlyEditingThisSwap == null || TransmogSetPanel.this.pluginPanel.currentlyEditingThisProjectileSwapIndex == -1) {
                                this.panel.add(new JLabel("not editing a projectile swap"));
                                this.panel.revalidate();
                                this.panel.repaint();
                                return;
                            }
                            ProjectileSwap projectileSwap = TransmogSetPanel.this.pluginPanel.currentlyEditingThisSwap.getProjectileSwaps().get(TransmogSetPanel.this.pluginPanel.currentlyEditingThisProjectileSwapIndex);
                            projectileSwap.createCustomIfNull();
                            projectileSwap.toReplaceWithCustom.projectileId = projectile.pc.projectileId;
                            if (projectile.pc.hitGfx != -1) {
                                projectileSwap.toReplaceWithCustom.hitGfx = projectile.pc.hitGfx;
                            }
                            projectileSwap.toReplaceWithCustom.startMovement = projectile.pc.startMovement;
                            projectileSwap.toReplaceWithCustom.startHeight = projectile.pc.startHeight;
                            projectileSwap.toReplaceWithCustom.endHeight = projectile.pc.endHeight;
                            projectileSwap.toReplaceWithCustom.slope = projectile.pc.slope;
                            TransmogSetPanel.this.pluginPanel.rebuild();
                        });
                        panel1.add(use);
                        panel1.add(new JLabel("id " + projectile.pc.projectileId + " hitGfx " + projectile.pc.hitGfx + " (seen " + projectile.i + " times)"));
                        this.panel.add(panel1);
                    }
                    this.panel.revalidate();
                    this.panel.repaint();
                });
            }
        }

        private final class PCwI {
            private final ProjectileCast pc;
            private final int i;

            public PCwI(ProjectileCast pc, int i) {
                this.pc = pc;
                this.i = i;
            }

            public ProjectileCast getPc() {
                return this.pc;
            }

            public int getI() {
                return this.i;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PCwI)) {
                    return false;
                }
                PCwI other = (PCwI)o;
                ProjectileCast this$pc = this.getPc();
                ProjectileCast other$pc = other.getPc();
                if (this$pc == null ? other$pc != null : !((Object)this$pc).equals(other$pc)) {
                    return false;
                }
                return this.getI() == other.getI();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ProjectileCast $pc = this.getPc();
                result = result * 59 + ($pc == null ? 43 : ((Object)$pc).hashCode());
                result = result * 59 + this.getI();
                return result;
            }

            public String toString() {
                return "TransmogSetPanel.ProjectileIdsFrame.PCwI(pc=" + this.getPc() + ", i=" + this.getI() + ")";
            }
        }
    }

    public class EntryPanel
    extends JPanel {
        public EntryPanel(boolean checkbox, boolean enabled, boolean x, boolean plus, JPanel panel, Runnable onDelete, Runnable onAdd, Consumer<Boolean> onEnable) {
            this(checkbox, enabled, false, false, false, false, false, x, plus, panel, onDelete, onAdd, onEnable);
        }

        public EntryPanel(boolean checkbox, boolean enabled, boolean minimize, boolean minimized, boolean updown, boolean up, boolean down, boolean x, boolean plus, JPanel panel, Runnable onDelete, Runnable onAdd, Consumer<Boolean> onEnable) {
            this.setLayout(new BorderLayout());
            this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (checkbox) {
                JCheckBox enabledCheckbox = new JCheckBox();
                enabledCheckbox.setSelected(enabled);
                enabledCheckbox.setIcon(enabled ? VISIBLE_ICON : INVISIBLE_ICON);
                enabledCheckbox.addActionListener(e -> {
                    TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> onEnable.accept(enabledCheckbox.isSelected()));
                    enabledCheckbox.setIcon(enabledCheckbox.isSelected() ? VISIBLE_ICON : INVISIBLE_ICON);
                });
                this.add((Component)enabledCheckbox, "West");
            }
            JPanel rightSide = new JPanel();
            rightSide.setLayout(new BoxLayout(rightSide, 0));
            rightSide.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            if (minimize) {
                JLabel xButton = this.makeButton(minimized ? " + " : " - ", () -> TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> {
                    TransmogSetPanel.this.transmogSet.setMinimized(!minimized);
                    SwingUtilities.invokeLater(() -> TransmogSetPanel.this.rebuild());
                }));
                rightSide.add(xButton);
            }
            if (updown) {
                rightSide.add(new IconLabelButton(MOVE_RULE_UP_ICON, MOVE_RULE_UP_ICON_HOVER, () -> TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> TransmogSetPanel.this.plugin.moveTransmogSet(TransmogSetPanel.this.index, true)), "Move up in list and priority"));
                rightSide.add(new IconLabelButton(MOVE_RULE_DOWN_ICON, MOVE_RULE_DOWN_ICON_HOVER, () -> TransmogSetPanel.this.plugin.clientThread.invokeLater(() -> TransmogSetPanel.this.plugin.moveTransmogSet(TransmogSetPanel.this.index, false)), "Move down in list and priority"));
            }
            if (x) {
                rightSide.add(new IconLabelButton(DELETE_RULE_ICON, DELETE_RULE_ICON_HOVER, onDelete, "Delete"));
            }
            if (plus) {
                rightSide.add(new IconLabelButton(ADD_ICON, ADD_HOVER_ICON, onAdd, "Add another"));
            }
            this.add((Component)rightSide, "East");
            this.add((Component)panel, "Center");
        }

        private JLabel makeButton(String text, final Runnable onClick) {
            JLabel label = new JLabel(text);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    onClick.run();
                }
            });
            return label;
        }
    }

    public static class IconLabelButton
    extends JLabel {
        private final Icon icon;
        private final Icon iconMouseovered;
        private Runnable onClick;

        public IconLabelButton(final Icon icon, final Icon iconMouseovered, Runnable onClick, String tooltip) {
            this.icon = icon;
            this.iconMouseovered = iconMouseovered;
            this.onClick = onClick;
            this.setIcon(icon);
            this.setToolTipText(tooltip);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    onClick.run();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.setIcon(iconMouseovered);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.setIcon(icon);
                }
            });
        }
    }
}

