/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.weaponanimationreplacer.Swap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TransmogSet {
    private String name = "";
    private boolean enabled = true;
    private boolean minimized = false;
    private final List<Swap> swaps = new ArrayList<Swap>();

    public TransmogSet() {
    }

    public TransmogSet(List<Swap> swaps) {
        this.swaps.addAll(swaps);
    }

    public static TransmogSet createTemplate() {
        return new TransmogSet(Collections.singletonList(new Swap()));
    }

    public void addNewSwap() {
        this.swaps.add(new Swap());
    }

    public void removeSwap(Swap swap) {
        this.swaps.remove(swap);
    }

    public void moveSwap(Swap swap, int i) {
        int swapIndex = this.swaps.indexOf(swap);
        if (swapIndex == -1) {
            throw new IllegalArgumentException();
        }
        if (swapIndex + i < 0 || swapIndex + i >= this.swaps.size()) {
            return;
        }
        this.swaps.remove(swap);
        this.swaps.add(swapIndex + i, swap);
    }

    public String toString() {
        return "TransmogSet{name='" + this.name + "', enabled=" + this.enabled + ", minimized=" + this.minimized + ", swaps=" + this.swaps + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransmogSet that = (TransmogSet)o;
        return this.enabled == that.enabled && this.minimized == that.minimized && this.name.equals(that.name) && this.swaps.equals(that.swaps);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.enabled, this.minimized, this.swaps);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    public List<Swap> getSwaps() {
        return this.swaps;
    }
}

