/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.weaponanimationreplacer.AnimationSet;
import com.weaponanimationreplacer.Constants;
import com.weaponanimationreplacer.GraphicEffect;
import com.weaponanimationreplacer.ProjectileSwap;
import com.weaponanimationreplacer.WeaponAnimationReplacerPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.runelite.api.EquipmentInventorySlot;

public class Swap {
    private final List<Integer> itemRestrictions;
    private final List<Integer> modelSwaps;
    public final List<AnimationReplacement> animationReplacements;
    private final List<ProjectileSwap> projectileSwaps;
    private final List<GraphicEffect> graphicEffects;
    private final Map<Integer, Integer> slotOverrides;
    private final Map<Integer, Integer> triggerItemSlotOverrides;
    private static final int[] MY_SLOT_ORDER = new int[]{2, 5, 6, 0, 7, 1, 8, 9, 3, 10, 11, 4, 12, 13};

    public Swap() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public Swap(List<Integer> itemRestrictions, List<Integer> modelSwaps, List<AnimationReplacement> animationReplacements, List<ProjectileSwap> projectileSwaps, List<GraphicEffect> graphicEffects) {
        this(itemRestrictions, modelSwaps, animationReplacements, projectileSwaps, graphicEffects, new HashMap<Integer, Integer>(), new HashMap<Integer, Integer>());
    }

    public Swap(List<Integer> itemRestrictions, List<Integer> modelSwaps, List<AnimationReplacement> animationReplacements, List<ProjectileSwap> projectileSwaps, List<GraphicEffect> graphicEffects, Map<Integer, Integer> slotOverrides, Map<Integer, Integer> triggerItemSlotOverrides) {
        this.itemRestrictions = new ArrayList<Integer>(itemRestrictions);
        this.modelSwaps = new ArrayList<Integer>(modelSwaps);
        this.animationReplacements = new ArrayList<AnimationReplacement>(animationReplacements);
        this.projectileSwaps = new ArrayList<ProjectileSwap>(projectileSwaps);
        this.graphicEffects = new ArrayList<GraphicEffect>(graphicEffects);
        this.slotOverrides = new HashMap<Integer, Integer>(slotOverrides);
        this.triggerItemSlotOverrides = new HashMap<Integer, Integer>(triggerItemSlotOverrides);
    }

    public List<Integer> getItemRestrictions() {
        return Collections.unmodifiableList(this.itemRestrictions);
    }

    public List<Integer> getModelSwaps() {
        return Collections.unmodifiableList(this.modelSwaps);
    }

    private int getModelSwapSlot(int itemId, WeaponAnimationReplacerPlugin plugin) {
        Integer integer = this.slotOverrides.get(itemId);
        if (integer != null) {
            return integer;
        }
        integer = plugin.getMySlot(itemId);
        if (integer != null) {
            return integer;
        }
        return -1;
    }

    private int getTriggerItemSlot(int itemId, WeaponAnimationReplacerPlugin plugin) {
        Integer integer = this.triggerItemSlotOverrides.get(itemId);
        if (integer != null) {
            return integer;
        }
        integer = plugin.getWikiScrapeSlot(itemId);
        if (integer != null) {
            return integer;
        }
        return -1;
    }

    public int getSlotOverride(int itemId) {
        return this.slotOverrides.getOrDefault(itemId, -1);
    }

    public void addModelSwap(int itemId, WeaponAnimationReplacerPlugin plugin) {
        this.addModelSwap(itemId, plugin, -1);
    }

    public void addModelSwap(int itemId, WeaponAnimationReplacerPlugin plugin, int customSlot) {
        AnimationSet animationSet;
        int targetSlot;
        if (itemId == -1) {
            return;
        }
        if (customSlot == -1) {
            Integer s = plugin.getMySlot(itemId);
            if (s == null || s.intValue() == EquipmentInventorySlot.RING.getSlotIdx() || s.intValue() == EquipmentInventorySlot.AMMO.getSlotIdx()) {
                return;
            }
            targetSlot = s;
        } else {
            targetSlot = customSlot;
        }
        this.modelSwaps.removeIf(id -> {
            boolean remove;
            if (id == itemId) {
                remove = true;
            } else {
                int slot = this.getModelSwapSlot((int)id, plugin);
                boolean bl = remove = slot == -1 || slot == targetSlot || slot == EquipmentInventorySlot.RING.getSlotIdx() || slot == EquipmentInventorySlot.AMMO.getSlotIdx();
            }
            if (remove) {
                this.slotOverrides.remove(id);
                this.removeAutoGeneratedAnimationReplacement((int)id);
            }
            return remove;
        });
        if (customSlot != -1) {
            this.slotOverrides.put(itemId, targetSlot);
        }
        int index = Collections.binarySearch(this.modelSwaps, itemId, this.itemComparator(i -> this.getModelSwapSlot((int)i, plugin)));
        this.modelSwaps.add(~index, itemId);
        if ((this.animationReplacements.size() == 1 && this.animationReplacements.get((int)0).auto != -1 || this.animationReplacements.isEmpty()) && (animationSet = Constants.getAnimationSet(itemId)) != null) {
            this.animationReplacements.clear();
            AnimationReplacement animationReplacement = new AnimationReplacement(animationSet, AnimationType.ALL);
            animationReplacement.auto = itemId;
            this.animationReplacements.add(animationReplacement);
        }
    }

    public void removeModelSwap(int prevItemId) {
        this.modelSwaps.remove((Object)prevItemId);
        this.slotOverrides.remove(prevItemId);
        this.removeAutoGeneratedAnimationReplacement(prevItemId);
    }

    private void removeAutoGeneratedAnimationReplacement(int itemId) {
        if (this.animationReplacements.size() == 1 && this.animationReplacements.get((int)0).auto == itemId) {
            this.animationReplacements.clear();
        }
    }

    public void replaceModelSwap(int prevItemId, int newItemId, WeaponAnimationReplacerPlugin plugin) {
        this.removeModelSwap(prevItemId);
        this.addModelSwap(newItemId, plugin);
    }

    public void addTriggerItem(int itemId, WeaponAnimationReplacerPlugin plugin) {
        this.addTriggerItem(itemId, -1, plugin);
    }

    public void addTriggerItem(int itemId, int slot, WeaponAnimationReplacerPlugin plugin) {
        this.removeTriggerItem(itemId);
        if (slot == -1) {
            Integer newItemSlot = plugin.getWikiScrapeSlot(itemId);
            if (newItemSlot == null || newItemSlot.intValue() == EquipmentInventorySlot.RING.getSlotIdx() || newItemSlot.intValue() == EquipmentInventorySlot.AMMO.getSlotIdx()) {
                return;
            }
        } else {
            this.triggerItemSlotOverrides.put(itemId, slot);
        }
        int index = Collections.binarySearch(this.itemRestrictions, itemId, this.itemComparator(i -> this.getTriggerItemSlot((int)i, plugin)));
        this.itemRestrictions.add(~index, itemId);
    }

    public void removeTriggerItem(int itemId) {
        this.itemRestrictions.remove((Object)itemId);
        this.triggerItemSlotOverrides.remove(itemId);
    }

    private Comparator<Integer> itemComparator(Function<Integer, Integer> getSlot) {
        return (id1, id2) -> {
            int slot2;
            int slot1 = (Integer)getSlot.apply((Integer)id1);
            if (slot1 == (slot2 = ((Integer)getSlot.apply((Integer)id2)).intValue())) {
                return Integer.compare(id1, id2);
            }
            if (slot1 == -1) {
                return -1;
            }
            if (slot2 == -1) {
                return 1;
            }
            return Integer.compare(MY_SLOT_ORDER[slot1], MY_SLOT_ORDER[slot2]);
        };
    }

    public void addNewAnimationReplacement() {
        this.animationReplacements.add(AnimationReplacement.createTemplate());
    }

    public void addNewGraphicEffect() {
        this.graphicEffects.add(GraphicEffect.createTemplate());
    }

    public boolean appliesToGear(List<Integer> equippedItemIds, WeaponAnimationReplacerPlugin plugin) {
        if (this.itemRestrictions.contains(-1) || this.itemRestrictions.isEmpty()) {
            return true;
        }
        return this.appliesSpecificallyToGear(equippedItemIds, plugin);
    }

    public boolean appliesSpecificallyToGear(List<Integer> equippedItemIds, WeaponAnimationReplacerPlugin plugin) {
        if (this.itemRestrictions.isEmpty()) {
            return false;
        }
        HashSet<Integer> slots = new HashSet<Integer>();
        HashSet<Integer> slotsSatisfied = new HashSet<Integer>();
        for (Integer itemRestriction : this.itemRestrictions) {
            if (itemRestriction == -1) {
                return false;
            }
            int slot = this.getTriggerItemSlot(itemRestriction, plugin);
            slots.add(slot);
            if (!equippedItemIds.contains(itemRestriction)) continue;
            slotsSatisfied.add(slot);
        }
        for (Integer slot : slots) {
            if (slotsSatisfied.contains(slot)) continue;
            return false;
        }
        return true;
    }

    public void updateForSortOrderAndUniqueness(WeaponAnimationReplacerPlugin plugin) {
        ArrayList<Integer> modelSwapsCopy = new ArrayList<Integer>(this.modelSwaps);
        Collections.reverse(modelSwapsCopy);
        this.modelSwaps.clear();
        for (Integer itemId : modelSwapsCopy) {
            this.addModelSwap(itemId, plugin);
        }
        ArrayList<Integer> itemRestrictionsCopy = new ArrayList<Integer>(this.itemRestrictions);
        this.itemRestrictions.clear();
        for (Integer itemId : itemRestrictionsCopy) {
            this.addTriggerItem(itemId, plugin);
        }
    }

    public void addNewProjectileSwap() {
        this.projectileSwaps.add(ProjectileSwap.createTemplate());
    }

    public String toString() {
        return this.itemRestrictions + " " + this.modelSwaps + " " + this.animationReplacements;
    }

    public List<ProjectileSwap> getProjectileSwaps() {
        return this.projectileSwaps;
    }

    public List<GraphicEffect> getGraphicEffects() {
        return this.graphicEffects;
    }

    public static enum AnimationType {
        STAND(new AnimationType[0]),
        WALK(new AnimationType[0]),
        RUN(new AnimationType[0]),
        WALK_BACKWARD(new AnimationType[0]),
        SHUFFLE_LEFT(new AnimationType[0]),
        SHUFFLE_RIGHT(new AnimationType[0]),
        ROTATE(new AnimationType[0]),
        ATTACK_STAB("Stab", new AnimationType[0]),
        ATTACK_SLASH("Slash", new AnimationType[0]),
        ATTACK_CRUSH("Crush", new AnimationType[0]),
        ATTACK_SPEC("Special", new AnimationType[0]),
        DEFEND(new AnimationType[0]),
        ATTACK_SLASH2("Slash2", new AnimationType[0]),
        ATTACK_CRUSH2("Crush2", new AnimationType[0]),
        ATTACK(ATTACK_STAB, ATTACK_SLASH, ATTACK_SLASH2, ATTACK_CRUSH, ATTACK_CRUSH2, ATTACK_SPEC),
        SHUFFLE(WALK_BACKWARD, SHUFFLE_LEFT, SHUFFLE_RIGHT, ROTATE),
        MOVEMENT(WALK, RUN, SHUFFLE),
        STAND_PLUS_MOVEMENT("Stand/Move", STAND, MOVEMENT),
        ALL(ATTACK, STAND_PLUS_MOVEMENT, DEFEND);

        public static final List<AnimationType> comboBoxOrder;
        public final List<AnimationType> children;
        public final String prettyName;

        private AnimationType(AnimationType ... children) {
            this((String)null, children);
        }

        private AnimationType(String prettyName, AnimationType ... children) {
            String s = this.toString().replaceAll("_", " ");
            this.prettyName = prettyName != null ? prettyName : s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
            this.children = Arrays.asList(children);
        }

        public boolean appliesTo(AnimationType type) {
            return this == type || this.children.stream().anyMatch(child -> child.appliesTo(type));
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public boolean hasChild(AnimationType type) {
            return this.children.stream().anyMatch(child -> child.appliesTo(type));
        }

        public String getComboBoxName() {
            int depth = 0;
            if (ATTACK.hasChild(this)) {
                depth = 2;
            } else if (MOVEMENT.hasChild(this)) {
                depth = 4;
            } else if (STAND_PLUS_MOVEMENT.hasChild(this)) {
                depth = 3;
            } else if (ALL.hasChild(this)) {
                depth = 1;
            }
            Object s = this.prettyName;
            for (int i = 0; i < depth; ++i) {
                s = "  " + (String)s;
            }
            return s;
        }

        static {
            comboBoxOrder = new ArrayList<AnimationType>();
            comboBoxOrder.add(ALL);
            comboBoxOrder.add(STAND_PLUS_MOVEMENT);
            comboBoxOrder.add(STAND);
            comboBoxOrder.add(MOVEMENT);
            comboBoxOrder.add(WALK);
            comboBoxOrder.add(RUN);
            comboBoxOrder.add(SHUFFLE);
            comboBoxOrder.add(ATTACK);
            AnimationType.ATTACK.children.forEach(comboBoxOrder::add);
        }
    }

    public static class AnimationReplacement
    implements Comparable<AnimationReplacement> {
        public AnimationSet animationSet;
        public AnimationType animationtypeToReplace;
        public AnimationType animationtypeReplacement;
        public int auto = -1;

        public static AnimationReplacement createTemplate() {
            return new AnimationReplacement(null, null, null);
        }

        public AnimationReplacement() {
            this.auto = -1;
        }

        public AnimationReplacement(AnimationSet animationSet, AnimationType animationtypeToReplace) {
            this(animationSet, animationtypeToReplace, null);
        }

        public AnimationReplacement(AnimationSet animationSet, AnimationType animationtypeToReplace, AnimationType animationtypeReplacement) {
            this.animationSet = animationSet;
            this.animationtypeToReplace = animationtypeToReplace;
            this.animationtypeReplacement = animationtypeReplacement;
        }

        @Override
        public int compareTo(AnimationReplacement o) {
            boolean oIsNull;
            boolean isNull = this.animationtypeToReplace == null;
            boolean bl = oIsNull = o.animationtypeToReplace == null;
            if (isNull && oIsNull) {
                return 0;
            }
            if (isNull) {
                return -1;
            }
            if (oIsNull) {
                return 1;
            }
            return this.animationtypeToReplace.compareTo(o.animationtypeToReplace);
        }

        public String toString() {
            return (this.animationSet == null ? null : this.animationSet.name) + " " + this.animationtypeToReplace + " " + this.animationtypeReplacement;
        }

        public AnimationSet getAnimationSet() {
            return this.animationSet;
        }

        public AnimationType getAnimationtypeToReplace() {
            return this.animationtypeToReplace;
        }

        public AnimationType getAnimationtypeReplacement() {
            return this.animationtypeReplacement;
        }

        public int getAuto() {
            return this.auto;
        }

        public void setAnimationSet(AnimationSet animationSet) {
            this.animationSet = animationSet;
        }

        public void setAnimationtypeToReplace(AnimationType animationtypeToReplace) {
            this.animationtypeToReplace = animationtypeToReplace;
        }

        public void setAnimationtypeReplacement(AnimationType animationtypeReplacement) {
            this.animationtypeReplacement = animationtypeReplacement;
        }

        public void setAuto(int auto) {
            this.auto = auto;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnimationReplacement)) {
                return false;
            }
            AnimationReplacement other = (AnimationReplacement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AnimationSet this$animationSet = this.getAnimationSet();
            AnimationSet other$animationSet = other.getAnimationSet();
            if (this$animationSet == null ? other$animationSet != null : !((Object)this$animationSet).equals(other$animationSet)) {
                return false;
            }
            AnimationType this$animationtypeToReplace = this.getAnimationtypeToReplace();
            AnimationType other$animationtypeToReplace = other.getAnimationtypeToReplace();
            if (this$animationtypeToReplace == null ? other$animationtypeToReplace != null : !((Object)((Object)this$animationtypeToReplace)).equals((Object)other$animationtypeToReplace)) {
                return false;
            }
            AnimationType this$animationtypeReplacement = this.getAnimationtypeReplacement();
            AnimationType other$animationtypeReplacement = other.getAnimationtypeReplacement();
            if (this$animationtypeReplacement == null ? other$animationtypeReplacement != null : !((Object)((Object)this$animationtypeReplacement)).equals((Object)other$animationtypeReplacement)) {
                return false;
            }
            return this.getAuto() == other.getAuto();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AnimationReplacement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnimationSet $animationSet = this.getAnimationSet();
            result = result * 59 + ($animationSet == null ? 43 : ((Object)$animationSet).hashCode());
            AnimationType $animationtypeToReplace = this.getAnimationtypeToReplace();
            result = result * 59 + ($animationtypeToReplace == null ? 43 : ((Object)((Object)$animationtypeToReplace)).hashCode());
            AnimationType $animationtypeReplacement = this.getAnimationtypeReplacement();
            result = result * 59 + ($animationtypeReplacement == null ? 43 : ((Object)((Object)$animationtypeReplacement)).hashCode());
            result = result * 59 + this.getAuto();
            return result;
        }
    }
}

