/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.google.gson.Gson;
import com.weaponanimationreplacer.AnimationSet;
import com.weaponanimationreplacer.ProjectileCast;
import com.weaponanimationreplacer.Swap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import net.runelite.api.Actor;
import net.runelite.api.kit.KitType;
import net.runelite.client.game.ItemVariationMapping;

public class Constants {
    public static final int HEAD_SLOT = KitType.HEAD.getIndex();
    public static final int CAPE_SLOT = KitType.CAPE.getIndex();
    public static final int AMULET_SLOT = KitType.AMULET.getIndex();
    public static final int WEAPON_SLOT = KitType.WEAPON.getIndex();
    public static final int TORSO_SLOT = KitType.TORSO.getIndex();
    public static final int SHIELD_SLOT = KitType.SHIELD.getIndex();
    public static final int ARMS_SLOT = KitType.ARMS.getIndex();
    public static final int LEGS_SLOT = KitType.LEGS.getIndex();
    public static final int HAIR_SLOT = KitType.HAIR.getIndex();
    public static final int HANDS_SLOT = KitType.HANDS.getIndex();
    public static final int BOOTS_SLOT = KitType.BOOTS.getIndex();
    public static final int JAW_SLOT = KitType.JAW.getIndex();
    public static Set<Integer> SHOWS_ARMS;
    public static Set<Integer> HIDES_HAIR;
    public static Set<Integer> HIDES_JAW;
    public static Map<String, int[]> poseanims;
    public static List<ProjectileCast> projectiles;
    public static ProjectileCast[] projectilesById;
    public static Map<Integer, Integer> SLOT_OVERRIDES;
    public static Map<Integer, NameAndIconId> NAME_ICON_OVERRIDES;

    public static AnimationSet getAnimationSet(int itemId) {
        Collection variations = ItemVariationMapping.getVariations((int)ItemVariationMapping.map((int)itemId));
        for (Map.Entry<String, int[]> entry : poseanims.entrySet()) {
            for (int itemId2 : entry.getValue()) {
                if (!variations.contains(itemId2)) continue;
                return AnimationSet.getAnimationSet(entry.getKey());
            }
        }
        return null;
    }

    public static void loadData(Gson gson) {
        if (SLOT_OVERRIDES.size() > 0) {
            return;
        }
        InputStream resourceAsStream = Constants.class.getResourceAsStream("data.json");
        Data data = (Data)gson.fromJson((Reader)new InputStreamReader(resourceAsStream), Data.class);
        Constants.loadData(data);
    }

    public static void loadData(Data data) {
        for (Map.Entry<Integer, List<Integer>> entry : data.slotOverrides.entrySet()) {
            int kitIndex = entry.getKey();
            for (Integer itemId : entry.getValue()) {
                SLOT_OVERRIDES.put(itemId, kitIndex);
            }
        }
        Constants.addUnequippable(26649, KitType.SHIELD);
        SHOWS_ARMS = data.showArms;
        HIDES_HAIR = data.hideHair;
        HIDES_JAW = data.hideJaw;
        poseanims = data.poseanims;
        NAME_ICON_OVERRIDES = data.nameIconOverrides;
        projectiles = data.projectiles;
        projectilesById = Constants.createProjectilesById(projectiles);
    }

    private static ProjectileCast[] createProjectilesById(List<ProjectileCast> projectiles) {
        OptionalInt max = projectiles.stream().mapToInt(p -> p.id).max();
        if (!max.isPresent()) {
            return new ProjectileCast[0];
        }
        int highestId = max.getAsInt();
        ProjectileCast[] projectilesById = new ProjectileCast[highestId + 1];
        Iterator<ProjectileCast> iterator = projectiles.iterator();
        while (iterator.hasNext()) {
            ProjectileCast projectile;
            projectilesById[projectile.id] = projectile = iterator.next();
        }
        return projectilesById;
    }

    private static void addUnequippable(int itemId, KitType kitType) {
        Constants.addUnequippable(itemId, kitType, null);
    }

    private static void addUnequippable(int itemId, KitType kitType, String name) {
        Constants.addUnequippable(itemId, kitType, name, -1);
    }

    private static void addUnequippable(int itemId, KitType kitType, String name, int iconId) {
        SLOT_OVERRIDES.put(itemId, kitType.getIndex());
        if (name != null || iconId != -1) {
            NAME_ICON_OVERRIDES.put(itemId, new NameAndIconId(name, iconId));
        }
    }

    public static int getIconId(int itemId) {
        NameAndIconId nameAndIconId = NAME_ICON_OVERRIDES.get(itemId);
        return nameAndIconId == null ? itemId : nameAndIconId.iconId(itemId);
    }

    public static String getName(int itemId, String name) {
        NameAndIconId nameAndIconId = NAME_ICON_OVERRIDES.get(itemId);
        return nameAndIconId == null ? name : nameAndIconId.name(name);
    }

    public static NegativeId mapNegativeId(int id) {
        if (id == -1) {
            return new NegativeId(NegativeIdsMap.NULL, -1);
        }
        if (id <= -2 && id > -2 - KitType.values().length) {
            return new NegativeId(NegativeIdsMap.HIDE_SLOT, id * -1 - 2);
        }
        if (id == -14) {
            return new NegativeId(NegativeIdsMap.SHOW_SLOT, ARMS_SLOT);
        }
        if (id == -15) {
            return new NegativeId(NegativeIdsMap.SHOW_SLOT, HAIR_SLOT);
        }
        if (id == -16) {
            return new NegativeId(NegativeIdsMap.SHOW_SLOT, JAW_SLOT);
        }
        throw new IllegalArgumentException();
    }

    public static int mapNegativeId(NegativeId id) {
        return Constants.mapNegativeId(id.type, id.id);
    }

    public static int mapNegativeId(NegativeIdsMap type, int id) {
        if (type == NegativeIdsMap.NULL) {
            return -1;
        }
        if (type == NegativeIdsMap.HIDE_SLOT) {
            return -2 - id;
        }
        if (type == NegativeIdsMap.SHOW_SLOT) {
            if (id == ARMS_SLOT) {
                return -14;
            }
            if (id == HAIR_SLOT) {
                return -15;
            }
            if (id == JAW_SLOT) {
                return -16;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        projectiles = new ArrayList<ProjectileCast>();
        projectilesById = new ProjectileCast[0];
        SLOT_OVERRIDES = new HashMap<Integer, Integer>();
        NAME_ICON_OVERRIDES = new HashMap<Integer, NameAndIconId>();
    }

    public static final class NegativeId {
        public final NegativeIdsMap type;
        public final int id;

        public NegativeId(NegativeIdsMap type, int id) {
            this.type = type;
            this.id = id;
        }
    }

    public static enum NegativeIdsMap {
        NULL,
        HIDE_SLOT,
        SHOW_SLOT;

    }

    public static enum ActorAnimation {
        IDLE(Actor::getIdlePoseAnimation, Actor::setIdlePoseAnimation, Swap.AnimationType.STAND),
        IDLE_ROTATE_LEFT(Actor::getIdleRotateLeft, Actor::setIdleRotateLeft, Swap.AnimationType.ROTATE),
        IDLE_ROTATE_RIGHT(Actor::getIdleRotateRight, Actor::setIdleRotateRight, Swap.AnimationType.ROTATE),
        WALK(Actor::getWalkAnimation, Actor::setWalkAnimation, Swap.AnimationType.WALK),
        WALK_ROTATE_180(Actor::getWalkRotate180, Actor::setWalkRotate180, Swap.AnimationType.WALK_BACKWARD),
        WALK_ROTATE_LEFT(Actor::getWalkRotateLeft, Actor::setWalkRotateLeft, Swap.AnimationType.SHUFFLE_LEFT),
        WALK_ROTATE_RIGHT(Actor::getWalkRotateRight, Actor::setWalkRotateRight, Swap.AnimationType.SHUFFLE_RIGHT),
        RUN(Actor::getRunAnimation, Actor::setRunAnimation, Swap.AnimationType.RUN);

        private final Swap.AnimationType type;
        private final AnimationGetter animationGetter;
        private final AnimationSetter animationSetter;

        private ActorAnimation(AnimationGetter animationGetter, AnimationSetter animationSetter, Swap.AnimationType type) {
            this.type = type;
            this.animationGetter = animationGetter;
            this.animationSetter = animationSetter;
        }

        public int getAnimation(Actor actor) {
            return this.animationGetter.getAnimation(actor);
        }

        public void setAnimation(Actor actor, int animationId) {
            this.animationSetter.setAnimation(actor, animationId);
        }

        public Swap.AnimationType getType() {
            return this.type;
        }

        static interface AnimationSetter {
            public void setAnimation(Actor var1, int var2);
        }

        static interface AnimationGetter {
            public int getAnimation(Actor var1);
        }
    }

    public static enum ShownSlot {
        HEAD(KitType.HEAD, 1137),
        CAPE(KitType.CAPE, 3779),
        AMULET(KitType.AMULET, 1796),
        WEAPON(KitType.WEAPON, 10858),
        TORSO(KitType.TORSO, 6107),
        SHIELD(KitType.SHIELD, 1175),
        ARMS(KitType.ARMS, 11068),
        LEGS(KitType.LEGS, 6108),
        HAIR(KitType.HAIR, 2419),
        HANDS(KitType.HANDS, 21736),
        BOOTS(KitType.BOOTS, 4121),
        JAW(KitType.JAW, 24268);

        final KitType kitType;
        final int iconIdToShow;

        private ShownSlot(KitType kitType, int iconIdToShow) {
            this.kitType = kitType;
            this.iconIdToShow = iconIdToShow;
        }
    }

    public static enum HiddenSlot {
        HEAD(KitType.HEAD, 1137, "Hide helm"),
        CAPE(KitType.CAPE, 3779, "Hide cape"),
        AMULET(KitType.AMULET, 1796, "Hide amulet"),
        WEAPON(KitType.WEAPON, 10858, "Hide weapon"),
        TORSO(KitType.TORSO, 6107, "Hide torso"),
        SHIELD(KitType.SHIELD, 1175, "Hide off hand"),
        ARMS(KitType.ARMS, 21177, "Hide sleeves"),
        LEGS(KitType.LEGS, 6108, "Hide legs"),
        HAIR(KitType.HAIR, 2421, "Hide hair"),
        HANDS(KitType.HANDS, 21736, "Hide hands"),
        BOOTS(KitType.BOOTS, 4121, "Hide boots"),
        JAW(KitType.JAW, 4593, "Hide jaw");

        final KitType kitType;
        final int iconIdToShow;
        public final String actionName;

        private HiddenSlot(KitType kitType, int iconIdToShow, String actionName) {
            this.kitType = kitType;
            this.iconIdToShow = iconIdToShow;
            this.actionName = actionName;
        }
    }

    public static final class NameAndIconId {
        private final String name;
        private final int iconId;

        public String name(String actualName) {
            return this.name == null ? actualName : this.name;
        }

        public int iconId(int actualIconId) {
            return this.iconId == -1 ? actualIconId : this.iconId;
        }

        public NameAndIconId(String name, int iconId) {
            this.name = name;
            this.iconId = iconId;
        }

        public String getName() {
            return this.name;
        }

        public int getIconId() {
            return this.iconId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameAndIconId)) {
                return false;
            }
            NameAndIconId other = (NameAndIconId)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getIconId() == other.getIconId();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getIconId();
            return result;
        }

        public String toString() {
            return "Constants.NameAndIconId(name=" + this.getName() + ", iconId=" + this.getIconId() + ")";
        }
    }

    static final class Data {
        Set<Integer> showArms;
        Set<Integer> hideHair;
        Set<Integer> hideJaw;
        Map<Integer, List<Integer>> slotOverrides;
        Map<Integer, NameAndIconId> nameIconOverrides;
        Map<String, int[]> poseanims;
        List<ProjectileCast> projectiles;

        Data() {
        }
    }
}

