/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.weaponanimationreplacer.Constants;
import com.weaponanimationreplacer.ProjectileCast;
import com.weaponanimationreplacer.WeaponAnimationReplacerConfig;
import com.weaponanimationreplacer.WeaponAnimationReplacerPlugin;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuShouldLeftClick;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.JavaScriptCallback;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextInput;
import net.runelite.client.util.ColorUtil;
import net.runelite.http.api.item.ItemStats;

@Singleton
public class ChatBoxFilterableSearch
extends ChatboxTextInput {
    private static final int ICON_HEIGHT = 32;
    private static final int ICON_WIDTH = 36;
    private static final int PADDING = 6;
    private static final int RESULTS_PER_PAGE = 24;
    private static final int FONT_SIZE = 16;
    private static final int HOVERED_OPACITY = 128;
    private final ChatboxPanelManager chatboxPanelManager;
    private final ItemManager itemManager;
    private final Client client;
    private final WeaponAnimationReplacerConfig config;
    private final WeaponAnimationReplacerPlugin plugin;
    private final Map<Integer, ItemComposition> results = new LinkedHashMap<Integer, ItemComposition>();
    private final List<String> spells = new ArrayList<String>();
    private String tooltipText;
    private int index = -1;
    private Consumer<SelectionResult> onItemSelected;
    private Consumer<Integer> onItemMouseOvered;
    private Runnable onItemDeleted;
    private WeaponAnimationReplacerPlugin.SearchType searchType;
    private int mode = 0;
    private KitType slotToShow = null;
    private int page = 0;
    private int lastPage = -1;
    private Map<Integer, Integer> filteredPageIndexes = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> triggerItemSlots = new HashMap<Integer, Integer>();
    private static final ImmutableMap<Integer, Integer> WEIGHT_REDUCING_ITEMS = ImmutableMap.builder().put((Object)89, (Object)88).put((Object)10554, (Object)10553).put((Object)11851, (Object)11850).put((Object)11853, (Object)11852).put((Object)11855, (Object)11854).put((Object)11857, (Object)11856).put((Object)11859, (Object)11858).put((Object)11861, (Object)11860).put((Object)13580, (Object)13579).put((Object)13582, (Object)13581).put((Object)13584, (Object)13583).put((Object)13586, (Object)13585).put((Object)13588, (Object)13587).put((Object)13590, (Object)13589).put((Object)13592, (Object)13591).put((Object)13594, (Object)13593).put((Object)13596, (Object)13595).put((Object)13598, (Object)13597).put((Object)13600, (Object)13599).put((Object)13602, (Object)13601).put((Object)13604, (Object)13603).put((Object)13606, (Object)13605).put((Object)13608, (Object)13607).put((Object)13610, (Object)13609).put((Object)13612, (Object)13611).put((Object)13614, (Object)13613).put((Object)13616, (Object)13615).put((Object)13618, (Object)13617).put((Object)13620, (Object)13619).put((Object)13622, (Object)13621).put((Object)13624, (Object)13623).put((Object)13626, (Object)13625).put((Object)13628, (Object)13627).put((Object)13630, (Object)13629).put((Object)13632, (Object)13631).put((Object)13634, (Object)13633).put((Object)13636, (Object)13635).put((Object)13638, (Object)13637).put((Object)13668, (Object)13667).put((Object)13670, (Object)13669).put((Object)13672, (Object)13671).put((Object)13674, (Object)13673).put((Object)13676, (Object)13675).put((Object)13678, (Object)13677).put((Object)21063, (Object)21061).put((Object)21066, (Object)21064).put((Object)21069, (Object)21067).put((Object)21072, (Object)21070).put((Object)21075, (Object)21073).put((Object)21078, (Object)21076).put((Object)24745, (Object)24743).put((Object)24748, (Object)24746).put((Object)24751, (Object)24749).put((Object)24754, (Object)24752).put((Object)24757, (Object)24755).put((Object)24760, (Object)24758).put((Object)25071, (Object)25069).put((Object)25074, (Object)25072).put((Object)25077, (Object)25075).put((Object)25080, (Object)25078).put((Object)25083, (Object)25081).put((Object)25086, (Object)25084).put((Object)27446, (Object)27444).put((Object)27449, (Object)27447).put((Object)27452, (Object)27450).put((Object)27455, (Object)27453).put((Object)27458, (Object)27456).put((Object)27461, (Object)27459).put((Object)13342, (Object)13280).put((Object)10073, (Object)10069).put((Object)10074, (Object)10071).put((Object)13341, (Object)9772).put((Object)13340, (Object)9771).build();

    public void setType(WeaponAnimationReplacerPlugin.SearchType searchType) {
        this.searchType = searchType;
        this.mode = 0;
        this.slotToShow = null;
    }

    @Inject
    private ChatBoxFilterableSearch(ChatboxPanelManager chatboxPanelManager, ClientThread clientThread, ItemManager itemManager, Client client, WeaponAnimationReplacerConfig config, WeaponAnimationReplacerPlugin plugin) {
        super(chatboxPanelManager, clientThread);
        this.chatboxPanelManager = chatboxPanelManager;
        this.itemManager = itemManager;
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.lines(1);
        this.prompt("Item Search");
        this.onChanged(searchString -> clientThread.invokeLater(() -> {
            this.resetPage();
            this.update();
        }));
    }

    protected void open() {
        this.resetPage();
        super.open();
    }

    private void resetPage() {
        this.page = 0;
        this.lastPage = -1;
        this.filteredPageIndexes.clear();
        this.filterResults();
    }

    protected void update() {
        block13: {
            int idx;
            int y;
            int x;
            Widget container;
            block11: {
                block12: {
                    container = this.chatboxPanelManager.getContainerWidget();
                    container.deleteAllChildren();
                    this.buildEdit(0, 21, container.getWidth(), 16);
                    this.addSeparator(container);
                    this.createCloseInterfaceWidget(container);
                    this.createDeleteItemWidget(container);
                    this.createPageButtons(container);
                    if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP) {
                        this.createHideSlotWidget(container, "Items:", 0, 10, 40);
                        this.createHideSlotWidget(container, " (" + (this.slotToShow == null ? "all" : this.slotToShow.name().toLowerCase()) + ")", 0, 50, 70);
                        this.createHideSlotWidget(container, "Hide/Show", 1, 110, 80);
                    }
                    x = 6;
                    y = 18;
                    idx = 0;
                    if (this.searchType != WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM && this.searchType != WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP) break block11;
                    if (this.mode != 0) break block12;
                    if (this.results.size() == 0) {
                        this.addText(container, this.getValue().isEmpty() ? "Type to search items." : "No results.", -16777216, 170, 50);
                    } else {
                        for (ItemComposition itemComposition : this.results.values()) {
                            int itemId = itemComposition.getId();
                            this.addItemWidgetItem(itemId, Constants.getIconId(itemId), Constants.getName(itemId, itemComposition.getName()), container, x, y, se -> {
                                Integer slot;
                                if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM && (slot = this.triggerItemSlots.get(itemId)) != null && slot != this.plugin.getWikiScrapeSlot(itemId)) {
                                    this.itemSelected(itemId, slot);
                                    return;
                                }
                                this.itemSelected(itemId);
                            }, idx);
                            if ((x += 42) + 36 >= container.getWidth()) {
                                y += 38;
                                x = 6;
                            }
                            ++idx;
                        }
                    }
                    break block13;
                }
                if (this.mode != 1) break block13;
                ArrayList<Integer> iconIds = new ArrayList<Integer>();
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<Integer> hideSlotIds = new ArrayList<Integer>();
                for (Constants.HiddenSlot hiddenSlot : Constants.HiddenSlot.values()) {
                    iconIds.add(hiddenSlot.iconIdToShow);
                    names.add(hiddenSlot.actionName);
                    hideSlotIds.add(Constants.mapNegativeId(new Constants.NegativeId(Constants.NegativeIdsMap.HIDE_SLOT, hiddenSlot.ordinal())));
                }
                iconIds.add(Constants.ShownSlot.ARMS.iconIdToShow);
                names.add("Show arms");
                hideSlotIds.add(Constants.mapNegativeId(new Constants.NegativeId(Constants.NegativeIdsMap.SHOW_SLOT, Constants.ARMS_SLOT)));
                iconIds.add(Constants.ShownSlot.HAIR.iconIdToShow);
                names.add("Show hair");
                hideSlotIds.add(Constants.mapNegativeId(new Constants.NegativeId(Constants.NegativeIdsMap.SHOW_SLOT, Constants.HAIR_SLOT)));
                iconIds.add(Constants.ShownSlot.JAW.iconIdToShow);
                names.add("Show jaw");
                hideSlotIds.add(Constants.mapNegativeId(new Constants.NegativeId(Constants.NegativeIdsMap.SHOW_SLOT, Constants.JAW_SLOT)));
                for (int i = 0; i < iconIds.size(); ++i) {
                    int finalI = i;
                    this.addItemWidgetItem((Integer)hideSlotIds.get(i), (Integer)iconIds.get(i), (String)names.get(i), container, x, y, se -> this.itemSelected((Integer)hideSlotIds.get(finalI)), idx);
                    if ((x += 42) + 36 >= container.getWidth()) {
                        y += 38;
                        x = 6;
                    }
                    ++idx;
                }
                break block13;
            }
            block3: for (String spell : this.spells) {
                for (ProjectileCast projectile : Constants.projectiles) {
                    if (!projectile.getName(this.itemManager).equals(spell)) continue;
                    this.addItemWidget(projectile.getId(), projectile.getItemIdIcon(), projectile.getSpriteIdIcon(), projectile.getName(this.itemManager), container, x, y, se -> {
                        this.itemSelected(projectile.getId());
                        this.chatboxPanelManager.close();
                    }, idx);
                    if ((x += 42) + 36 >= container.getWidth()) {
                        y += 38;
                        x = 6;
                    }
                    ++idx;
                    continue block3;
                }
            }
        }
    }

    private void createPageButtons(Widget container) {
        Widget leftArrow;
        if (this.page != this.lastPage) {
            Widget rightArrow = container.createChild(-1, 5);
            rightArrow.setSpriteId(426);
            rightArrow.setXPositionMode(2);
            rightArrow.setYPositionMode(0);
            rightArrow.setOriginalX(90);
            rightArrow.setOriginalY(5);
            rightArrow.setOriginalHeight(20);
            rightArrow.setOriginalWidth(20);
            rightArrow.setBorderType(1);
            rightArrow.setAction(0, this.tooltipText);
            rightArrow.setHasListener(true);
            rightArrow.setOnMouseOverListener(new Object[]{ev -> rightArrow.setOpacity(128)});
            rightArrow.setOnMouseLeaveListener(new Object[]{ev -> rightArrow.setOpacity(0)});
            rightArrow.setOnOpListener(new Object[]{ev -> this.clientThread.invoke(() -> {
                ++this.page;
                this.filterResults();
                this.update();
            })});
            rightArrow.revalidate();
        }
        if (this.lastPage != 0) {
            leftArrow = container.createChild(-1, 4);
            leftArrow.setText("" + (this.page + 1));
            leftArrow.setTextColor(0);
            leftArrow.setFontId(this.getFontID());
            leftArrow.setXPositionMode(2);
            leftArrow.setYPositionMode(0);
            leftArrow.setOriginalX(109 + (this.page + 1 >= 10 ? 0 : -5));
            leftArrow.setOriginalY(5);
            leftArrow.setOriginalHeight(20);
            leftArrow.setOriginalWidth(20);
            leftArrow.setBorderType(1);
            leftArrow.setAction(0, this.tooltipText);
            leftArrow.revalidate();
        }
        if (this.page != 0) {
            leftArrow = container.createChild(-1, 5);
            leftArrow.setSpriteId(425);
            leftArrow.setXPositionMode(2);
            leftArrow.setYPositionMode(0);
            leftArrow.setOriginalX(130);
            leftArrow.setOriginalY(5);
            leftArrow.setOriginalHeight(20);
            leftArrow.setOriginalWidth(20);
            leftArrow.setBorderType(1);
            leftArrow.setAction(0, this.tooltipText);
            leftArrow.setHasListener(true);
            leftArrow.setOnMouseOverListener(new Object[]{ev -> leftArrow.setOpacity(128)});
            leftArrow.setOnMouseLeaveListener(new Object[]{ev -> leftArrow.setOpacity(0)});
            leftArrow.setOnOpListener(new Object[]{ev -> this.clientThread.invoke(() -> {
                --this.page;
                this.filterResults();
                this.update();
            })});
            leftArrow.revalidate();
        }
    }

    private void addText(Widget container, String text, int textColor, int x, int y) {
        Widget item = container.createChild(-1, 4);
        item.setTextColor(textColor);
        item.setText(text);
        item.setFontId(this.getFontID());
        item.setXPositionMode(0);
        item.setYPositionMode(0);
        item.setOriginalX(x);
        item.setOriginalY(y);
        item.setOriginalHeight(40);
        item.setOriginalWidth(1000);
        item.setBorderType(1);
        item.revalidate();
    }

    private void itemSelected(int itemId) {
        this.itemSelected(itemId, -1);
    }

    private void itemSelected(int itemId, int slot) {
        if (this.onItemSelected != null) {
            this.onItemSelected.accept(new SelectionResult(itemId, slot));
        }
    }

    private void addItemWidgetSprite(int id, int spriteId, String name, Widget container, int x, int y, JavaScriptCallback onOpListener, int idx) {
        this.addItemWidget(id, -1, spriteId, name, container, x, y, onOpListener, idx);
    }

    private void addItemWidgetItem(int id, int iconId, String name, Widget container, int x, int y, JavaScriptCallback onOpListener, int idx) {
        this.addItemWidget(id, iconId, -1, name, container, x, y, onOpListener, idx);
    }

    private void addItemWidget(int id, int iconId, int spriteId, String name, Widget container, int x, int y, JavaScriptCallback onOpListener, int idx) {
        Widget item = container.createChild(-1, 5);
        item.setXPositionMode(0);
        item.setYPositionMode(0);
        item.setOriginalX(x);
        item.setOriginalY(y + 32);
        item.setOriginalHeight(32);
        item.setOriginalWidth(36);
        item.setName("<col=ff9040>" + name);
        if (iconId != -1) {
            item.setItemId(iconId);
        } else if (spriteId != -1) {
            item.setSpriteId(spriteId);
        }
        item.setItemQuantity(10000);
        item.setItemQuantityMode(0);
        item.setBorderType(1);
        item.setAction(0, this.tooltipText);
        item.setHasListener(true);
        if (this.index == idx) {
            item.setOpacity(128);
        } else {
            item.setOnMouseOverListener(new Object[]{ev -> {
                item.setOpacity(128);
                if (this.onItemMouseOvered != null) {
                    this.onItemMouseOvered.accept(id);
                }
            }});
            item.setOnMouseLeaveListener(new Object[]{ev -> {
                item.setOpacity(0);
                if (this.onItemMouseOvered != null) {
                    this.onItemMouseOvered.accept(-1);
                }
            }});
        }
        item.setOnOpListener(new Object[]{onOpListener});
        item.revalidate();
    }

    private void addSeparator(Widget container) {
        Widget separator = container.createChild(-1, 9);
        separator.setOriginalX(0);
        separator.setOriginalY(40);
        separator.setXPositionMode(1);
        separator.setYPositionMode(0);
        separator.setOriginalHeight(0);
        separator.setOriginalWidth(16);
        separator.setWidthMode(1);
        separator.setTextColor(0x666666);
        separator.revalidate();
    }

    private void addPromptWidget(Widget container) {
        Widget promptWidget = container.createChild(-1, 4);
        promptWidget.setText(this.getPrompt());
        promptWidget.setTextColor(0x800000);
        promptWidget.setFontId(this.getFontID());
        promptWidget.setOriginalX(0);
        promptWidget.setOriginalY(5);
        promptWidget.setXPositionMode(1);
        promptWidget.setYPositionMode(0);
        promptWidget.setOriginalHeight(16);
        promptWidget.setXTextAlignment(1);
        promptWidget.setYTextAlignment(1);
        promptWidget.setWidthMode(1);
        promptWidget.revalidate();
    }

    private Widget createDeleteItemWidget(Widget container) {
        Widget item = container.createChild(-1, 5);
        item.setXPositionMode(0);
        item.setYPositionMode(0);
        item.setOriginalX(430);
        item.setOriginalY(5);
        item.setOriginalHeight(32);
        item.setOriginalWidth(36);
        ItemComposition itemComposition = this.itemManager.getItemComposition(20594);
        item.setName("delete");
        item.setItemId(itemComposition.getId());
        item.setItemQuantity(10000);
        item.setItemQuantityMode(0);
        item.setBorderType(1);
        item.setAction(0, this.tooltipText);
        item.setHasListener(true);
        item.setOnMouseOverListener(new Object[]{ev -> item.setOpacity(128)});
        item.setOnMouseLeaveListener(new Object[]{ev -> item.setOpacity(0)});
        item.setOnOpListener(new Object[]{ev -> {
            this.onItemDeleted.run();
            this.chatboxPanelManager.close();
        }});
        item.revalidate();
        return item;
    }

    private Widget createCloseInterfaceWidget(Widget container) {
        Widget item = container.createChild(-1, 4);
        item.setTextColor(-16777216);
        item.setFontId(this.getFontID());
        item.setText("X");
        item.setName("Close (Esc");
        item.setXPositionMode(0);
        item.setYPositionMode(0);
        item.setOriginalX(470);
        item.setOriginalY(2);
        item.setOriginalHeight(32);
        item.setOriginalWidth(15);
        item.setBorderType(1);
        item.setAction(0, this.tooltipText);
        item.setHasListener(true);
        item.setOnMouseOverListener(new Object[]{ev -> item.setOpacity(128)});
        item.setOnMouseLeaveListener(new Object[]{ev -> item.setOpacity(0)});
        item.setOnOpListener(new Object[]{ev -> this.chatboxPanelManager.close()});
        item.revalidate();
        return item;
    }

    private Widget createHideSlotWidget(Widget container, String name, int modeToSwitchTo, int x, int width) {
        Widget item = container.createChild(-1, 4);
        item.setTextColor(this.mode == modeToSwitchTo ? -5636096 : -16777216);
        item.setText(name);
        item.setFontId(this.getFontID());
        item.setXPositionMode(0);
        item.setYPositionMode(0);
        item.setOriginalX(x);
        item.setOriginalY(5);
        item.setOriginalHeight(32);
        item.setOriginalWidth(width);
        item.setName(name);
        item.setBorderType(1);
        item.setAction(0, this.tooltipText);
        item.setHasListener(true);
        item.setOnMouseOverListener(new Object[]{ev -> item.setTextColor(this.mode == modeToSwitchTo ? -5636096 : -10066330)});
        item.setOnMouseLeaveListener(new Object[]{ev -> item.setTextColor(this.mode == modeToSwitchTo ? -5636096 : -16777216)});
        item.setOnOpListener(new Object[]{ev -> {
            this.mode = modeToSwitchTo;
            this.update();
        }});
        item.revalidate();
        return item;
    }

    public void keyPressed(KeyEvent ev) {
        if (!this.chatboxPanelManager.shouldTakeInput()) {
            return;
        }
        switch (ev.getKeyCode()) {
            case 10: {
                ev.consume();
                if (this.index <= -1) break;
                this.itemSelected(this.results.keySet().toArray(new Integer[this.results.size()])[this.index]);
                break;
            }
            case 9: 
            case 39: {
                ev.consume();
                if (this.results.isEmpty()) break;
                ++this.index;
                if (this.index >= this.results.size()) {
                    this.index = 0;
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 37: {
                ev.consume();
                if (this.results.isEmpty()) break;
                --this.index;
                if (this.index < 0) {
                    this.index = this.results.size() - 1;
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 38: {
                ev.consume();
                if (this.results.size() < 12) break;
                this.index -= 12;
                if (this.index < 0) {
                    this.index = this.results.size() == 24 ? (this.index += this.results.size()) : (this.index += 24);
                    this.index = Ints.constrainToRange((int)this.index, (int)0, (int)(this.results.size() - 1));
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            case 40: {
                ev.consume();
                if (this.results.size() < 12) break;
                this.index += 12;
                if (this.index >= 24) {
                    this.index = this.results.size() == 24 ? (this.index -= this.results.size()) : (this.index -= 24);
                    this.index = Ints.constrainToRange((int)this.index, (int)0, (int)(this.results.size() - 1));
                }
                this.clientThread.invokeLater(this::update);
                break;
            }
            default: {
                super.keyPressed(ev);
            }
        }
    }

    protected void close() {
        if (this.onItemMouseOvered != null) {
            this.onItemMouseOvered.accept(-1);
        }
        this.value("");
        this.results.clear();
        this.spells.clear();
        this.index = -1;
        this.mode = 0;
        this.searchType = null;
        super.close();
    }

    @Deprecated
    public ChatboxTextInput onDone(Consumer<String> onDone) {
        throw new UnsupportedOperationException();
    }

    private void filterResults() {
        this.results.clear();
        this.spells.clear();
        this.index = -1;
        String search = this.getValue().toLowerCase();
        if (search.isEmpty() && (this.mode != 0 || this.slotToShow == null)) {
            if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM) {
                ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
                Item[] items = itemContainer == null ? new Item[]{} : itemContainer.getItems();
                this.triggerItemSlots.clear();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].getId() == -1 || i == EquipmentInventorySlot.RING.getSlotIdx() || i == EquipmentInventorySlot.AMMO.getSlotIdx()) continue;
                    ItemComposition itemComposition = this.itemManager.getItemComposition(this.itemManager.canonicalize(items[i].getId()));
                    this.triggerItemSlots.put(itemComposition.getId(), i);
                    this.results.put(itemComposition.getId(), itemComposition);
                }
                this.lastPage = 0;
                return;
            }
            if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP) {
                this.lastPage = 0;
                return;
            }
            if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.SPELL_L || this.searchType == WeaponAnimationReplacerPlugin.SearchType.SPELL_R) {
                // empty if block
            }
        }
        Integer integer = -1;
        try {
            integer = Integer.valueOf(search);
        }
        catch (NumberFormatException items) {
            // empty catch block
        }
        if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.TRIGGER_ITEM || this.searchType == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP) {
            int start = this.filteredPageIndexes.getOrDefault(this.page - 1, 0);
            boolean showUnequippableItems = this.searchType == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP && this.config.showUnequippableItems();
            for (int itemId = start; itemId < this.client.getItemCount(); ++itemId) {
                ItemComposition itemComposition = this.getItemCompositionIfUsable(itemId, showUnequippableItems);
                if (itemComposition == null || !this.matchesSlotFilter(itemId)) continue;
                String name = Constants.getName(itemId, itemComposition.getName()).toLowerCase();
                if (itemId != integer && !name.contains(search)) continue;
                if (this.results.size() == 24) {
                    this.filteredPageIndexes.put(this.page, itemId);
                    return;
                }
                this.results.put(itemComposition.getId(), itemComposition);
            }
            this.lastPage = this.page;
        } else {
            int start;
            for (int projectileIndex = start = this.filteredPageIndexes.getOrDefault(this.page - 1, 0).intValue(); projectileIndex < Constants.projectiles.size(); ++projectileIndex) {
                String projectileName;
                ProjectileCast projectile = Constants.projectiles.get(projectileIndex);
                if (this.searchType == WeaponAnimationReplacerPlugin.SearchType.SPELL_L && projectile.isArtificial() || !(projectileName = projectile.getName(this.itemManager)).toLowerCase().contains(search) || this.spells.contains(projectileName)) continue;
                if (this.spells.size() == 24) {
                    this.filteredPageIndexes.put(this.page, projectileIndex);
                    return;
                }
                this.spells.add(projectileName);
            }
            this.lastPage = this.page;
        }
    }

    private boolean matchesSlotFilter(int itemId) {
        boolean matchesSlotFilter = false;
        if (this.slotToShow == null) {
            matchesSlotFilter = true;
        } else {
            Integer slot = this.plugin.getSlotForNonNegativeModelId(itemId);
            if (slot != null && slot <= 11 && KitType.values()[slot] == this.slotToShow) {
                matchesSlotFilter = true;
            }
        }
        return matchesSlotFilter;
    }

    private ItemComposition getItemCompositionIfUsable(int i, boolean showUnequippableItems) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(i);
        if (itemComposition.getNote() != -1 || itemComposition.getPlaceholderTemplateId() != -1 || WEIGHT_REDUCING_ITEMS.get((Object)i) != null) {
            return null;
        }
        Integer slotOverride = Constants.SLOT_OVERRIDES.get(i);
        if (slotOverride != null) {
            return slotOverride == -1 ? null : itemComposition;
        }
        ItemStats itemStats = this.itemManager.getItemStats(itemComposition.getId(), false);
        if (!showUnequippableItems) {
            if (itemStats == null || !itemStats.isEquipable()) {
                return null;
            }
            int slot = itemStats.getEquipment().getSlot();
            if (slot == EquipmentInventorySlot.RING.getSlotIdx() || slot == EquipmentInventorySlot.AMMO.getSlotIdx()) {
                return null;
            }
        }
        return itemComposition;
    }

    @Subscribe
    public void onMenuShouldLeftClick(MenuShouldLeftClick e) {
        for (MenuEntry menuEntry : this.client.getMenuEntries()) {
            Widget widget = menuEntry.getWidget();
            if (widget == null || widget.getId() != WidgetInfo.PACK((int)162, (int)37)) continue;
            if (this.getSearchType() == WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP && this.getMode() == 0 && widget.getItemId() != -1 && !menuEntry.getTarget().equals("delete") && this.plugin.getMySlot(widget.getItemId()) == null) {
                e.setForceRightClick(true);
                return;
            }
            if (!widget.getText().startsWith(" (")) continue;
            e.setForceRightClick(true);
            return;
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened e) {
        for (MenuEntry menuEntry : e.getMenuEntries()) {
            Widget widget = menuEntry.getWidget();
            if (widget == null || widget.getId() != WidgetInfo.PACK((int)162, (int)37)) continue;
            if (widget.getText().startsWith(" (")) {
                this.client.createMenuEntry(1).setOption("Show all").onClick(me -> {
                    this.mode = 0;
                    this.slotToShow = null;
                    this.resetPage();
                    this.update();
                });
                for (EquipmentInventorySlot slot : EquipmentInventorySlot.values()) {
                    if (slot == EquipmentInventorySlot.AMMO || slot == EquipmentInventorySlot.RING) continue;
                    this.client.createMenuEntry(1).setOption("Show only").setTarget(ColorUtil.wrapWithColorTag((String)slot.name().toLowerCase(), (Color)new Color(16748608))).onClick(me -> {
                        this.mode = 0;
                        this.slotToShow = KitType.values()[slot.getSlotIdx()];
                        this.resetPage();
                        this.update();
                    });
                }
                MenuEntry[] newMenuEntries = (MenuEntry[])Arrays.stream(this.client.getMenuEntries()).filter(me -> !me.getOption().equals(this.tooltipText)).toArray(MenuEntry[]::new);
                this.client.setMenuEntries(newMenuEntries);
                return;
            }
            if (this.getSearchType() != WeaponAnimationReplacerPlugin.SearchType.MODEL_SWAP || this.getMode() != 0 || widget.getItemId() == -1) continue;
            if (!menuEntry.getTarget().equals("delete") && this.plugin.getMySlot(widget.getItemId()) == null) {
                MenuEntry[] newMenuEntries = (MenuEntry[])Arrays.stream(this.client.getMenuEntries()).filter(me -> !me.getOption().equals(this.tooltipText)).toArray(MenuEntry[]::new);
                this.client.setMenuEntries(newMenuEntries);
            }
            ItemComposition itemComposition = this.itemManager.getItemComposition(widget.getItemId());
            for (KitType value : KitType.values()) {
                this.client.createMenuEntry(1).setTarget(ColorUtil.wrapWithColorTag((String)itemComposition.getName(), (Color)new Color(16748608))).setOption(value.name()).onClick(me -> this.itemSelected(widget.getItemId(), value.ordinal()));
            }
            return;
        }
    }

    public ChatBoxFilterableSearch onItemSelected(Consumer<SelectionResult> onItemSelected) {
        this.onItemSelected = onItemSelected;
        return this;
    }

    public ChatBoxFilterableSearch onItemMouseOvered(Consumer<Integer> onItemMouseOvered) {
        this.onItemMouseOvered = onItemMouseOvered;
        return this;
    }

    public ChatBoxFilterableSearch onItemDeleted(Runnable onItemDeleted) {
        this.onItemDeleted = onItemDeleted;
        return this;
    }

    public ChatBoxFilterableSearch tooltipText(String text) {
        this.tooltipText = text;
        return this;
    }

    public Consumer<SelectionResult> getOnItemSelected() {
        return this.onItemSelected;
    }

    public WeaponAnimationReplacerPlugin.SearchType getSearchType() {
        return this.searchType;
    }

    public int getMode() {
        return this.mode;
    }

    public static final class SelectionResult {
        public final int itemId;
        public final int slot;

        public SelectionResult(int itemId, int slot) {
            this.itemId = itemId;
            this.slot = slot;
        }

        public int getItemId() {
            return this.itemId;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectionResult)) {
                return false;
            }
            SelectionResult other = (SelectionResult)o;
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            return this.getSlot() == other.getSlot();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemId();
            result = result * 59 + this.getSlot();
            return result;
        }

        public String toString() {
            return "ChatBoxFilterableSearch.SelectionResult(itemId=" + this.getItemId() + ", slot=" + this.getSlot() + ")";
        }
    }
}

