/*
 * Decompiled with CFR 0.152.
 */
package com.weaponanimationreplacer;

import com.weaponanimationreplacer.Swap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AnimationSet
implements Comparable<AnimationSet> {
    public static final List<AnimationSet> animationSets = new ArrayList<AnimationSet>();
    public static final List<Integer> doNotReplaceIdles = new ArrayList<Integer>();
    private static final Map<Integer, String> descriptions = new HashMap<Integer, String>();
    public String name;
    public final int[] animations;
    public final boolean doNotReplace;
    private final AnimationSetType animationSetType;

    public static String getDescription(AnimationSet animationSet, Swap.AnimationType animation) {
        String s;
        int animationId = animationSet.getAnimation(animation);
        if (animationId != -1 && (s = descriptions.get(animationId)) != null) {
            return s;
        }
        return animation.getComboBoxName();
    }

    public static AnimationSet getAnimationSet(String name) {
        return animationSets.stream().filter(a -> name.equals(a.name)).findAny().orElse(null);
    }

    @Override
    public int compareTo(AnimationSet o) {
        return this.name.compareTo(o.name);
    }

    public List<Swap.AnimationType> getAttackAnimations() {
        ArrayList<Swap.AnimationType> result = new ArrayList<Swap.AnimationType>();
        if (this.animations[Swap.AnimationType.ATTACK.ordinal()] != -1) {
            result.add(Swap.AnimationType.values()[Swap.AnimationType.ATTACK.ordinal()]);
        }
        for (Swap.AnimationType child : Swap.AnimationType.ATTACK.children) {
            if (this.animations[child.ordinal()] == -1) continue;
            result.add(Swap.AnimationType.values()[child.ordinal()]);
        }
        return result;
    }

    static void loadAnimationSets() {
        animationSets.clear();
        doNotReplaceIdles.clear();
        descriptions.clear();
        new AnimationSetBuilder("Scythe of Vitur").poseAnims(8057, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 8056).put(Swap.AnimationType.ATTACK_CRUSH, 8056).build();
        new AnimationSetBuilder("Nightmare Staff").poseAnims(4504, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_CRUSH, 4505).put(Swap.AnimationType.DEFEND, 420).build();
        new AnimationSetBuilder("Inquisitor's mace").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 4503).put(Swap.AnimationType.DEFEND, 403).build();
        new AnimationSetBuilder("Dinh's bulwhark").poseAnims(7508, 823, 7510, 7510, 7510, 7510, 7509).put(Swap.AnimationType.ATTACK_CRUSH, 7511).put(Swap.AnimationType.ATTACK_SPEC, 7512).put(Swap.AnimationType.DEFEND, 7517).build();
        new AnimationSetBuilder("Dragon hunter lance").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 2563).put(Swap.AnimationType.ATTACK_SLASH, 8289).put(Swap.AnimationType.ATTACK_CRUSH, 8290).put(Swap.AnimationType.ATTACK_STAB, 8288).build();
        new AnimationSetBuilder("Flying Carpet").poseAnims(6936, 6936, 6936, 6936, 6936, 6936, 6936).build();
        new AnimationSetBuilder("Levitate").poseAnims(8070, 8070, 8070, 8070, 8070, 8070, 8070).doNotReplace().build();
        new AnimationSetBuilder("Clueless Scroll").poseAnims(7271, 823, 7272, 820, 821, 822, 7273).put(Swap.AnimationType.ATTACK_CRUSH, 406).build();
        new AnimationSetBuilder("Godsword (Saradomin)").poseAnims(7053, 7044, 7052, 7052, 7048, 7047, 7043).put(Swap.AnimationType.ATTACK_SLASH, 7045).put(Swap.AnimationType.ATTACK_CRUSH, 7054).put(Swap.AnimationType.ATTACK_SLASH2, 7055).put(Swap.AnimationType.ATTACK_SPEC, 7640).put(Swap.AnimationType.DEFEND, 7056).build();
        new AnimationSetBuilder("Godsword (Bandos)").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 7642).build();
        new AnimationSetBuilder("Godsword (Armadyl)").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 7644).build();
        new AnimationSetBuilder("Godsword (Zamorak)").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 7638).build();
        new AnimationSetBuilder("Godsword (Ancient)").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 9171).build();
        new AnimationSetBuilder("Godsword (Ancient, alternative spec)").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 9173).build();
        new AnimationSetBuilder("Saradomin sword").copy("Godsword (Saradomin)").put(Swap.AnimationType.ATTACK_SPEC, 1132).build();
        new AnimationSetBuilder("Boxing gloves").poseAnims(3677, 823, 3680, 3680, 3680, 3680, 824).put(Swap.AnimationType.ATTACK_SLASH, 3678).put(Swap.AnimationType.ATTACK_STAB, 3678).put(Swap.AnimationType.DEFEND, 3679).build();
        new AnimationSetBuilder("Hand fan").poseAnims(6297, 6297, 7629, 7630, 7631, 7632, 7633).put(Swap.AnimationType.ATTACK_CRUSH, 401).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Prop sword/candy cane").poseAnims(2911, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 7328).put(Swap.AnimationType.DEFEND, 378).build();
        new AnimationSetBuilder("Staff").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_CRUSH, 419).put(Swap.AnimationType.DEFEND, 420).build();
        new AnimationSetBuilder("Staff2/Wand").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_CRUSH, 414).put(Swap.AnimationType.DEFEND, 415).build();
        new AnimationSetBuilder("Zamorakian hasta").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.DEFEND, 420).put(Swap.AnimationType.ATTACK_SPEC, 1064).put(Swap.AnimationType.ATTACK_SLASH, 440).put(Swap.AnimationType.ATTACK_CRUSH, 393).put(Swap.AnimationType.ATTACK_CRUSH2, 419, "crush2 (no offhand)").put(Swap.AnimationType.ATTACK_STAB, 381).build();
        new AnimationSetBuilder("Falconer's glove").poseAnims(5160, 5161, 5164, 5165, 5166, 5167, 5168).doNotReplace().build();
        new AnimationSetBuilder("Halberd").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_SLASH, 440).put(Swap.AnimationType.ATTACK_STAB, 428).put(Swap.AnimationType.ATTACK_SPEC, 1203).put(Swap.AnimationType.DEFEND, 430).build();
        new AnimationSetBuilder("Cursed banana").poseAnims(4646, 823, 4682, 6276, 6268, 6275, 6277).put(Swap.AnimationType.ATTACK_CRUSH, 6278).put(Swap.AnimationType.DEFEND, 6279).build();
        new AnimationSetBuilder("Elder maul").poseAnims(7518, 823, 7520, 7520, 7520, 7520, 7519).put(Swap.AnimationType.ATTACK_CRUSH, 7516).put(Swap.AnimationType.DEFEND, 7517).build();
        new AnimationSetBuilder("Scythe (holiday item)").poseAnims(847, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 440).put(Swap.AnimationType.ATTACK_CRUSH, 438).put(Swap.AnimationType.DEFEND, 435).build();
        new AnimationSetBuilder("2h sword").poseAnims(2561, 823, 2562, 2562, 2562, 2562, 2563).put(Swap.AnimationType.ATTACK_SLASH, 407).put(Swap.AnimationType.ATTACK_CRUSH, 406).put(Swap.AnimationType.DEFEND, 410).put(Swap.AnimationType.ATTACK_SPEC, 3157).build();
        new AnimationSetBuilder("Birthday balloons").poseAnims(7538, 823, 7539, 7539, 821, 822, 7540).put(Swap.AnimationType.ATTACK_CRUSH, 7541).put(Swap.AnimationType.DEFEND, 1834).build();
        new AnimationSetBuilder("Banner").poseAnims(1421, 1426, 1422, 1423, 1424, 1425, 1427).put(Swap.AnimationType.ATTACK_CRUSH, 1428).put(Swap.AnimationType.DEFEND, 1429).build();
        new AnimationSetBuilder("Dharok's greataxe").poseAnims(2065, 823, 2064, 2064, 2064, 2064, 824).put(Swap.AnimationType.ATTACK_SLASH, 2067).put(Swap.AnimationType.ATTACK_CRUSH, 2066).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Hunting knife").poseAnims(2911, 823, 7327, 7327, 821, 822, 2322).put(Swap.AnimationType.ATTACK_CRUSH, 7328).put(Swap.AnimationType.DEFEND, 378).build();
        new AnimationSetBuilder("Giant boulder").poseAnims(4193, 4194, 4194, 4194, 4194, 4194, 7274).put(Swap.AnimationType.ATTACK_CRUSH, 7275).put(Swap.AnimationType.DEFEND, 7276).build();
        new AnimationSetBuilder("Golden tench").poseAnims(8208, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 8209).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Unarmed").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 422, "punch").put(Swap.AnimationType.ATTACK_CRUSH2, 423, "crush2 (kick)").put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Dragon scimitar").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_STAB, 386).put(Swap.AnimationType.DEFEND, 388).put(Swap.AnimationType.ATTACK_SPEC, 1872).build();
        new AnimationSetBuilder("Dragon longsword/Saeldor").poseAnims(809, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_STAB, 386).put(Swap.AnimationType.DEFEND, 388).put(Swap.AnimationType.ATTACK_SPEC, 1058).build();
        new AnimationSetBuilder("Ghrazi rapier").poseAnims(809, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_STAB, 8145).put(Swap.AnimationType.DEFEND, 388).build();
        new AnimationSetBuilder("Noose wand").poseAnims(5254, 5252, 5250, 5251, 1207, 1208, 5253).put(Swap.AnimationType.ATTACK_SLASH, 440).put(Swap.AnimationType.ATTACK_CRUSH, 429).put(Swap.AnimationType.ATTACK_STAB, 428).put(Swap.AnimationType.DEFEND, 430).build();
        new AnimationSetBuilder("Magic butterfly net").poseAnims(6604, 6611, 6607, 6608, 6610, 6609, 6603).put(Swap.AnimationType.ATTACK_SLASH, 440).put(Swap.AnimationType.ATTACK_CRUSH, 429).put(Swap.AnimationType.ATTACK_STAB, 428).put(Swap.AnimationType.DEFEND, 430).build();
        new AnimationSetBuilder("Trident of the swamp").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK, 1167).put(Swap.AnimationType.DEFEND, 420).build();
        new AnimationSetBuilder("Granite maul").poseAnims(1662, 823, 1663, 1663, 1663, 1663, 1664).put(Swap.AnimationType.ATTACK_CRUSH, 1665).put(Swap.AnimationType.ATTACK_SPEC, 1667).put(Swap.AnimationType.DEFEND, 1666).build();
        new AnimationSetBuilder("Red salamander").poseAnims(5246, 823, 5245, 5245, 5245, 5245, 824).put(Swap.AnimationType.DEFEND, 388).build();
        new AnimationSetBuilder("Undead chicken").poseAnims(5363, 823, 5364, 5438, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 5439).put(Swap.AnimationType.DEFEND, 5441).build();
        new AnimationSetBuilder("Rubber chicken").poseAnims(1832, 823, 1830, 1830, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 1833).put(Swap.AnimationType.DEFEND, 1834).build();
        new AnimationSetBuilder("Easter basket").poseAnims(1837, 823, 1836, 1836, 1836, 1836, 1836).put(Swap.AnimationType.ATTACK_CRUSH, 422).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Fixed device").poseAnims(2316, 2321, 2317, 2318, 2319, 2320, 2322).put(Swap.AnimationType.ATTACK_CRUSH, 2323).put(Swap.AnimationType.DEFEND, 2324).build();
        new AnimationSetBuilder("Crystal grail").poseAnims(3040, 823, 3039, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 422, "punch").put(Swap.AnimationType.ATTACK_CRUSH2, 423, "crush2 (kick)").put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Chinchompa").poseAnims(3175, 3177, 3177, 3177, 3177, 3177, 3178).put(Swap.AnimationType.ATTACK, 7618).put(Swap.AnimationType.DEFEND, 3176).build();
        new AnimationSetBuilder("Barrelchest anchor").poseAnims(5869, 823, 5867, 5867, 5867, 5867, 5868).put(Swap.AnimationType.ATTACK_CRUSH, 5865).put(Swap.AnimationType.DEFEND, 5866).put(Swap.AnimationType.ATTACK_SPEC, 5870).build();
        new AnimationSetBuilder("Pet rock").poseAnims(6657, 6661, 6658, 6659, 6662, 6663, 6660).put(Swap.AnimationType.ATTACK_CRUSH, 422, "punch").put(Swap.AnimationType.ATTACK_CRUSH2, 423, "crush2 (kick)").put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Ballista").poseAnims(7220, 823, 7223, 7223, 7223, 7223, 7221).put(Swap.AnimationType.ATTACK, 7555).put(Swap.AnimationType.DEFEND, 7219).put(Swap.AnimationType.ATTACK_SPEC, 7556).build();
        new AnimationSetBuilder("Ivandis flail").poseAnims(8009, 8015, 8011, 8012, 8013, 8014, 8016).put(Swap.AnimationType.ATTACK_CRUSH, 8010).put(Swap.AnimationType.DEFEND, 8017).build();
        new AnimationSetBuilder("Viggora's chainmace").poseAnims(244, 823, 247, 247, 247, 247, 248).put(Swap.AnimationType.ATTACK_CRUSH, 245).put(Swap.AnimationType.DEFEND, 4177).build();
        new AnimationSetBuilder("Skeleton lantern").poseAnims(8521, 8492, 8492, 8492, 8492, 8492, 8492).put(Swap.AnimationType.ATTACK_CRUSH, 422, "punch").put(Swap.AnimationType.ATTACK_CRUSH2, 423, "crush2 (kick)").put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Bow").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 426).put(Swap.AnimationType.DEFEND, 424).put(Swap.AnimationType.ATTACK_SPEC, 1074, "spec (msb)").build();
        new AnimationSetBuilder("Comp bow").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK, 426).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Crossbow").poseAnims(4591, 823, 4226, 4227, 821, 822, 4228).put(Swap.AnimationType.ATTACK, 7552).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Zaryte crossbow").poseAnims(4591, 823, 4226, 4227, 821, 822, 4228).put(Swap.AnimationType.ATTACK, 9168).put(Swap.AnimationType.DEFEND, 424).put(Swap.AnimationType.ATTACK_SPEC, 9168).build();
        new AnimationSetBuilder("Unknown (arms out)").poseAnims(9050, 9050, 9051, 9054, 9052, 9053, 9051).doNotReplace().build();
        new AnimationSetBuilder("Dart").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 7554).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Toxic blowpipe").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK, 5061).put(Swap.AnimationType.DEFEND, 430).build();
        new AnimationSetBuilder("Thrownaxe").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 7617).put(Swap.AnimationType.ATTACK_SPEC, 7521).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Knife (non-dragon)").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 7617).put(Swap.AnimationType.ATTACK_SPEC, 8291).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Dragon knife").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 8194).put(Swap.AnimationType.ATTACK_SPEC, 8291).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Dragon knife (poisoned)").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 8195).put(Swap.AnimationType.ATTACK_SPEC, 8292).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Guthan's warspear").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_SLASH, 2081).put(Swap.AnimationType.ATTACK_CRUSH, 2082).put(Swap.AnimationType.ATTACK_STAB, 2080).put(Swap.AnimationType.DEFEND, 430).build();
        new AnimationSetBuilder("Abyssal whip").poseAnims(808, 823, 1660, 1660, 1660, 1660, 1661).put(Swap.AnimationType.ATTACK_SLASH, 1658).put(Swap.AnimationType.DEFEND, 1659).build();
        new AnimationSetBuilder("Sarachnis cudgel").poseAnims(809, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 401).put(Swap.AnimationType.ATTACK_STAB, 400).put(Swap.AnimationType.DEFEND, 403).build();
        new AnimationSetBuilder("Dragon mace").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 401).put(Swap.AnimationType.ATTACK_STAB, 400).put(Swap.AnimationType.DEFEND, 403).put(Swap.AnimationType.ATTACK_SPEC, 1060).build();
        new AnimationSetBuilder("Ancient mace").copy("Dragon mace").put(Swap.AnimationType.ATTACK_SPEC, 6147).build();
        new AnimationSetBuilder("Dragon warhammer").copy("Dragon mace").put(Swap.AnimationType.ATTACK_SPEC, 1378).build();
        new AnimationSetBuilder("Dragon axe").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 395).put(Swap.AnimationType.ATTACK_CRUSH, 401).put(Swap.AnimationType.ATTACK_STAB, 400).put(Swap.AnimationType.DEFEND, 397).put(Swap.AnimationType.ATTACK_SPEC, 2876).build();
        new AnimationSetBuilder("Dragon battleaxe").copy("Dragon axe").put(Swap.AnimationType.ATTACK_SPEC, 1056).build();
        new AnimationSetBuilder("Spear").poseAnims(813, 1209, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK_SLASH, 380).put(Swap.AnimationType.ATTACK_CRUSH, 382).put(Swap.AnimationType.ATTACK_STAB, 381).put(Swap.AnimationType.ATTACK_SPEC, 1064).put(Swap.AnimationType.DEFEND, 383).build();
        new AnimationSetBuilder("Snowball").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 5063).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Sled").poseAnims(1461, 1468, 8854, 1468, 1468, 1468, 8853).doNotReplace().build();
        new AnimationSetBuilder("Claws").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 393).put(Swap.AnimationType.ATTACK_STAB, 1067).put(Swap.AnimationType.DEFEND, 424).put(Swap.AnimationType.ATTACK_SPEC, 7514).build();
        new AnimationSetBuilder("Verac's flail").poseAnims(2061, 823, 2060, 2060, 2060, 2060, 824).put(Swap.AnimationType.ATTACK_CRUSH, 2062).put(Swap.AnimationType.DEFEND, 2063).build();
        new AnimationSetBuilder("Abyssal bludgeon").poseAnims(1652, 823, 3293, 3293, 3293, 3293, 2847).put(Swap.AnimationType.ATTACK_CRUSH, 3298).put(Swap.AnimationType.DEFEND, 1666).put(Swap.AnimationType.ATTACK_SPEC, 3299).build();
        new AnimationSetBuilder("Karil's crossbow").poseAnims(2074, 823, 2076, 2076, 2076, 2076, 2077).put(Swap.AnimationType.ATTACK, 2075).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Abyssal dagger").poseAnims(3296, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 3294).put(Swap.AnimationType.ATTACK_STAB, 3297).put(Swap.AnimationType.DEFEND, 3295).put(Swap.AnimationType.ATTACK_SPEC, 3300).build();
        new AnimationSetBuilder("Torag's hammers").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_CRUSH, 2068).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Zamorakian spear").poseAnims(1713, 1702, 1703, 1704, 1706, 1705, 1707).put(Swap.AnimationType.ATTACK_SLASH, 1712).put(Swap.AnimationType.ATTACK_CRUSH, 1710).put(Swap.AnimationType.ATTACK_STAB, 1711).put(Swap.AnimationType.DEFEND, 1709).put(Swap.AnimationType.ATTACK_SPEC, 1064).build();
        new AnimationSetBuilder("Leaf-bladed battleaxe").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 7004).put(Swap.AnimationType.ATTACK_CRUSH, 3852).put(Swap.AnimationType.DEFEND, 397).build();
        new AnimationSetBuilder("Dragon sword").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_STAB, 386).put(Swap.AnimationType.DEFEND, 388).put(Swap.AnimationType.ATTACK_SPEC, 7515).build();
        new AnimationSetBuilder("Arclight").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_STAB, 386).put(Swap.AnimationType.DEFEND, 388).put(Swap.AnimationType.ATTACK_SPEC, 2890).build();
        new AnimationSetBuilder("Dragon dagger").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_SLASH, 377).put(Swap.AnimationType.ATTACK_STAB, 376).put(Swap.AnimationType.ATTACK_SPEC, 1062).put(Swap.AnimationType.DEFEND, 378).build();
        new AnimationSetBuilder("Clan vexillum").poseAnims(9018, 7044, 9017, 9017, 9021, 9020, 9019).put(Swap.AnimationType.ATTACK_SLASH, 7045).put(Swap.AnimationType.ATTACK_CRUSH, 7054).put(Swap.AnimationType.ATTACK_STAB, 7046).put(Swap.AnimationType.DEFEND, 7056).build();
        new AnimationSetBuilder("Tightrope").poseAnims(763, 762, 762, 762, 762, 762, 762).doNotReplace().build();
        new AnimationSetBuilder("Monkey bars").poseAnims(745, 745, 744, 745, 745, 745, 744).doNotReplace().build();
        new AnimationSetBuilder("Swimming").poseAnims(773, 773, 772, 772, 772, 772, 772).doNotReplace().build();
        new AnimationSetBuilder("Swimming (drowning)").poseAnims(765, 765, 772, 772, 772, 772, 772).doNotReplace().build();
        new AnimationSetBuilder("Swimming (underwater)").poseAnims(3418, 3415, 3415, 3415, 3415, 3415, 7703).doNotReplace().build();
        new AnimationSetBuilder("Swimming (trident)").poseAnims(6998, 6998, 6996, 6996, 6996, 6996, 6995).put(Swap.AnimationType.ATTACK, 6997).doNotReplace().build();
        new AnimationSetBuilder("Transparent").poseAnims(15, 15, 13, 13, 13, 13, 13).put(Swap.AnimationType.ATTACK_SLASH, 391).put(Swap.AnimationType.DEFEND, 389).build();
        new AnimationSetBuilder("Crawling").poseAnims(845, 845, 844, 844, 844, 844, 1440).doNotReplace().build();
        new AnimationSetBuilder("Leaping").movement(1603).doNotReplace().build();
        new AnimationSetBuilder("Skipping").movement(3854).doNotReplace().build();
        new AnimationSetBuilder("Zombie").standMovement(6113, 6112).doNotReplace().build();
        new AnimationSetBuilder("Hands on hips").standMovement(6393, 6395).doNotReplace().build();
        new AnimationSetBuilder("Hands behind back").standMovement(6389, 6388).doNotReplace().build();
        new AnimationSetBuilder("Sandstorm").standMovement(6379, 6378).doNotReplace().build();
        new AnimationSetBuilder("Hunched over").standMovement(6469, 6468).doNotReplace().build();
        new AnimationSetBuilder("Posh walk").standMovement(6487, 6486).doNotReplace().build();
        new AnimationSetBuilder("Posh walk 2").standMovement(6927, 6928).doNotReplace().build();
        new AnimationSetBuilder("Looking at hands").standMovement(6075, 6076).doNotReplace().build();
        new AnimationSetBuilder("Chicken").standMovement(6397, -1).doNotReplace().build();
        new AnimationSetBuilder("Skis").poseAnims(9341, 9343, 9342, 9345, 9343, 9344, 9346).put(Swap.AnimationType.ATTACK_CRUSH, 9347).put(Swap.AnimationType.DEFEND, 9348).build();
        new AnimationSetBuilder("Colossal Blade").poseAnims(9460, 10055, 9461, 9461, 10055, 10054, 9459).put(Swap.AnimationType.ATTACK_CRUSH, 7516).put(Swap.AnimationType.ATTACK_SLASH, 7516).put(Swap.AnimationType.DEFEND, 7517).build();
        new AnimationSetBuilder("Tumeken's Shadow").poseAnims(9494, 1702, 1703, 1704, 1706, 1705, 1707).put(Swap.AnimationType.ATTACK, 9493).put(Swap.AnimationType.DEFEND, 1709).build();
        new AnimationSetBuilder("Osmumten's Fang").poseAnims(809, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK_STAB, 9471).put(Swap.AnimationType.ATTACK_SLASH, 390).put(Swap.AnimationType.ATTACK_SPEC, 6118).put(Swap.AnimationType.DEFEND, 4177).build();
        new AnimationSetBuilder("Venator Bow").poseAnims(9857, 9863, 9859, 9859, 9861, 9862, 9860).put(Swap.AnimationType.ATTACK, 9858).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Mystic cards").poseAnims(9847, 823, 9849, 820, 9851, 9852, 9850).put(Swap.AnimationType.ATTACK, 9848).put(Swap.AnimationType.DEFEND, 9853).build();
        new AnimationSetBuilder("Tzhaar-ket-om").poseAnims(2065, 823, 2064, 2064, 2064, 2064, 824).put(Swap.AnimationType.ATTACK, 2661).put(Swap.AnimationType.DEFEND, 1661).build();
        new AnimationSetBuilder("Toktz-xil-ul (obsidian ring)").poseAnims(808, 823, 819, 820, 821, 822, 824).put(Swap.AnimationType.ATTACK, 7558).put(Swap.AnimationType.DEFEND, 424).build();
        new AnimationSetBuilder("Thammaron's sceptre").poseAnims(813, 1205, 1205, 1206, 1207, 1208, 1210).put(Swap.AnimationType.ATTACK, 419).put(Swap.AnimationType.DEFEND, 420).build();
        new AnimationSetBuilder("2h axe").poseAnims(10075, 1205, 10076, 10076, 10076, 10076, 10077).put(Swap.AnimationType.ATTACK, 10079).put(Swap.AnimationType.ATTACK_SPEC, 10078).put(Swap.AnimationType.DEFEND, 10080).build();
        new AnimationSetBuilder("Soulreaper axe").poseAnims(10169, 823, 10170, 10170, 10170, 10170, 824).put(Swap.AnimationType.ATTACK_SLASH, 10172).put(Swap.AnimationType.ATTACK_CRUSH, 10171).put(Swap.AnimationType.ATTACK_SPEC, 10173).put(Swap.AnimationType.DEFEND, 424).build();
        Collections.sort(animationSets);
    }

    AnimationSet() {
        this("", AnimationSetType.MELEE_GENERIC, false, new int[Swap.AnimationType.values().length]);
    }

    AnimationSet(String name, AnimationSetType animationSetType, boolean doNotReplace, int[] animations) {
        this.name = name;
        this.animationSetType = animationSetType;
        this.doNotReplace = doNotReplace;
        assert (animations.length == Swap.AnimationType.values().length);
        this.animations = animations;
    }

    public int getAnimation(Swap.AnimationType type) {
        return this.animations[type.ordinal()];
    }

    public Swap.AnimationType getType(int animationId) {
        for (int i = 0; i < this.animations.length; ++i) {
            int animation = this.animations[i];
            if (animation <= 0 || animation != animationId) continue;
            return Swap.AnimationType.values()[i];
        }
        return null;
    }

    public String toString() {
        return this.name + " " + Arrays.stream(this.animations).boxed().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnimationSet that = (AnimationSet)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.animations, that.animations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.animations);
    }

    public String getComboBoxName() {
        return this.name;
    }

    static {
        AnimationSet.loadAnimationSets();
    }

    private static class AnimationSetBuilder {
        public int[] animations = new int[Swap.AnimationType.values().length];
        private AnimationSetType type;
        private String name;
        private boolean doNotReplace;

        public AnimationSetBuilder(String name) {
            Arrays.fill(this.animations, -1);
            this.doNotReplace = false;
            this.name = name;
        }

        public AnimationSetBuilder doNotReplace() {
            this.doNotReplace = true;
            return this;
        }

        public AnimationSetBuilder put(Swap.AnimationType type, int id) {
            return this.put(type, id, null);
        }

        public AnimationSetBuilder put(Swap.AnimationType type, int id, String description) {
            if (description != null) {
                descriptions.put(id, description);
            }
            if (id != -1) {
                this.animations[type.ordinal()] = id;
            }
            return this;
        }

        public AnimationSetBuilder poseAnims(int stand, int rotate, int walk, int walkBackwards, int shuffleLeft, int shuffleRight, int run) {
            this.put(Swap.AnimationType.STAND, stand);
            this.put(Swap.AnimationType.ROTATE, rotate);
            this.movement(walk, walkBackwards, shuffleLeft, shuffleRight, run);
            return this;
        }

        public AnimationSetBuilder movement(int walk, int walkBackwards, int shuffleLeft, int shuffleRight, int run) {
            this.put(Swap.AnimationType.WALK, walk);
            this.put(Swap.AnimationType.WALK_BACKWARD, walkBackwards);
            this.put(Swap.AnimationType.SHUFFLE_LEFT, shuffleLeft);
            this.put(Swap.AnimationType.SHUFFLE_RIGHT, shuffleRight);
            this.put(Swap.AnimationType.RUN, run);
            return this;
        }

        public AnimationSetBuilder movement(int all) {
            return this.movement(all, all, all, all, all);
        }

        public AnimationSetBuilder type(AnimationSetType type) {
            this.type = type;
            return this;
        }

        public void build() {
            int animation;
            if (this.doNotReplace && (animation = this.animations[Swap.AnimationType.STAND.ordinal()]) > 0) {
                doNotReplaceIdles.add(animation);
            }
            animationSets.add(new AnimationSet(this.name, this.type, this.doNotReplace, this.animations));
        }

        public AnimationSetBuilder standMovement(int stand, int movement) {
            this.put(Swap.AnimationType.STAND, stand);
            this.put(Swap.AnimationType.ROTATE, stand);
            this.movement(movement);
            return this;
        }

        public AnimationSetBuilder copy(String setToCopy) {
            AnimationSet animationSet = AnimationSet.getAnimationSet(setToCopy);
            this.animations = Arrays.copyOf(animationSet.animations, animationSet.animations.length);
            return this;
        }
    }

    static enum AnimationSetType {
        MELEE_GENERIC,
        MELEE_SPECIFIC,
        RANGED,
        RANGED_FUN,
        MAGIC,
        FUN;

    }
}

