/*
 * Decompiled with CFR 0.152.
 */
package com.wildernesswarnings;

import com.google.inject.Provides;
import com.wildernesswarnings.WildernessWarningsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.menuentryswapper.MenuEntrySwapperPlugin;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wilderness Warnings")
@PluginDependency(value=MenuEntrySwapperPlugin.class)
public class WildernessWarningsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WildernessWarningsPlugin.class);
    static final String WILDERNESS_ACCESS_MENU_ENTRIES = "rub,Burning*\nChaos*,Burning*\nBandit*,Burning*\nLava*,Burning*\nBreak,Annakarl*\nBreak,Dareeyak*\nBreak,Carrallangar*\nBreak,Ghorrock*\nBreak,Wilderness*\nBreak,Ice Plateau*\nTeleport,Revenant Cave*\nTeleport,Wilderness*\nCross,Wilderness*\nTravel to Wilderness*,*\nTravel to Ferox*,*\nHunter Cape*,Teleport\nPass-Through,Barrier\nEnter,Annakarl*\nEnter,Carrallangar*\nEnter,Dareeyak*\nEnter,Ice Plateau*\nEnter,Ghorrock\n";
    static final String EDGEVILLE_AND_ARDOUGNE_LEVER = "Pull,Lever\n";
    static final String CORP_BEAST_CAVE_EXIT = "Exit,Cave exit\n";
    final List<CustomSwap> customHides = new ArrayList<CustomSwap>();
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private WildernessWarningsConfig config;

    protected void startUp() throws Exception {
        this.customHides.clear();
        this.customHides.addAll(this.loadCustomSwaps(WILDERNESS_ACCESS_MENU_ENTRIES));
    }

    private Collection<? extends CustomSwap> loadCustomSwaps(String customSwaps) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12342 || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 10291) {
                customSwaps = (String)customSwaps + EDGEVILLE_AND_ARDOUGNE_LEVER;
            } else if (this.client.getLocalPlayer().getWorldLocation().getRegionID() == 11842) {
                customSwaps = (String)customSwaps + CORP_BEAST_CAVE_EXIT;
            }
        }
        ArrayList<CustomSwap> swaps = new ArrayList<CustomSwap>();
        for (String customSwap : ((String)customSwaps).split("\n")) {
            if (customSwap.trim().equals("")) continue;
            String[] split = customSwap.split(",");
            swaps.add(new CustomSwap(split[0].toLowerCase().trim(), split.length > 1 ? split[1].toLowerCase().trim() : "", split.length > 2 ? split[2].toLowerCase().trim() : null, split.length > 3 ? split[3].toLowerCase().trim() : null));
        }
        return swaps;
    }

    public void customSwaps() {
        if (this.client.getWorld() == 474 || this.client.getWorld() == 533 || this.client.getWorld() == 365) {
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            if (menuEntries.length == 0) {
                return;
            }
            menuEntries = this.filterEntries(menuEntries);
            this.client.setMenuEntries(menuEntries);
        }
    }

    private MenuEntry[] filterEntries(MenuEntry[] menuEntries) {
        ArrayList<MenuEntry> filtered = new ArrayList<MenuEntry>();
        for (MenuEntry entry : menuEntries) {
            String target;
            String option = Text.standardize((String)Text.removeTags((String)entry.getOption()));
            if (this.matches(option, target = Text.standardize((String)Text.removeTags((String)entry.getTarget())), menuEntries, this.customHides) != -1) continue;
            filtered.add(entry);
        }
        return filtered.toArray(new MenuEntry[0]);
    }

    private int matches(String entryOption, String entryTarget, MenuEntry[] entries, List<CustomSwap> swaps) {
        int topEntryIndex = this.getTopMenuEntryIndex(entries);
        MenuEntry topEntry = entries[topEntryIndex];
        String target = Text.standardize((String)topEntry.getTarget());
        String option = Text.standardize((String)topEntry.getOption());
        for (int i = 0; i < swaps.size(); ++i) {
            CustomSwap _configEntry = swaps.get(i);
            if (!_configEntry.option.equals(entryOption) && !WildcardMatcher.matches((String)_configEntry.option, (String)entryOption) || !_configEntry.target.equals(entryTarget) && !WildcardMatcher.matches((String)_configEntry.target, (String)entryTarget)) continue;
            boolean a = _configEntry.topOption == null;
            boolean b = _configEntry.topTarget == null;
            Supplier<Boolean> c = () -> _configEntry.topOption.equals(option) || WildcardMatcher.matches((String)_configEntry.topOption, (String)option);
            Supplier<Boolean> d = () -> _configEntry.topTarget.equals(target) || WildcardMatcher.matches((String)_configEntry.topTarget, (String)target);
            if (!a && !b && (!c.get().booleanValue() || !d.get().booleanValue())) continue;
            return i;
        }
        return -1;
    }

    private int getTopMenuEntryIndex(MenuEntry[] menuEntries) {
        for (int i = menuEntries.length - 1; i >= 0; --i) {
            if (menuEntries[i].getType().getId() >= 1000 || menuEntries[i].isDeprioritized()) continue;
            return i;
        }
        return menuEntries.length - 1;
    }

    @Provides
    WildernessWarningsConfig provideConfig(ConfigManager configManager) {
        return (WildernessWarningsConfig)configManager.getConfig(WildernessWarningsConfig.class);
    }

    @Subscribe(priority=-1.0f)
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12342 || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 10291 || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 11842) {
            this.customHides.clear();
            this.customHides.addAll(this.loadCustomSwaps(WILDERNESS_ACCESS_MENU_ENTRIES));
        }
        this.customSwaps();
    }

    static class CustomSwap {
        private final String option;
        private final String target;
        private final String topOption;
        private final String topTarget;

        CustomSwap(String option, String target) {
            this(option, target, null, null);
        }

        public String getOption() {
            return this.option;
        }

        public String getTarget() {
            return this.target;
        }

        public String getTopOption() {
            return this.topOption;
        }

        public String getTopTarget() {
            return this.topTarget;
        }

        public String toString() {
            return "WildernessWarningsPlugin.CustomSwap(option=" + this.getOption() + ", target=" + this.getTarget() + ", topOption=" + this.getTopOption() + ", topTarget=" + this.getTopTarget() + ")";
        }

        public CustomSwap(String option, String target, String topOption, String topTarget) {
            this.option = option;
            this.target = target;
            this.topOption = topOption;
            this.topTarget = topTarget;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomSwap)) {
                return false;
            }
            CustomSwap other = (CustomSwap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$option = this.getOption();
            String other$option = other.getOption();
            if (this$option == null ? other$option != null : !this$option.equals(other$option)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$topOption = this.getTopOption();
            String other$topOption = other.getTopOption();
            if (this$topOption == null ? other$topOption != null : !this$topOption.equals(other$topOption)) {
                return false;
            }
            String this$topTarget = this.getTopTarget();
            String other$topTarget = other.getTopTarget();
            return !(this$topTarget == null ? other$topTarget != null : !this$topTarget.equals(other$topTarget));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomSwap;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $option = this.getOption();
            result = result * 59 + ($option == null ? 43 : $option.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $topOption = this.getTopOption();
            result = result * 59 + ($topOption == null ? 43 : $topOption.hashCode());
            String $topTarget = this.getTopTarget();
            result = result * 59 + ($topTarget == null ? 43 : $topTarget.hashCode());
            return result;
        }
    }
}

