/*
 * Decompiled with CFR 0.152.
 */
package com.combatlocked;

import com.combatlocked.CombatLockedConfig;
import com.combatlocked.CombatLockedOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Combat Locked")
public class CombatLockedPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CombatLockedPlugin.class);
    private static final Skill[] SKILLS = new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.PRAYER, Skill.MAGIC};
    private static final int SCRIPTID_STATS_SETLEVEL = 394;
    private static final Pattern CA_MESSAGE_PATTERN = Pattern.compile("Congratulations, you've completed an? (?<tier>\\w+) combat task: <col=[0-9a-f]+>(?<task>(.+))</col>");
    private int availableLevels;
    private int totalCas;
    private boolean initialized;
    private String profileKey;
    private final Widget[] warnings = new Widget[24];
    private Widget currentWidget;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private CombatLockedOverlay overlay;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private CombatLockedConfig config;

    protected void startUp() throws Exception {
        if (this.config.showOverlay()) {
            this.overlayManager.add((Overlay)this.overlay);
        }
        this.initialized = false;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.profileKey = this.configManager.getRSProfileKey();
            this.loadCasConfig();
            this.clientThread.invoke(this::drawWarnings);
        }
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(this::removeWarnings);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("combatlocked".equals(event.getGroup())) {
            this.updateAvailableLevels();
            this.updateWarnings();
            if ("showOverlay".equals(event.getKey())) {
                if (this.config.showOverlay()) {
                    this.overlayManager.add((Overlay)this.overlay);
                } else {
                    this.overlayManager.remove((Overlay)this.overlay);
                }
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher m;
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String chatMessage = event.getMessage();
        if (chatMessage.contains("combat task") && (m = CA_MESSAGE_PATTERN.matcher(chatMessage)).find()) {
            ++this.totalCas;
            this.saveCasConfig();
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() != 394) {
            return;
        }
        this.currentWidget = event.getScriptEvent().getSource();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 394 && this.currentWidget != null) {
            this.drawWarning(this.currentWidget);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        Widget totalWidget;
        if (event.getGroupId() != 717) {
            return;
        }
        Widget caWidget = this.client.getWidget(717, 14);
        if (caWidget != null && (totalWidget = caWidget.getChild(3)) != null) {
            this.totalCas = Integer.parseInt(totalWidget.getText());
            this.initialized = true;
            this.saveCasConfig();
            this.updateAvailableLevels();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        this.updateAvailableLevels();
        Skill skill = event.getSkill();
        int idx = Arrays.asList(SKILLS).indexOf(skill);
        if (this.warnings[idx] != null) {
            this.warnings[idx].setHidden(!this.shouldWarn(skill));
        }
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged event) {
        String profileKey = this.configManager.getRSProfileKey();
        if (profileKey == null || profileKey.equals(this.profileKey)) {
            return;
        }
        this.profileKey = profileKey;
        this.loadCasConfig();
    }

    @Provides
    CombatLockedConfig provideConfig(ConfigManager configManager) {
        return (CombatLockedConfig)configManager.getConfig(CombatLockedConfig.class);
    }

    int getAvailableLevels() {
        return this.availableLevels;
    }

    int getTotalCas() {
        return this.totalCas;
    }

    boolean getInitialized() {
        return this.initialized;
    }

    private void drawWarnings() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (Widget skillTile : skillsContainer.getStaticChildren()) {
            this.drawWarning(skillTile);
        }
    }

    private void drawWarning(Widget skillTile) {
        int idx = WidgetInfo.TO_CHILD((int)skillTile.getId()) - 1;
        if (idx >= 23 || this.warnings[idx] != null) {
            return;
        }
        Skill skill = SKILLS[idx];
        Widget box = skillTile.createChild(-1, 3);
        box.setWidthMode(1);
        box.setHeightMode(1);
        box.setOriginalHeight(4);
        box.setOriginalWidth(4);
        box.setPos(0, 0, 1, 1);
        box.setFilled(true);
        this.warnings[idx] = box;
        this.updateWarning(skill);
    }

    private void updateWarnings() {
        this.clientThread.invoke(() -> {
            for (Skill skill : SKILLS) {
                this.updateWarning(skill);
            }
        });
    }

    private void updateWarning(Skill skill) {
        int idx = Arrays.asList(SKILLS).indexOf(skill);
        Widget w = this.warnings[idx];
        w.setOpacity(255 - this.getWarnColor().getAlpha());
        w.setTextColor(this.getWarnColor().getRGB());
        w.setHidden(!this.shouldWarn(skill));
        w.revalidate();
    }

    private void removeWarnings() {
        for (int i = 0; i < this.warnings.length; ++i) {
            this.removeWarning(this.warnings[i]);
            this.warnings[i] = null;
        }
    }

    private void removeWarning(Widget w) {
        if (w == null) {
            return;
        }
        Widget parent = w.getParent();
        Widget[] children = parent.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != w) continue;
            children[i] = null;
        }
    }

    private void saveCasConfig() {
        if (this.profileKey == null || !this.initialized) {
            return;
        }
        this.configManager.setConfiguration("combatlocked", this.profileKey, "totalCas", Integer.toString(this.totalCas));
    }

    private void loadCasConfig() {
        if (this.profileKey == null) {
            return;
        }
        String casConfig = this.configManager.getConfiguration("combatlocked", this.profileKey, "totalCas");
        if (casConfig == null) {
            this.initialized = false;
        } else {
            this.initialized = true;
            this.totalCas = Integer.parseInt(casConfig);
        }
    }

    private void updateAvailableLevels() {
        int totalLevels = Arrays.stream(SKILLS).reduce(0, (a, v) -> a + this.client.getRealSkillLevel(v), Integer::sum);
        this.availableLevels = this.totalCas * this.config.levelsPerCa() - totalLevels + SKILLS.length;
    }

    private boolean shouldWarn(Skill skill) {
        if (this.availableLevels > 0 && !this.config.warnWhenCloseAndAvailable()) {
            return false;
        }
        if (this.availableLevels <= 0 && !this.config.warnWhenCloseNotAvailable()) {
            return false;
        }
        int xp = this.client.getSkillExperience(skill);
        int level = this.client.getRealSkillLevel(skill);
        return level < 99 && this.reverseLerp(Experience.getXpForLevel((int)level), Experience.getXpForLevel((int)(level + 1)), xp) >= (float)this.getWarnThreshold() / 100.0f;
    }

    private int getWarnThreshold() {
        if (this.availableLevels > 0) {
            return this.config.warnThresholdAvailable();
        }
        return this.config.warnThresholdNotAvailable();
    }

    private Color getWarnColor() {
        if (this.availableLevels > 0) {
            return this.config.warnColorAvailable();
        }
        return this.config.warnColorNotAvailable();
    }

    private float reverseLerp(int a, int b, int x) {
        return (float)(x - a) / (float)(b - a);
    }
}

