/*
 * Decompiled with CFR 0.152.
 */
package com.combatlocked;

import com.combatlocked.CombatLockedConfig;
import com.combatlocked.CombatLockedPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class CombatLockedOverlay
extends OverlayPanel {
    private final Client client;
    private final CombatLockedConfig config;
    private final CombatLockedPlugin plugin;
    private static final String TOTAL_CAS_STRING = "Total Combat Achievements:";
    private static final String AVAILABLE_LEVELS_STRING = "Available levels:";
    private static final String[] STRINGS = new String[]{"Total Combat Achievements:", "Available levels:"};

    @Inject
    private CombatLockedOverlay(Client client, CombatLockedConfig config, CombatLockedPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Combat Locked plugin"));
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.getInitialized()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Open the Combat Achievements panel to initialize the plugin. You only have to do this once.").build());
        } else {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Total CAs").right(Integer.toString(this.plugin.getTotalCas())).build());
            int availableLevels = this.plugin.getAvailableLevels();
            LineComponent.LineComponentBuilder a = LineComponent.builder().left("Available levels").right(Integer.toString(this.plugin.getAvailableLevels()));
            if (availableLevels <= 0) {
                a = a.rightColor(Color.red);
            }
            this.panelComponent.getChildren().add(a.build());
        }
        return super.render(graphics);
    }

    private int getLongestStringWidth(String[] strings, Graphics2D graphics) {
        int longest = graphics.getFontMetrics().stringWidth("000000");
        for (String i : strings) {
            int currentItemWidth = graphics.getFontMetrics().stringWidth(i);
            if (currentItemWidth <= longest) continue;
            longest = currentItemWidth;
        }
        return longest;
    }

    private String addCommasToNumber(int number) {
        String input = Integer.toString(number);
        StringBuilder output = new StringBuilder();
        for (int x = input.length() - 1; x >= 0; --x) {
            int lastPosition = input.length() - x - 1;
            if (lastPosition != 0 && lastPosition % 3 == 0) {
                output.append(",");
            }
            output.append(input.charAt(x));
        }
        return output.reverse().toString();
    }
}

