/*
 * Decompiled with CFR 0.152.
 */
package com.combatlocked;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="combatlocked")
public interface CombatLockedConfig
extends Config {
    public static final String GROUP = "combatlocked";
    @ConfigSection(name="With Levels Available", description="With Levels Available", position=1)
    public static final String availableSection = "withLevelsAvailable";
    @ConfigSection(name="With No Levels Available", description="With No Levels Available", position=2)
    public static final String notAvailableSection = "withNoLevelsAvailable";

    @ConfigItem(keyName="levelsPerCa", name="Levels Per Combat Achievement", description="How many levels become available for each Combat Achievement earned", position=0)
    default public int levelsPerCa() {
        return 4;
    }

    @ConfigItem(keyName="showOverlay", name="Show Overlay", description="Show an overlay on the game screen with levels available", position=1)
    default public boolean showOverlay() {
        return true;
    }

    @ConfigItem(keyName="warnWhenCloseAndAvailable", name="Skill tab warning", description="Show a warning in the skill tab when close to leveling and levels are available", section="withLevelsAvailable", position=1)
    default public boolean warnWhenCloseAndAvailable() {
        return true;
    }

    @Range(min=0, max=100)
    @ConfigItem(keyName="warnThresholdAvailable", name="Threshold (%)", description="Percentage of level progress to show warning at", section="withLevelsAvailable", position=2)
    default public int warnThresholdAvailable() {
        return 90;
    }

    @Alpha
    @ConfigItem(keyName="warnColorAvailable", name="Color", description="Color for the skill tab warning", section="withLevelsAvailable", position=3)
    default public Color warnColorAvailable() {
        return new Color(255, 255, 0, 100);
    }

    @ConfigItem(keyName="warnWhenCloseNotAvailable", name="Skill tab warning", description="Show a warning in the skill tab when close to leveling and levels are not available", section="withNoLevelsAvailable", position=1)
    default public boolean warnWhenCloseNotAvailable() {
        return true;
    }

    @Range(min=0, max=100)
    @ConfigItem(keyName="warnThresholdNotAvailable", name="Threshold (%)", description="Percentage of level progress to show warning at", section="withNoLevelsAvailable", position=2)
    default public int warnThresholdNotAvailable() {
        return 85;
    }

    @Alpha
    @ConfigItem(keyName="warnColorNotAvailable", name="Color", description="Color for the skill tab warning", section="withNoLevelsAvailable", position=3)
    default public Color warnColorNotAvailable() {
        return new Color(255, 0, 0, 100);
    }
}

