/*
 * Decompiled with CFR 0.152.
 */
package com.hidewidgets;

import com.google.inject.Provides;
import com.hidewidgets.HideWidgetsConfig;
import com.hidewidgets.HideWidgetsKeyboardListener;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.CanvasSizeChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hide Widgets", description="Hides all widgets (Resizable only)", tags={})
public class HideWidgetsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HideWidgetsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private HideWidgetsConfig config;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HideWidgetsKeyboardListener hideWidgetsKeyboardListener;
    private Boolean hide = false;

    @Provides
    private HideWidgetsConfig provideConfig(ConfigManager configManager) {
        return (HideWidgetsConfig)configManager.getConfig(HideWidgetsConfig.class);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if ((scriptPostFired.getScriptId() == 907 || scriptPostFired.getScriptId() == 903) && this.hide.booleanValue()) {
            this.hideWidgets(true);
        }
    }

    @Subscribe
    public void onCanvasSizeChanged(CanvasSizeChanged canvasSizeChanged) {
        if (!this.client.isResized()) {
            this.hideWidgets(false);
        }
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hideWidgetsKeyboardListener);
        this.hide = false;
        this.hideWidgets(false);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.hideWidgetsKeyboardListener);
        this.hideWidgets(false);
    }

    public void toggle() {
        log.debug("toggled hiding widgets");
        this.hide = this.hide == false;
        this.hideWidgets(this.hide);
    }

    protected void hideWidgetChildren(Widget root, boolean hide) {
        Widget[] rootDynamicChildren = root.getDynamicChildren();
        Widget[] rootNestedChildren = root.getNestedChildren();
        Widget[] rootStaticChildren = root.getStaticChildren();
        Widget[] rootChildren = new Widget[rootDynamicChildren.length + rootNestedChildren.length + rootStaticChildren.length];
        System.arraycopy(rootDynamicChildren, 0, rootChildren, 0, rootDynamicChildren.length);
        System.arraycopy(rootNestedChildren, 0, rootChildren, rootDynamicChildren.length, rootNestedChildren.length);
        System.arraycopy(rootStaticChildren, 0, rootChildren, rootDynamicChildren.length + rootNestedChildren.length, rootStaticChildren.length);
        if (rootChildren != null) {
            for (Widget w : rootChildren) {
                if (w == null || w.getContentType() == 1337) continue;
                w.setHidden(hide);
            }
        }
    }

    protected void hideWidgets(boolean hide) {
        if (hide && !this.client.isResized()) {
            this.hideWidgets(false);
        } else {
            this.clientThread.invokeLater(() -> {
                Widget zoom;
                Widget root = this.client.getWidget(164, 65);
                if (root != null) {
                    this.hideWidgetChildren(root, hide);
                }
                if ((root = this.client.getWidget(161, 33)) != null) {
                    this.hideWidgetChildren(root, hide);
                }
                if ((zoom = this.client.getWidget(161, 90)) != null) {
                    zoom.setHidden(false);
                }
                if ((zoom = this.client.getWidget(164, 87)) != null) {
                    zoom.setHidden(false);
                }
            });
        }
    }
}

