/*
 * Decompiled with CFR 0.152.
 */
package com.example.afkthreshold;

import com.example.afkthreshold.AfkThresholdConfig;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK Threshold")
public class AfkThresholdPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkThresholdPlugin.class);
    private boolean alreadyTriggered = false;
    private Instant lastAnimating;
    private int lastAnimation = -1;
    private Instant lastInteracting;
    private Actor lastInteract;
    @Inject
    private Client client;
    @Inject
    private AfkThresholdConfig config;
    @Inject
    private Notifier notifier;

    protected void startUp() throws Exception {
        log.info("AFK Threshold started!");
    }

    protected void shutDown() throws Exception {
        log.info("AFK Threshold stopped!");
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player local = this.client.getLocalPlayer();
        if (this.client.getGameState() == GameState.LOGGED_IN || local != null || System.currentTimeMillis() - this.client.getMouseLastPressedMillis() < 1000L || this.client.getKeyboardIdleTicks() < 10) {
            long lastKeyboardMillis = System.currentTimeMillis() - (long)(this.client.getKeyboardIdleTicks() * 600);
            long lastInteraction = Math.max(this.client.getMouseLastPressedMillis(), lastKeyboardMillis);
            Duration waitDuration = Duration.ofSeconds(this.config.afkThreshold());
            Duration postIdleDuration = Duration.ofSeconds(this.config.postIdleWait());
            if (System.currentTimeMillis() > lastInteraction + waitDuration.toMillis()) {
                if (!this.alreadyTriggered && this.checkAnimationIdle(postIdleDuration, local)) {
                    this.alreadyTriggered = true;
                    log.info("Sending notification!");
                    this.notifier.notify("You have been AFK for enough time and are now Idle!");
                }
            } else {
                this.alreadyTriggered = false;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer != event.getActor()) {
            return;
        }
        int graphic = localPlayer.getGraphic();
        int animation = localPlayer.getAnimation();
        switch (animation) {
            case 24: 
            case 88: 
            case 335: 
            case 363: 
            case 364: 
            case 618: 
            case 619: 
            case 620: 
            case 621: 
            case 622: 
            case 623: 
            case 624: 
            case 625: 
            case 626: 
            case 627: 
            case 628: 
            case 629: 
            case 642: 
            case 719: 
            case 720: 
            case 721: 
            case 726: 
            case 827: 
            case 830: 
            case 832: 
            case 867: 
            case 869: 
            case 871: 
            case 873: 
            case 875: 
            case 877: 
            case 879: 
            case 883: 
            case 884: 
            case 886: 
            case 887: 
            case 888: 
            case 889: 
            case 890: 
            case 891: 
            case 892: 
            case 894: 
            case 895: 
            case 896: 
            case 897: 
            case 898: 
            case 899: 
            case 931: 
            case 1193: 
            case 1248: 
            case 1249: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 2117: 
            case 2270: 
            case 2280: 
            case 2281: 
            case 2282: 
            case 2292: 
            case 2390: 
            case 2846: 
            case 3705: 
            case 3866: 
            case 3873: 
            case 4067: 
            case 4068: 
            case 4412: 
            case 4462: 
            case 4471: 
            case 4481: 
            case 4482: 
            case 5108: 
            case 5249: 
            case 6295: 
            case 6298: 
            case 6678: 
            case 6679: 
            case 6680: 
            case 6681: 
            case 6682: 
            case 6683: 
            case 6684: 
            case 6685: 
            case 6686: 
            case 6687: 
            case 6688: 
            case 6689: 
            case 6709: 
            case 6752: 
            case 6753: 
            case 6754: 
            case 6755: 
            case 6756: 
            case 6757: 
            case 6758: 
            case 6932: 
            case 7139: 
            case 7151: 
            case 7199: 
            case 7201: 
            case 7202: 
            case 7264: 
            case 7282: 
            case 7283: 
            case 7401: 
            case 7402: 
            case 7529: 
            case 7531: 
            case 7553: 
            case 7699: 
            case 8188: 
            case 8189: 
            case 8190: 
            case 8191: 
            case 8192: 
            case 8193: 
            case 8303: 
            case 8312: 
            case 8313: 
            case 8324: 
            case 8336: 
            case 8344: 
            case 8345: 
            case 8346: 
            case 8347: 
            case 8472: 
            case 8473: 
            case 8474: 
            case 8475: 
            case 8476: 
            case 8477: 
            case 8478: 
            case 8479: 
            case 8480: 
            case 8481: 
            case 8778: 
            case 8784: 
            case 8786: 
            case 8787: 
            case 8788: 
            case 8789: 
            case 8886: 
            case 8887: 
            case 8911: 
            case 8969: 
            case 9350: 
            case 24975: {
                this.resetTimers();
                this.lastAnimation = animation;
                this.lastAnimating = Instant.now();
                break;
            }
            case 4413: {
                if (graphic == 746) {
                    this.resetTimers();
                    this.lastAnimation = animation;
                    this.lastAnimating = Instant.now();
                    break;
                }
            }
            case -1: {
                this.lastAnimating = Instant.now();
                break;
            }
            default: {
                this.lastAnimation = -1;
                this.lastAnimating = null;
            }
        }
    }

    private boolean checkAnimationIdle(Duration waitDuration, Player local) {
        if (this.lastAnimation == -1) {
            return false;
        }
        int animation = local.getAnimation();
        if (animation == -1) {
            if (this.lastAnimating != null && Instant.now().compareTo(this.lastAnimating.plus(waitDuration)) >= 0) {
                this.lastAnimation = -1;
                this.lastAnimating = null;
                this.lastInteract = null;
                this.lastInteracting = null;
                return true;
            }
        } else {
            this.lastAnimating = Instant.now();
        }
        return false;
    }

    private void resetTimers() {
        Player local = this.client.getLocalPlayer();
        this.lastAnimating = null;
        if (this.client.getGameState() == GameState.LOGIN_SCREEN || local == null || local.getAnimation() != this.lastAnimation) {
            this.lastAnimation = -1;
        }
    }

    @Provides
    AfkThresholdConfig provideConfig(ConfigManager configManager) {
        return (AfkThresholdConfig)configManager.getConfig(AfkThresholdConfig.class);
    }
}

