/*
 * Decompiled with CFR 0.152.
 */
package cf.sqlskid.motivation;

import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Motivation", description="Get a little bit of motivation after death.", tags={"motivation", "death", "die", "pvp"})
public class MotivationPlugin
extends Plugin {
    private final String[] messages = new String[]{"Don't give up!", "Never give up!", "You can do it!", "Stay determined!", "Follow your dreams!", "Better luck next time!"};
    @Inject
    public Client client;
    @Inject
    public ChatMessageManager chatMessageManager;

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        if (event.getActor().getHealthRatio() != 0) {
            return;
        }
        if (event.getActor().getAnimation() != 836) {
            return;
        }
        if (event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        int messageNumber = ThreadLocalRandom.current().nextInt(1, this.messages.length) - 1;
        this.sendChatMessage(this.messages[messageNumber]);
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

