/*
 * Decompiled with CFR 0.152.
 */
package com.npcdialoglog;

import com.google.inject.Provides;
import com.npcdialoglog.Dialog;
import com.npcdialoglog.NpcDialogLogConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ChatColorConfig;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Npc Dialog Log", description="Adds dialog between the player and NPCs to the chat as public chat.", tags={"chat, quest, npc"})
public class NpcDialogLog
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcDialogLog.class);
    private final int TIMEOUT_TICKS = 5;
    private final Map<Actor, Integer> lastMessageTickTime = new HashMap<Actor, Integer>();
    @Inject
    NpcDialogLogConfig npcDialogLogConfig;
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatColorConfig chatColorConfig;
    private Actor actorInteractedWith = null;
    private Dialog lastNpcDialog = null;
    private Dialog lastPlayerDialog = null;

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.actorInteractedWith != null) {
            this.checkWidgetDialogs();
        }
        Iterator<Actor> iterator = this.lastMessageTickTime.keySet().iterator();
        while (iterator.hasNext()) {
            Actor actor = iterator.next();
            if (this.client.getTickCount() - this.lastMessageTickTime.get(actor) <= 5) continue;
            actor.setOverheadText(null);
            iterator.remove();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        switch (gameStateChanged.getGameState()) {
            case CONNECTION_LOST: 
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.lastMessageTickTime.clear();
                break;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.client.getLocalPlayer() != null && event.getType() == ChatMessageType.PUBLICCHAT && event.getName().equals(this.client.getLocalPlayer().getName()) && this.client.getLocalPlayer().getOverheadText() != null && this.lastMessageTickTime.remove(this.client.getLocalPlayer()) != null) {
            log.debug("Player sent message while dialog was being displayed. Cleared last dialog time.");
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (event.getTarget() == null || event.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        this.lastNpcDialog = null;
        this.lastPlayerDialog = null;
        this.actorInteractedWith = event.getTarget();
    }

    private void checkWidgetDialogs() {
        Dialog playerDialog;
        Dialog npcDialog;
        if (!(!this.npcDialogLogConfig.displayNpcDialog() && !this.npcDialogLogConfig.displayNpcOverheadText() || (npcDialog = this.getWidgetDialogSafely()).getText() == null || this.lastNpcDialog != null && this.lastNpcDialog.getText().equals(npcDialog.getText()))) {
            this.lastNpcDialog = npcDialog;
            if (npcDialog.getName() != null) {
                if (this.npcDialogLogConfig.displayNpcOverheadText()) {
                    this.setNpcOverheadDialog(npcDialog);
                }
                this.lastPlayerDialog = null;
                if (this.npcDialogLogConfig.displayNpcDialog()) {
                    this.addDialogMessage(npcDialog.getName(), npcDialog.getText());
                    log.debug("Added chat dialog: " + npcDialog.getName() + ": " + npcDialog.getText());
                }
            }
        }
        if (!(!this.npcDialogLogConfig.displayPlayerDialog() && !this.npcDialogLogConfig.displayPlayerOverheadText() || (playerDialog = this.getWidgetDialogSafely(217, WidgetInfo.DIALOG_NPC_NAME.getChildId(), WidgetInfo.DIALOG_NPC_TEXT.getChildId())).getText() == null || this.lastPlayerDialog != null && this.lastPlayerDialog.getText().equals(playerDialog.getText()))) {
            this.lastPlayerDialog = playerDialog;
            if (playerDialog.getName() != null) {
                if (this.client.getLocalPlayer() != null && this.npcDialogLogConfig.displayPlayerOverheadText()) {
                    this.lastMessageTickTime.put((Actor)this.client.getLocalPlayer(), this.client.getTickCount());
                    this.client.getLocalPlayer().setOverheadText(playerDialog.getText());
                    log.debug("Set overhead dialog for player to: " + playerDialog.getText());
                }
                this.lastNpcDialog = null;
                if (this.npcDialogLogConfig.displayPlayerDialog()) {
                    this.addDialogMessage(playerDialog.getName(), playerDialog.getText());
                    log.debug("Added chat dialog: " + playerDialog.getName() + ": " + playerDialog.getText());
                }
            }
        }
    }

    private void setNpcOverheadDialog(Dialog npcDialog) {
        if (this.actorInteractedWith.getName() == null || !this.actorInteractedWith.getName().equals(npcDialog.getName())) {
            NPC foundActor = null;
            for (NPC npc : this.client.getNpcs()) {
                if (npc.getName() == null || !Text.sanitizeMultilineText((String)npc.getName()).equals(npcDialog.getName())) continue;
                foundActor = npc;
                break;
            }
            if (foundActor != null) {
                this.lastMessageTickTime.put((Actor)foundActor, this.client.getTickCount());
                foundActor.setOverheadText(npcDialog.getText());
                log.debug("Found matching actor: " + foundActor.getName() + " " + foundActor.getId());
                log.debug("Set overhead dialog for Npc: " + foundActor.getName() + " to: " + npcDialog.getText());
            } else {
                this.lastMessageTickTime.put(this.actorInteractedWith, this.client.getTickCount());
                this.actorInteractedWith.setOverheadText(npcDialog.getText());
                log.debug("Unable to find matching actor. Fallback to using interaction npc: " + this.actorInteractedWith.getName());
                log.debug("Set overhead dialog for Npc: " + this.actorInteractedWith.getName() + " to: " + npcDialog.getText());
            }
        } else {
            this.lastMessageTickTime.put(this.actorInteractedWith, this.client.getTickCount());
            this.actorInteractedWith.setOverheadText(npcDialog.getText());
            log.debug("Set overhead dialog for Npc: " + this.actorInteractedWith.getName() + " to: " + npcDialog.getText());
        }
    }

    private void addDialogMessage(String name, String message) {
        ChatMessageBuilder chatMessage = new ChatMessageBuilder().append(this.getPublicChatUsernameColor(), name).append(this.getPublicChatUsernameColor(), ": ").append(this.getPublicChatMessageColor(), message);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage.build()).build());
    }

    private Color getPublicChatUsernameColor() {
        Color usernameColor;
        boolean isChatboxTransparent;
        boolean bl = isChatboxTransparent = this.client.isResized() && this.client.getVar(4608) == 1;
        if (isChatboxTransparent) {
            usernameColor = Color.WHITE;
            if (this.chatColorConfig.transparentPlayerUsername() != null) {
                usernameColor = this.chatColorConfig.transparentPlayerUsername();
            }
        } else {
            usernameColor = Color.BLACK;
            if (this.chatColorConfig.opaquePlayerUsername() != null) {
                usernameColor = this.chatColorConfig.opaquePlayerUsername();
            }
        }
        return usernameColor;
    }

    private Color getPublicChatMessageColor() {
        Color messageColor;
        boolean isChatboxTransparent;
        boolean bl = isChatboxTransparent = this.client.isResized() && this.client.getVar(4608) == 1;
        if (isChatboxTransparent) {
            messageColor = JagexColors.CHAT_PUBLIC_TEXT_TRANSPARENT_BACKGROUND;
            if (this.chatColorConfig.transparentPublicChat() != null) {
                messageColor = this.chatColorConfig.transparentPublicChat();
            }
        } else {
            messageColor = JagexColors.CHAT_PUBLIC_TEXT_OPAQUE_BACKGROUND;
            if (this.chatColorConfig.opaquePublicChat() != null) {
                messageColor = this.chatColorConfig.opaquePublicChat();
            }
        }
        return messageColor;
    }

    private Dialog getWidgetDialogSafely() {
        return this.getWidgetDialogSafely(WidgetInfo.DIALOG_NPC_TEXT.getGroupId(), WidgetInfo.DIALOG_NPC_NAME.getChildId(), WidgetInfo.DIALOG_NPC_TEXT.getChildId());
    }

    private Dialog getWidgetDialogSafely(int group, int nameChild, int textChild) {
        return new Dialog(this.client.getWidget(group, nameChild) == null ? null : Text.sanitizeMultilineText((String)this.client.getWidget(group, nameChild).getText()), this.client.getWidget(group, textChild) == null ? null : Text.sanitizeMultilineText((String)this.client.getWidget(group, textChild).getText()));
    }

    @Provides
    NpcDialogLogConfig provideConfig(ConfigManager configManager) {
        return (NpcDialogLogConfig)configManager.getConfig(NpcDialogLogConfig.class);
    }

    protected void shutDown() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            for (Actor actor : this.lastMessageTickTime.keySet()) {
                actor.setOverheadText(null);
            }
        }
    }
}

