/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.playermodel;

import com.runeprofile.playermodel.JagexColor;
import com.runeprofile.playermodel.TextureColor;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import net.runelite.api.Model;

public class PlayerModelExporter {
    public static String export(Model model, String name) throws IOException {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int fi = 0; fi < model.getFaceCount(); ++fi) {
            Color vc3;
            Color vc2;
            Object vc1;
            int textureId = -1;
            if (model.getFaceTextures() != null) {
                textureId = model.getFaceTextures()[fi];
            }
            if (textureId != -1) {
                vc1 = TextureColor.getColor(textureId);
                vc2 = vc1;
                vc3 = vc1;
            } else {
                vc1 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors1()[fi], 0.9));
                vc2 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors2()[fi], 0.9));
                vc3 = new Color(JagexColor.HSLtoRGB((short)model.getFaceColors3()[fi], 0.9));
            }
            int vi1 = model.getFaceIndices1()[fi];
            int vi2 = model.getFaceIndices2()[fi];
            int vi3 = model.getFaceIndices3()[fi];
            int vx1 = model.getVerticesX()[vi1];
            int vx2 = model.getVerticesX()[vi2];
            int vx3 = model.getVerticesX()[vi3];
            int vy1 = -model.getVerticesY()[vi1];
            int vy2 = -model.getVerticesY()[vi2];
            int vy3 = -model.getVerticesY()[vi3];
            int vz1 = model.getVerticesZ()[vi1];
            int vz2 = model.getVerticesZ()[vi2];
            int vz3 = model.getVerticesZ()[vi3];
            vertices.add(new Vertex(vx1, vy1, vz1, ((Color)vc1).getRed(), ((Color)vc1).getGreen(), ((Color)vc1).getBlue()));
            vertices.add(new Vertex(vx2, vy2, vz2, vc2.getRed(), vc2.getGreen(), vc2.getBlue()));
            vertices.add(new Vertex(vx3, vy3, vz3, vc3.getRed(), vc3.getGreen(), vc3.getBlue()));
        }
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        w.write(PlayerModelExporter.newLine("ply"));
        w.write(PlayerModelExporter.newLine("format binary_little_endian 1.0"));
        w.write(PlayerModelExporter.newLine("element vertex " + vertices.size()));
        w.write(PlayerModelExporter.newLine("property int16 x"));
        w.write(PlayerModelExporter.newLine("property int16 y"));
        w.write(PlayerModelExporter.newLine("property int16 z"));
        w.write(PlayerModelExporter.newLine("property uint8 red"));
        w.write(PlayerModelExporter.newLine("property uint8 green"));
        w.write(PlayerModelExporter.newLine("property uint8 blue"));
        w.write(PlayerModelExporter.newLine("element face " + model.getFaceCount()));
        w.write(PlayerModelExporter.newLine("property list uint8 int16 vertex_indices"));
        w.write(PlayerModelExporter.newLine("end_header"));
        for (Vertex v : vertices) {
            w.write(PlayerModelExporter.le(v.x));
            w.write(PlayerModelExporter.le(v.z));
            w.write(PlayerModelExporter.le(v.y));
            w.write((byte)v.r);
            w.write((byte)v.g);
            w.write((byte)v.b);
        }
        for (int i = 0; i < model.getFaceCount(); ++i) {
            int vi = i * 3;
            w.write(3);
            w.write(PlayerModelExporter.le(vi));
            w.write(PlayerModelExporter.le(vi + 1));
            w.write(PlayerModelExporter.le(vi + 2));
        }
        return Base64.getEncoder().encodeToString(w.toByteArray());
    }

    private static byte[] newLine(String text) {
        return (text + System.lineSeparator()).getBytes();
    }

    private static byte[] le(int n) {
        byte[] b = new byte[]{(byte)n, (byte)(n >> 8)};
        return b;
    }

    private static class Vertex {
        public int x;
        public int y;
        public int z;
        public int r;
        public int g;
        public int b;

        public Vertex(int x, int y, int z, int r, int g, int b) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return this.x == vertex.x && this.y == vertex.y && this.z == vertex.z && this.r == vertex.r && this.g == vertex.g && this.b == vertex.b;
        }
    }
}

