/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels.settings;

import com.google.gson.JsonObject;
import com.runeprofile.RuneProfilePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateProfilePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(PrivateProfilePanel.class);
    private final AtomicReference<String> privateUrl = new AtomicReference();
    private final JLabel urlLabel = new JLabel();

    public PrivateProfilePanel(RuneProfilePlugin runeProfilePlugin) {
        this.setLayout(new BorderLayout());
        JPanel wrapper = new JPanel(new GridLayout(0, 1, 0, 4));
        EmptyBorder buttonBorder = new EmptyBorder(8, 16, 8, 16);
        String storedUrl = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "generated_path");
        this.privateUrl.set(storedUrl == null ? "None" : storedUrl);
        this.urlLabel.setText(this.getHiddenURL(this.privateUrl.get()));
        JLabel titleLabel = new JLabel("Private Profile URL");
        titleLabel.setFont(FontManager.getRunescapeBoldFont());
        titleLabel.setForeground(Color.WHITE);
        wrapper.add(titleLabel);
        String isPrivateString = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "is_private");
        System.out.println("isPrivateString: " + isPrivateString);
        boolean storedIsPrivate = Boolean.parseBoolean(isPrivateString);
        System.out.println("storedIsPrivate: " + storedIsPrivate);
        JCheckBox privateCheckbox = new JCheckBox("Private profile");
        privateCheckbox.setToolTipText("Disables the public username URL and generates a hidden URL instead.");
        privateCheckbox.setSelected(storedIsPrivate);
        privateCheckbox.addActionListener(event -> new Thread(() -> {
            SwingUtilities.invokeLater(() -> privateCheckbox.setEnabled(false));
            try {
                JsonObject response = runeProfilePlugin.updateIsPrivate(privateCheckbox.isSelected());
                privateCheckbox.setSelected(response.get("isPrivate").getAsBoolean());
                String path = response.get("generatedPath").getAsString();
                this.setNewURL(path);
            }
            catch (Exception e) {
                privateCheckbox.setSelected(!privateCheckbox.isSelected());
            }
            SwingUtilities.invokeLater(() -> privateCheckbox.setEnabled(true));
        }).start());
        wrapper.add(privateCheckbox);
        JPanel urlContainer = new JPanel();
        urlContainer.setLayout(new BorderLayout());
        urlContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        urlContainer.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.urlLabel.setFont(new Font("Courier New", 0, 11));
        urlContainer.add(this.urlLabel);
        wrapper.add(urlContainer);
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(e -> {
            StringSelection stringSelection = new StringSelection(this.privateUrl.get());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        });
        copyButton.setBorder(buttonBorder);
        wrapper.add(copyButton);
        JButton newButton = new JButton("Generate New URL");
        newButton.addActionListener(event -> new Thread(() -> {
            newButton.setEnabled(false);
            try {
                String path = runeProfilePlugin.updateGeneratedPath();
                this.setNewURL(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            newButton.setEnabled(true);
        }).start());
        newButton.setBorder(buttonBorder);
        wrapper.add(newButton);
        this.add((Component)wrapper, "North");
    }

    private void setNewURL(String path) {
        Object newUrl = path.equals("None") ? path : "runeprofile.com/" + path;
        this.privateUrl.set((String)newUrl);
        SwingUtilities.invokeLater(() -> this.urlLabel.setText(this.getHiddenURL(this.privateUrl.get())));
    }

    private String getHiddenURL(String url) {
        if (url.equals("None")) {
            return url;
        }
        try {
            int charactersToShow = 4;
            String[] path = url.split("/");
            String generatedPath = path[1];
            String firstCharacters = generatedPath.substring(0, charactersToShow);
            String stars = StringUtils.repeat((String)"*", (int)(generatedPath.length() - charactersToShow));
            String fullProfilePath = firstCharacters + stars;
            return path[0] + "/" + fullProfilePath;
        }
        catch (Exception e) {
            log.error("Error getting hidden URL", (Throwable)e);
            return "None";
        }
    }
}

