/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels.settings;

import com.runeprofile.RuneProfilePlugin;
import com.runeprofile.utils.DocumentSizeFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;

public class DescriptionPanel
extends JPanel {
    private static final int maxLength = 100;
    private final JLabel descriptionTitle = new JLabel("Description (0/100)");
    private final JTextArea descriptionEditor = new JTextArea(9, 0);

    public DescriptionPanel(RuneProfilePlugin runeProfilePlugin) {
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 4));
        this.descriptionTitle.setFont(FontManager.getRunescapeBoldFont());
        this.descriptionTitle.setForeground(Color.WHITE);
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.descriptionEditor.setTabSize(2);
        this.descriptionEditor.setSize(new Dimension(187, 200));
        this.descriptionEditor.setLineWrap(true);
        this.descriptionEditor.setWrapStyleWord(true);
        this.descriptionEditor.setOpaque(false);
        this.initText();
        this.initMaxLengthFilter();
        this.initDocumentListener();
        container.add(this.descriptionEditor);
        JButton updateButton = new JButton("Update Description");
        updateButton.setBorder(new EmptyBorder(8, 16, 8, 16));
        updateButton.addActionListener(event -> new Thread(() -> {
            SwingUtilities.invokeLater(() -> updateButton.setEnabled(false));
            try {
                String newDescription = runeProfilePlugin.updateDescription(this.descriptionEditor.getText());
                this.descriptionEditor.setText(newDescription);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SwingUtilities.invokeLater(() -> updateButton.setEnabled(true));
        }).start());
        this.add(this.descriptionTitle);
        this.add(container);
        this.add(updateButton);
    }

    private void initText() {
        String storedDescription = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "description");
        this.descriptionEditor.setText(storedDescription);
        this.updateDescriptionCount();
    }

    private void updateDescriptionCount() {
        this.descriptionTitle.setText("Description (" + this.descriptionEditor.getDocument().getLength() + "/100)");
    }

    private void initMaxLengthFilter() {
        AbstractDocument document = (AbstractDocument)this.descriptionEditor.getDocument();
        document.setDocumentFilter(new DocumentSizeFilter(100));
    }

    private void initDocumentListener() {
        this.descriptionEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DescriptionPanel.this.updateDescriptionCount();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DescriptionPanel.this.updateDescriptionCount();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DescriptionPanel.this.updateDescriptionCount();
            }
        });
    }
}

