/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels.misc;

import com.runeprofile.Icon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.SwingUtil;

public class HeaderPanel
extends JPanel {
    private static final int iconSize = 16;
    private final JPanel buttonsContainer;

    public HeaderPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel title = new JLabel("RuneProfile");
        title.setForeground(Color.WHITE);
        title.setFont(FontManager.getRunescapeBoldFont());
        this.buttonsContainer = new JPanel();
        this.buttonsContainer.setLayout(new GridLayout(1, 2, 4, 0));
        this.addHeaderButton(Icon.WEB.getIcon(16, 16), "Visit the website.", "https://runeprofile.com");
        this.addHeaderButton(Icon.GITHUB.getIcon(16, 16), "Report issues or contribute.", "https://github.com/ReinhardtR/runeprofile");
        this.add((Component)title, "West");
        this.add((Component)this.buttonsContainer, "East");
    }

    private void addHeaderButton(ImageIcon icon, String tooltip, String url) {
        final JButton button = new JButton();
        SwingUtil.removeButtonDecorations((AbstractButton)button);
        button.setIcon(icon);
        button.setToolTipText(tooltip);
        button.addActionListener(e -> LinkBrowser.browse((String)url));
        button.setUI(new BasicButtonUI());
        button.setBackground(ColorScheme.DARK_GRAY_COLOR);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.setBackground(ColorScheme.DARK_GRAY_COLOR);
            }
        });
        this.buttonsContainer.add(button);
    }
}

