/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels.home;

import com.runeprofile.RuneProfilePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomePanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(HomePanel.class);

    public HomePanel(RuneProfilePlugin runeProfilePlugin) {
        this.setLayout(new BorderLayout());
        JPanel wrapper = new JPanel(new GridLayout(0, 1, 0, 6));
        EmptyBorder buttonBorder = new EmptyBorder(8, 16, 8, 16);
        String updatedAccountDate = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "account_update_date");
        JLabel updatedAccountLabel = new JLabel((String)(updatedAccountDate != null ? "Last update: " + updatedAccountDate : "Last update: Never"));
        updatedAccountLabel.setFont(FontManager.getRunescapeSmallFont());
        wrapper.add(updatedAccountLabel);
        JButton updateProfileButton = new JButton("Update Profile");
        updateProfileButton.setBorder(buttonBorder);
        updateProfileButton.addActionListener(event -> new Thread(() -> {
            SwingUtilities.invokeLater(() -> updateProfileButton.setEnabled(false));
            String lastUpdated = "Failed";
            try {
                lastUpdated = runeProfilePlugin.updateProfile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String finalLastUpdated = lastUpdated;
            SwingUtilities.invokeLater(() -> {
                updatedAccountLabel.setText("Last update: " + finalLastUpdated);
                updateProfileButton.setEnabled(true);
            });
        }).start());
        wrapper.add(updateProfileButton);
        String updatedModelDate = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "model_update_date");
        JLabel updatedModelLabel = new JLabel((String)(updatedModelDate != null ? "Last update: " + updatedModelDate : "Last update: Never"));
        updatedModelLabel.setFont(FontManager.getRunescapeSmallFont());
        wrapper.add(updatedModelLabel);
        JButton updateModelButton = new JButton("Update Model");
        updateModelButton.setBorder(buttonBorder);
        updateModelButton.addActionListener(event -> new Thread(() -> {
            SwingUtilities.invokeLater(() -> updateModelButton.setEnabled(false));
            String lastUpdated = "Failed";
            try {
                lastUpdated = runeProfilePlugin.updateModel();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String finalLastUpdated = lastUpdated;
            SwingUtilities.invokeLater(() -> {
                updatedModelLabel.setText("Last update: " + finalLastUpdated);
                updateModelButton.setEnabled(true);
            });
        }).start());
        wrapper.add(updateModelButton);
        this.add((Component)wrapper, "North");
    }
}

