/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels.collectionlog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLogPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogPanel.class);
    private final JList<String> missingEntriesList;
    private final DefaultListModel<String> missingEntriesListModel = new DefaultListModel();

    public CollectionLogPanel() {
        this.setLayout(new BorderLayout());
        JTextArea infoText1 = this.createInfoText("To register your Collection Log, you need to open each entry.");
        JTextArea infoText2 = this.createInfoText("This list will show all missing entries for the currently selected tab.");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(2, 1, 0, 10));
        infoPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        infoPanel.add(infoText1);
        infoPanel.add(infoText2);
        this.add((Component)infoPanel, "North");
        this.missingEntriesList = new JList<String>(this.missingEntriesListModel);
        this.missingEntriesList.setLayout(new BorderLayout());
        this.missingEntriesList.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JScrollPane scrollPane = new JScrollPane(this.missingEntriesList);
        this.add((Component)scrollPane, "Center");
        this.loadNoMissingEntriesState();
    }

    private void loadNoMissingEntriesState() {
        SwingUtilities.invokeLater(() -> {
            this.missingEntriesListModel.removeAllElements();
            this.missingEntriesListModel.addElement("No missing entries");
            this.missingEntriesList.revalidate();
            this.missingEntriesList.repaint();
        });
    }

    public void newTabSelected(List<String> missingEntries) {
        log.info("New tab selected, missing entries: {}", missingEntries);
        SwingUtilities.invokeLater(() -> {
            if (missingEntries.size() == 0) {
                this.loadNoMissingEntriesState();
            } else {
                this.missingEntriesListModel.removeAllElements();
                for (String missingEntry : missingEntries) {
                    this.missingEntriesListModel.addElement(missingEntry);
                }
                this.missingEntriesList.revalidate();
                this.missingEntriesList.repaint();
            }
        });
    }

    public void newEntrySelected(String entry) {
        log.info("New entry selected: {}", (Object)entry);
        SwingUtilities.invokeLater(() -> {
            this.missingEntriesListModel.removeElement(entry);
            this.missingEntriesList.revalidate();
            this.missingEntriesList.repaint();
        });
    }

    private JTextArea createInfoText(String text) {
        JTextArea infoText = new JTextArea(text);
        infoText.setLineWrap(true);
        infoText.setWrapStyleWord(true);
        infoText.setEditable(false);
        infoText.setFocusable(false);
        return infoText;
    }
}

