/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.panels;

import com.runeprofile.Icon;
import com.runeprofile.RuneProfilePlugin;
import com.runeprofile.panels.collectionlog.CollectionLogPanel;
import com.runeprofile.panels.home.HomePanel;
import com.runeprofile.panels.settings.SettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;

public class MainPanel
extends JPanel {
    private static final int TAB_ICON_SIZE = 20;
    private final JPanel display = new JPanel();
    private final MaterialTabGroup tabGroup = new MaterialTabGroup(this.display);
    private final CollectionLogPanel collectionLogPanel;

    public MainPanel(RuneProfilePlugin runeProfilePlugin) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.display.setBorder(new EmptyBorder(10, 10, 8, 10));
        this.tabGroup.setLayout((LayoutManager)new GridLayout(0, 3, 8, 8));
        this.tabGroup.setBorder((Border)new EmptyBorder(10, 10, 6, 10));
        this.add((Component)this.tabGroup, "North");
        this.add((Component)this.display, "Center");
        MaterialTab home = this.addTab(Icon.HOME.getIcon(20, 20), "Home", new HomePanel(runeProfilePlugin));
        this.collectionLogPanel = new CollectionLogPanel();
        this.addTab(Icon.COLLECTION_LOG.getIcon(20, 20), "Collection Log", this.collectionLogPanel);
        this.addTab(Icon.SETTINGS.getIcon(20, 20), "Settings", new SettingsPanel(runeProfilePlugin));
        this.tabGroup.select(home);
    }

    private MaterialTab addTab(ImageIcon icon, String name, JPanel contentPanel) {
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)contentPanel, "Center");
        wrapped.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapped.setBorder(new EmptyBorder(0, 4, 0, 4));
        JScrollPane scroller = new JScrollPane(wrapped);
        scroller.setHorizontalScrollBarPolicy(31);
        scroller.getVerticalScrollBar().setPreferredSize(new Dimension(16, 0));
        scroller.getVerticalScrollBar().setBorder(new EmptyBorder(0, 9, 0, 0));
        scroller.setBackground(ColorScheme.DARK_GRAY_COLOR);
        MaterialTab materialTab = new MaterialTab(new ImageIcon(), this.tabGroup, (JComponent)scroller);
        materialTab.setPreferredSize(new Dimension(30, 27));
        materialTab.setName(name);
        materialTab.setToolTipText(name);
        materialTab.setIcon((javax.swing.Icon)icon);
        this.tabGroup.addTab(materialTab);
        return materialTab;
    }

    public CollectionLogPanel getCollectionLogPanel() {
        return this.collectionLogPanel;
    }
}

