/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.dataobjects;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.runeprofile.RuneProfilePlugin;
import com.runeprofile.achievementdiary.AchievementDiary;
import com.runeprofile.achievementdiary.AchievementDiaryState;
import com.runeprofile.collectionlog.CollectionLog;
import com.runeprofile.combatachievements.CombatAchievementTier;
import com.runeprofile.combatachievements.CombatAchievementTierState;
import com.runeprofile.leaderboards.Leaderboards;
import com.runeprofile.utils.AccountHash;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.vars.AccountType;
import net.runelite.client.hiscore.HiscoreResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerData {
    private static final Logger log = LoggerFactory.getLogger(PlayerData.class);
    private static final List<Skill> skillsOrder = ImmutableList.of((Object)Skill.ATTACK, (Object)Skill.HITPOINTS, (Object)Skill.MINING, (Object)Skill.STRENGTH, (Object)Skill.AGILITY, (Object)Skill.SMITHING, (Object)Skill.DEFENCE, (Object)Skill.HERBLORE, (Object)Skill.FISHING, (Object)Skill.RANGED, (Object)Skill.THIEVING, (Object)Skill.COOKING, (Object[])new Skill[]{Skill.PRAYER, Skill.CRAFTING, Skill.FIREMAKING, Skill.MAGIC, Skill.FLETCHING, Skill.WOODCUTTING, Skill.RUNECRAFT, Skill.SLAYER, Skill.FARMING, Skill.CONSTRUCTION, Skill.HUNTER});
    private final JsonObject json;

    public PlayerData() throws IllegalArgumentException, IOException, InterruptedException {
        AtomicReference accountHash = new AtomicReference();
        AtomicReference username = new AtomicReference();
        AtomicReference accountType = new AtomicReference();
        AtomicInteger combatLevel = new AtomicInteger();
        AtomicInteger questPoints = new AtomicInteger();
        LinkedHashMap<String, Integer> skills = new LinkedHashMap<String, Integer>();
        LinkedHashMap<AchievementDiary, AchievementDiaryState> achievementDiaries = new LinkedHashMap<AchievementDiary, AchievementDiaryState>();
        HashMap<Quest, QuestState> quests = new HashMap<Quest, QuestState>();
        HashMap<CombatAchievementTier, CombatAchievementTierState> combatAchievements = new HashMap<CombatAchievementTier, CombatAchievementTierState>();
        CountDownLatch latch = new CountDownLatch(1);
        RuneProfilePlugin.getClientThread().invokeLater(() -> {
            log.info("Getting client");
            Client client = RuneProfilePlugin.getClient();
            log.info("Getting player");
            Player player = client.getLocalPlayer();
            log.info("Getting misc data");
            accountHash.set(AccountHash.getHashed(client));
            username.set(player.getName());
            accountType.set(client.getAccountType());
            combatLevel.set(player.getCombatLevel());
            log.info("Getting skills");
            skillsOrder.forEach(skill -> skills.put(skill.getName(), client.getSkillExperience(skill)));
            log.info("Getting achievement diary data");
            for (AchievementDiary achievementDiary : AchievementDiary.values()) {
                achievementDiaries.put(achievementDiary, achievementDiary.getState(client));
            }
            log.info("Getting quest data");
            questPoints.set(client.getVarpValue(101));
            for (AchievementDiary achievementDiary : Quest.values()) {
                quests.put((Quest)achievementDiary, achievementDiary.getState(client));
            }
            log.info("Getting combat achievement data");
            for (Enum enum_ : CombatAchievementTier.values()) {
                combatAchievements.put((CombatAchievementTier)enum_, ((CombatAchievementTier)enum_).getState(client));
            }
            latch.countDown();
        });
        latch.await();
        this.json = new JsonObject();
        this.json.addProperty("accountHash", (String)accountHash.get());
        this.json.addProperty("username", (String)username.get());
        this.json.addProperty("accountType", ((AccountType)accountType.get()).toString());
        this.json.addProperty("combatLevel", (Number)combatLevel.get());
        this.json.addProperty("description", this.getDescription());
        this.json.add("skills", (JsonElement)this.createSkillsXPJSON(skills));
        this.json.add("collectionLog", (JsonElement)this.createCollectionLogJSON());
        this.json.add("achievementDiaries", (JsonElement)this.getAchievementDiariesJSON(achievementDiaries));
        this.json.add("combatAchievements", (JsonElement)this.getCombatAchievementsJSON(combatAchievements));
        this.json.add("questList", (JsonElement)this.getQuestsJSON(questPoints.get(), quests));
        this.json.add("hiscores", (JsonElement)this.getHiscoresJSON((String)username.get()));
    }

    private String getDescription() {
        String storedDescription = RuneProfilePlugin.getConfigManager().getRSProfileConfiguration("runeprofile", "description");
        if (storedDescription == null) {
            return "";
        }
        return storedDescription;
    }

    private JsonArray createSkillsXPJSON(Map<String, Integer> skills) {
        JsonArray skillsJSON = new JsonArray();
        int index = 0;
        for (Map.Entry<String, Integer> skill : skills.entrySet()) {
            JsonObject skillJSON = new JsonObject();
            skillJSON.addProperty("index", (Number)index);
            skillJSON.addProperty("name", skill.getKey());
            skillJSON.addProperty("xp", (Number)skill.getValue());
            skillsJSON.add((JsonElement)skillJSON);
            ++index;
        }
        return skillsJSON;
    }

    private JsonObject createCollectionLogJSON() {
        CollectionLog collectionLog = RuneProfilePlugin.getCollectionLogManager().getCollectionLog();
        Gson gson = RuneProfilePlugin.getGson();
        String jsonString = gson.toJson((Object)collectionLog);
        return (JsonObject)gson.fromJson(jsonString, JsonObject.class);
    }

    private JsonArray getAchievementDiariesJSON(Map<AchievementDiary, AchievementDiaryState> achievementDiaries) {
        JsonArray diaries = new JsonArray();
        for (Map.Entry<AchievementDiary, AchievementDiaryState> entry : achievementDiaries.entrySet()) {
            AchievementDiary ad = entry.getKey();
            AchievementDiaryState adState = entry.getValue();
            JsonObject areaJson = new JsonObject();
            areaJson.addProperty("area", ad.getName());
            ImmutableList.of((Object)adState.getEasyTier(), (Object)adState.getMediumTier(), (Object)adState.getHardTier(), (Object)adState.getEliteTier()).forEach(tier -> {
                JsonObject tierJSON = new JsonObject();
                tierJSON.addProperty("completed", (Number)tier.getCompletedTasks());
                tierJSON.addProperty("total", (Number)tier.getTotalTasks());
                areaJson.add(tier.getTier().getName(), (JsonElement)tierJSON);
            });
            diaries.add((JsonElement)areaJson);
        }
        return diaries;
    }

    private JsonObject getQuestsJSON(int questPoints, Map<Quest, QuestState> quests) {
        JsonObject json = new JsonObject();
        json.addProperty("points", (Number)questPoints);
        JsonArray questsArray = new JsonArray();
        for (Map.Entry<Quest, QuestState> entry : quests.entrySet()) {
            Quest quest = entry.getKey();
            QuestState questState = entry.getValue();
            JsonObject questJSON = new JsonObject();
            questJSON.addProperty("name", quest.getName());
            questJSON.addProperty("state", questState.name());
            questsArray.add((JsonElement)questJSON);
        }
        json.add("quests", (JsonElement)questsArray);
        return json;
    }

    private JsonObject getCombatAchievementsJSON(Map<CombatAchievementTier, CombatAchievementTierState> combatAchievements) {
        JsonObject json = new JsonObject();
        for (Map.Entry<CombatAchievementTier, CombatAchievementTierState> entry : combatAchievements.entrySet()) {
            CombatAchievementTier caTier = entry.getKey();
            CombatAchievementTierState caState = entry.getValue();
            JsonObject caJSON = new JsonObject();
            caJSON.addProperty("completed", (Number)caState.getCompletedTasks());
            caJSON.addProperty("total", (Number)caState.getTotalTasks());
            String tierKey = caTier.getName();
            json.add(tierKey, (JsonElement)caJSON);
        }
        return json;
    }

    private JsonObject getHiscoresJSON(String username) {
        JsonObject hiscores = new JsonObject();
        for (Leaderboards leaderboard : Leaderboards.values()) {
            JsonArray skills = new JsonArray();
            JsonArray activities = new JsonArray();
            JsonArray bosses = new JsonArray();
            HiscoreResult result = null;
            try {
                result = RuneProfilePlugin.getHiscoreClient().lookup(username, leaderboard.getEndpoint());
            }
            catch (IOException e) {
                log.error("Error looking up hiscores", (Throwable)e);
            }
            if (result == null) {
                JsonObject entry = new JsonObject();
                entry.add("skills", (JsonElement)skills);
                entry.add("activities", (JsonElement)activities);
                entry.add("bosses", (JsonElement)bosses);
                hiscores.add(leaderboard.name().toLowerCase(), (JsonElement)entry);
                continue;
            }
            AtomicInteger index = new AtomicInteger();
            result.getSkills().forEach((hiscore, data) -> {
                JsonObject entryItem = new JsonObject();
                entryItem.addProperty("index", (Number)index.get());
                entryItem.addProperty("name", hiscore.getName());
                entryItem.addProperty("rank", (Number)data.getRank());
                switch (hiscore.getType()) {
                    case OVERALL: 
                    case SKILL: {
                        entryItem.addProperty("level", (Number)data.getLevel());
                        entryItem.addProperty("xp", (Number)data.getExperience());
                        skills.add((JsonElement)entryItem);
                        break;
                    }
                    case ACTIVITY: {
                        entryItem.addProperty("score", (Number)data.getLevel());
                        activities.add((JsonElement)entryItem);
                        break;
                    }
                    case BOSS: {
                        entryItem.addProperty("kills", (Number)data.getLevel());
                        bosses.add((JsonElement)entryItem);
                        break;
                    }
                }
                index.getAndIncrement();
            });
            JsonObject entry = new JsonObject();
            entry.add("skills", (JsonElement)skills);
            entry.add("activities", (JsonElement)activities);
            entry.add("bosses", (JsonElement)bosses);
            hiscores.add(leaderboard.name().toLowerCase(), (JsonElement)entry);
        }
        return hiscores;
    }

    public JsonObject getJson() {
        return this.json;
    }
}

