/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.collectionlog;

import com.google.gson.Gson;
import com.runeprofile.RuneProfilePlugin;
import com.runeprofile.collectionlog.CollectionLog;
import com.runeprofile.collectionlog.CollectionLogEntry;
import com.runeprofile.collectionlog.CollectionLogItem;
import com.runeprofile.collectionlog.CollectionLogKillCount;
import com.runeprofile.collectionlog.CollectionLogTabs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLogManager {
    private static final Logger log = LoggerFactory.getLogger(CollectionLogManager.class);
    private static final int TAB_ACTIVE_COLOR = 16754735;
    private static final int TAB_TEXT_INDEX = 3;
    private final Client client;
    private final ClientThread clientThread;
    private final ConfigManager configManager;
    private final Gson gson;
    private String previousTab = null;
    private CollectionLog collectionLog;

    public CollectionLogManager(Gson gson) {
        this.gson = gson;
        this.client = RuneProfilePlugin.getClient();
        this.configManager = RuneProfilePlugin.getConfigManager();
        this.clientThread = RuneProfilePlugin.getClientThread();
        this.reloadManager();
    }

    public void reloadManager() {
        this.collectionLog = this.getStoredCollectionLog();
    }

    private CollectionLog getStoredCollectionLog() {
        String collectionLogString = this.configManager.getRSProfileConfiguration("runeprofile", "collection_log");
        if (collectionLogString == null) {
            return new CollectionLog();
        }
        try {
            return (CollectionLog)this.gson.fromJson(collectionLogString, CollectionLog.class);
        }
        catch (Exception e) {
            log.error("Error parsing collection log", (Throwable)e);
            return new CollectionLog();
        }
    }

    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 2730) {
            log.info("COLLECTION DRAW LIST FIRED");
            if (RuneProfilePlugin.getClient().getWidget(WidgetInfo.ADVENTURE_LOG) != null) {
                log.info("Adventure Log isn't supported");
                return;
            }
            this.clientThread.invokeLater(this::updateCollectionLog);
            this.updateCollectionLogPanel();
        }
    }

    private void updateCollectionLogPanel() {
        Map<String, CollectionLogEntry> storedTab;
        String tabName = this.getTabName();
        if (tabName == null) {
            return;
        }
        if (tabName.equals(this.previousTab)) {
            RuneProfilePlugin.getPanel().getMainPanel().getCollectionLogPanel().newEntrySelected(this.getEntryName());
            return;
        }
        this.previousTab = tabName;
        ArrayList<String> entriesInTab = new ArrayList<String>();
        Widget[] entryWidgets = this.getEntriesInTab();
        if (entryWidgets != null) {
            for (Widget entryWidget : entryWidgets) {
                entriesInTab.add(entryWidget.getText());
            }
        }
        if ((storedTab = this.collectionLog.getTab(tabName)) == null) {
            return;
        }
        Set<String> storedInLog = storedTab.keySet();
        ArrayList<String> missingEntries = new ArrayList<String>(entriesInTab);
        missingEntries.removeAll(storedInLog);
        missingEntries.remove(this.getEntryName());
        RuneProfilePlugin.getPanel().getMainPanel().getCollectionLogPanel().newTabSelected(missingEntries);
    }

    private Widget[] getEntriesInTab() {
        String entryName = this.getEntryName();
        if (entryName == null) {
            return null;
        }
        CollectionLogTabs tab = CollectionLogTabs.getByName(this.getTabName());
        if (tab == null) {
            return null;
        }
        Widget entryList = this.client.getWidget(621, tab.getEntryListId());
        if (entryList == null) {
            return null;
        }
        return entryList.getDynamicChildren();
    }

    public CollectionLogEntry getEntry() {
        String name = this.getEntryName();
        if (name == null) {
            return null;
        }
        int index = this.getEntryIndex();
        CollectionLogItem[] items = this.getItems().toArray(new CollectionLogItem[0]);
        CollectionLogKillCount[] killCounts = this.getKillCounts().toArray(new CollectionLogKillCount[0]);
        return new CollectionLogEntry(index, items, (CollectionLogKillCount[])(killCounts.length > 0 ? killCounts : null));
    }

    public void updateCollectionLog() {
        CollectionLogEntry collectionLogEntry = this.getEntry();
        if (collectionLogEntry == null) {
            log.error("Failed to get entry");
            return;
        }
        String tabTitle = this.getTabName();
        String entryName = this.getEntryName();
        this.collectionLog.getTab(tabTitle).put(entryName, collectionLogEntry);
        int uniqueItemsObtained = this.client.getVarpValue(2943);
        this.collectionLog.setUniqueItemsObtained(uniqueItemsObtained);
        int uniqueItemsTotal = this.client.getVarpValue(2944);
        this.collectionLog.setUniqueItemsTotal(uniqueItemsTotal);
        this.configManager.setRSProfileConfiguration("runeprofile", "collection_log", (Object)this.gson.toJson((Object)this.collectionLog));
        log.info("Updated the Collection Log");
    }

    private Widget getEntryHead() {
        return this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_HEADER);
    }

    private int getEntryIndex() {
        Widget[] entries = this.getEntriesInTab();
        int index = -1;
        if (entries == null) {
            log.error("Failed to get entry index");
            return index;
        }
        String entryName = this.getEntryName();
        for (int i = 0; i < entries.length; ++i) {
            String entryText = entries[i].getText();
            if (!entryText.equals(entryName)) continue;
            index = i;
            break;
        }
        log.info("ENTRY INDEX: " + index);
        return index;
    }

    private String getEntryName() {
        Widget entryHead = this.getEntryHead();
        if (entryHead == null) {
            return null;
        }
        Widget[] children = entryHead.getDynamicChildren();
        if (children == null || children.length == 0) {
            log.error("Failed to get entry name");
            return null;
        }
        return children[0].getText();
    }

    private String getTabName() {
        for (CollectionLogTabs tab : CollectionLogTabs.values()) {
            Widget[] children;
            Widget tabWidget = this.client.getWidget(621, tab.getId());
            if (tabWidget == null || (children = tabWidget.getDynamicChildren()) == null || 3 >= children.length) continue;
            Widget titleWidget = children[3];
            String title = titleWidget.getText();
            int color = titleWidget.getTextColor();
            if (color != 16754735) continue;
            return title;
        }
        log.error("Failed to get tab name");
        return null;
    }

    private List<CollectionLogItem> getItems() {
        Widget[] itemWidgets;
        ArrayList<CollectionLogItem> items = new ArrayList<CollectionLogItem>();
        Widget itemsContainer = this.client.getWidget(WidgetInfo.COLLECTION_LOG_ENTRY_ITEMS);
        if (itemsContainer == null) {
            return items;
        }
        for (Widget itemWidget : itemWidgets = itemsContainer.getDynamicChildren()) {
            int index = itemWidget.getIndex();
            int id = itemWidget.getItemId();
            String name = this.unwrapText(itemWidget.getName());
            int quantity = itemWidget.getOpacity() == 0 ? itemWidget.getItemQuantity() : 0;
            items.add(new CollectionLogItem(index, id, name, quantity));
        }
        return items;
    }

    private List<CollectionLogKillCount> getKillCounts() {
        ArrayList<CollectionLogKillCount> killCounts = new ArrayList<CollectionLogKillCount>();
        Widget entryHead = this.getEntryHead();
        if (entryHead == null) {
            return killCounts;
        }
        Widget[] children = entryHead.getDynamicChildren();
        if (children == null || children.length < 3) {
            return killCounts;
        }
        for (int childIndex = 2; childIndex < children.length; ++childIndex) {
            String rawKillCount = children[childIndex].getText();
            String[] killCountParts = rawKillCount.split(": ");
            if (killCountParts.length <= 1) continue;
            String killCountName = killCountParts[0];
            int killCountAmount = Integer.parseInt(this.unwrapText(killCountParts[1]));
            killCounts.add(new CollectionLogKillCount(childIndex - 2, killCountName, killCountAmount));
        }
        return killCounts;
    }

    private String unwrapText(String text) {
        return text.split(">")[1].split("<")[0].replace(",", "");
    }

    public CollectionLog getCollectionLog() {
        return this.collectionLog;
    }
}

