/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile.achievementdiary;

import com.runeprofile.achievementdiary.AchievementDiaryState;
import com.runeprofile.achievementdiary.AchievementDiaryTier;
import com.runeprofile.achievementdiary.AchievementDiaryTierState;
import net.runelite.api.Client;

public enum AchievementDiary {
    ARDOUGNE(1, "Ardougne"),
    DESERT(5, "Desert"),
    FALADOR(2, "Falador"),
    FREMENNIK(3, "Fremennik"),
    KANDARIN(4, "Kandarin"),
    KARAMJA(0, "Karamja"),
    KOUREND(11, "Kourend & Kebos"),
    LUMBRIDGE(6, "Lumbridge & Draynor"),
    MORYTANIA(7, "Morytania"),
    VARROCK(8, "Varrock"),
    WESTERN_PROVINCES(10, "Western Provinces"),
    WILDERNESS(9, "Wilderness");

    private final int id;
    private final String name;

    public AchievementDiaryState getState(Client client) {
        client.runScript(new Object[]{2200, this.id});
        int[] stack = client.getIntStack();
        AchievementDiaryTierState easyTierState = new AchievementDiaryTierState(AchievementDiaryTier.EASY, stack[0], stack[1]);
        AchievementDiaryTierState mediumTierState = new AchievementDiaryTierState(AchievementDiaryTier.MEDIUM, stack[3], stack[4]);
        AchievementDiaryTierState hardTierState = new AchievementDiaryTierState(AchievementDiaryTier.HARD, stack[6], stack[7]);
        AchievementDiaryTierState eliteTierState = new AchievementDiaryTierState(AchievementDiaryTier.ELITE, stack[9], stack[10]);
        return new AchievementDiaryState(this.name, easyTierState, mediumTierState, hardTierState, eliteTierState);
    }

    private AchievementDiary(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

