/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.runeprofile.Icon;
import com.runeprofile.RuneProfileApiClient;
import com.runeprofile.RuneProfileConfig;
import com.runeprofile.RuneProfilePanel;
import com.runeprofile.collectionlog.CollectionLogManager;
import com.runeprofile.dataobjects.PlayerData;
import com.runeprofile.dataobjects.PlayerModelData;
import com.runeprofile.utils.AccountHash;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.externalplugins.ExternalPluginManager;
import net.runelite.client.hiscore.HiscoreClient;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="RuneProfile", description="Show off your achievements on RuneProfile.com", tags={"rune", "profile"})
public class RuneProfilePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RuneProfilePlugin.class);
    private static RuneProfilePlugin instance;
    @Inject
    private Client client;
    @Inject
    private RuneProfileConfig config;
    @Inject
    private RuneProfileApiClient runeProfileApiClient;
    @Inject
    private ExternalPluginManager externalPluginManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HiscoreClient hiscoreClient;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    private RuneProfilePanel runeProfilePanel;
    private NavigationButton navigationButton;
    private CollectionLogManager collectionLogManager;

    public static CollectionLogManager getCollectionLogManager() {
        return RuneProfilePlugin.instance.collectionLogManager;
    }

    public static Client getClient() {
        return RuneProfilePlugin.instance.client;
    }

    public static ClientThread getClientThread() {
        return RuneProfilePlugin.instance.clientThread;
    }

    public static HiscoreClient getHiscoreClient() {
        return RuneProfilePlugin.instance.hiscoreClient;
    }

    public static ConfigManager getConfigManager() {
        return RuneProfilePlugin.instance.configManager;
    }

    public static Gson getGson() {
        return RuneProfilePlugin.instance.gson;
    }

    public static RuneProfilePanel getPanel() {
        return RuneProfilePlugin.instance.runeProfilePanel;
    }

    @Provides
    RuneProfileConfig provideConfig(ConfigManager configManager) {
        return (RuneProfileConfig)configManager.getConfig(RuneProfileConfig.class);
    }

    protected void startUp() {
        instance = this;
        this.runeProfilePanel = new RuneProfilePanel(this);
        BufferedImage toolbarIcon = Icon.LOGO.getImage();
        this.navigationButton = NavigationButton.builder().tooltip("RuneProfile").icon(toolbarIcon).panel((PluginPanel)this.runeProfilePanel).priority(1).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navigationButton);
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged state) {
        if (state.getGameState() == GameState.LOGGED_IN) {
            if (!this.isValidWorldType(this.client.getWorldType())) {
                this.runeProfilePanel.loadInvalidRequestState();
                return;
            }
            if (this.collectionLogManager == null) {
                this.collectionLogManager = new CollectionLogManager(this.gson);
            } else {
                this.collectionLogManager.reloadManager();
            }
            this.runeProfilePanel.loadValidState();
        } else if (state.getGameState() == GameState.LOGIN_SCREEN) {
            this.runeProfilePanel.loadInvalidState();
            if (this.config.updateOnLogout() && this.collectionLogManager != null && this.client.getLocalPlayer() != null) {
                new Thread(() -> {
                    try {
                        this.updateProfile();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }).start();
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (this.collectionLogManager != null) {
            this.collectionLogManager.onScriptPostFired(scriptPostFired);
        }
    }

    public String updateProfile() throws IllegalStateException, InterruptedException {
        String updateDateString;
        this.isValidRequest();
        try {
            PlayerData playerData = new PlayerData();
            updateDateString = this.runeProfileApiClient.updateProfile(playerData);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.info("NEW DATE STRING: " + updateDateString);
        this.configManager.setRSProfileConfiguration("runeprofile", "account_update_date", (Object)updateDateString);
        return updateDateString;
    }

    public String updateModel() throws IllegalStateException, InterruptedException {
        String updateDatetimeString;
        this.isValidRequest();
        AtomicReference playerModelData = new AtomicReference();
        CountDownLatch clientLatch = new CountDownLatch(1);
        this.clientThread.invokeLater(() -> {
            try {
                playerModelData.set(new PlayerModelData(this.client));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                clientLatch.countDown();
            }
        });
        clientLatch.await();
        try {
            updateDatetimeString = this.runeProfileApiClient.updateModel((PlayerModelData)playerModelData.get());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        this.configManager.setRSProfileConfiguration("runeprofile", "model_update_date", (Object)updateDatetimeString);
        return updateDatetimeString;
    }

    public String updateGeneratedPath() throws Exception {
        String newUrl;
        this.isValidRequest();
        AtomicReference accountHash = new AtomicReference();
        CountDownLatch clientLatch = new CountDownLatch(1);
        this.clientThread.invokeLater(() -> {
            accountHash.set(AccountHash.getHashed(this.client));
            clientLatch.countDown();
        });
        clientLatch.await();
        try {
            newUrl = this.runeProfileApiClient.updateGeneratedPath((String)accountHash.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (newUrl == null) {
            throw new Exception("Failed to update generated path");
        }
        this.configManager.setRSProfileConfiguration("runeprofile", "generated_path", (Object)newUrl);
        return newUrl;
    }

    public JsonObject updateIsPrivate(boolean isPrivate) throws Exception {
        JsonObject response;
        this.isValidRequest();
        AtomicReference accountHash = new AtomicReference();
        CountDownLatch clientLatch = new CountDownLatch(1);
        this.clientThread.invokeLater(() -> {
            accountHash.set(AccountHash.getHashed(this.client));
            clientLatch.countDown();
        });
        clientLatch.await();
        try {
            response = this.runeProfileApiClient.updateIsPrivate((String)accountHash.get(), isPrivate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("RESPONSE: " + response.get("isPrivate").getAsString());
        log.info("RESPONSE: " + response.get("isPrivate").toString());
        this.configManager.setRSProfileConfiguration("runeprofile", "is_private", (Object)response.get("isPrivate"));
        this.configManager.setRSProfileConfiguration("runeprofile", "generated_path", (Object)response.get("generatedPath"));
        return response;
    }

    public String updateDescription(String description) throws Exception {
        String newDescription;
        this.isValidRequest();
        AtomicReference accountHash = new AtomicReference();
        CountDownLatch clientLatch = new CountDownLatch(1);
        this.clientThread.invokeLater(() -> {
            accountHash.set(AccountHash.getHashed(this.client));
            clientLatch.countDown();
        });
        clientLatch.await();
        try {
            newDescription = this.runeProfileApiClient.updateDescription((String)accountHash.get(), description);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (newDescription == null) {
            throw new RuntimeException("Failed to update description");
        }
        this.configManager.setRSProfileConfiguration("runeprofile", "description", (Object)newDescription);
        return newDescription;
    }

    public void deleteProfile() {
        this.isValidRequest();
        if (!this.isConfirmedDeletion("Are you sure you want to delete your RuneProfile?")) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            String accountHash = AccountHash.getHashed(this.client);
            new Thread(() -> this.runeProfileApiClient.deleteProfile(accountHash)).start();
        });
        this.runeProfilePanel.loadInvalidState();
        this.configManager.unsetRSProfileConfiguration("runeprofile", "collection_log");
        this.configManager.unsetRSProfileConfiguration("runeprofile", "generated_path");
        this.configManager.unsetRSProfileConfiguration("runeprofile", "description");
        this.configManager.unsetRSProfileConfiguration("runeprofile", "is_private");
        this.configManager.unsetRSProfileConfiguration("runeprofile", "has_model");
        this.collectionLogManager.reloadManager();
        this.runeProfilePanel.loadValidState();
    }

    private boolean isConfirmedDeletion(String message) {
        int confirm = JOptionPane.showConfirmDialog((Component)((Object)this.runeProfilePanel), message, "RuneProfile", 2);
        return confirm == 0;
    }

    private void isValidRequest() throws IllegalStateException {
        if (!this.isValidWorldType(this.client.getWorldType())) {
            throw new IllegalStateException("Not on a valid world type");
        }
        long accountHash = this.client.getAccountHash();
        if (accountHash == -1L) {
            throw new IllegalStateException("Failed to get AccountHash");
        }
        Player player = this.client.getLocalPlayer();
        if (player == null || player.getName() == null) {
            throw new IllegalStateException("Failed to get Player");
        }
    }

    private boolean isValidWorldType(EnumSet<WorldType> worldTypes) {
        return ImmutableList.of((Object)WorldType.DEADMAN, (Object)WorldType.NOSAVE_MODE, (Object)WorldType.SEASONAL, (Object)WorldType.TOURNAMENT_WORLD).stream().noneMatch(worldTypes::contains);
    }
}

