/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile;

import com.runeprofile.RuneProfilePlugin;
import com.runeprofile.panels.InvalidPanel;
import com.runeprofile.panels.MainPanel;
import com.runeprofile.panels.misc.HeaderPanel;
import java.awt.BorderLayout;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneProfilePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(RuneProfilePanel.class);
    private final RuneProfilePlugin runeProfilePlugin;
    private MainPanel mainPanel;
    private InvalidPanel invalidPanel;

    public RuneProfilePanel(RuneProfilePlugin runeProfilePlugin) {
        super(false);
        this.setLayout(new BorderLayout());
        this.runeProfilePlugin = runeProfilePlugin;
        this.add(new HeaderPanel(), "North");
        this.loadInvalidState();
    }

    public void loadValidState() {
        SwingUtilities.invokeLater(() -> {
            if (this.invalidPanel != null) {
                this.remove(this.invalidPanel);
            }
            this.mainPanel = new MainPanel(this.runeProfilePlugin);
            this.add(this.mainPanel, "Center");
            this.revalidate();
            this.repaint();
        });
    }

    public void loadInvalidState() {
        SwingUtilities.invokeLater(() -> {
            if (this.mainPanel != null) {
                this.remove(this.mainPanel);
            }
            if (this.invalidPanel == null) {
                this.invalidPanel = new InvalidPanel();
            }
            this.invalidPanel.setHintText("Login to use this plugin.");
            this.add(this.invalidPanel, "Center");
            this.revalidate();
            this.repaint();
        });
    }

    public void loadInvalidRequestState() {
        SwingUtilities.invokeLater(() -> {
            if (this.mainPanel != null) {
                this.remove(this.mainPanel);
            }
            if (this.invalidPanel == null) {
                this.invalidPanel = new InvalidPanel();
            }
            this.invalidPanel.setHintText("Invalid world/mode.");
            this.add(this.invalidPanel, "Center");
            this.revalidate();
            this.repaint();
        });
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }
}

