/*
 * Decompiled with CFR 0.152.
 */
package com.runeprofile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.runeprofile.dataobjects.PlayerData;
import com.runeprofile.dataobjects.PlayerModelData;
import com.runeprofile.utils.DateHeader;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuneProfileApiClient {
    private static final Logger log = LoggerFactory.getLogger(RuneProfileApiClient.class);
    private static final MediaType JSON_MEDIA_TYPE = Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8"));
    private final boolean isDevMode = false;
    @Inject
    private OkHttpClient okHttpClient;

    private HttpUrl.Builder getBaseUrl() {
        return new HttpUrl.Builder().scheme("https").host("www.runeprofile.com");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateProfile(PlayerData playerData) {
        HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)playerData.getJson().toString());
        Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").put(body).build();
        OkHttpClient extendedTimeoutClient = this.okHttpClient.newBuilder().readTimeout(30L, TimeUnit.SECONDS).build();
        try (Response response = extendedTimeoutClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String string2 = "Failed";
                return string2;
            }
            String date = response.header("Date");
            response.close();
            String string = DateHeader.getDateString(date);
            return string;
        }
        catch (IOException e) {
            log.error("Request call to RuneProfile API failed.");
            return "Failed";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateModel(PlayerModelData playerModelData) {
        HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").addPathSegment("model").build();
        RequestBody body = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)playerModelData.getJson().toString());
        Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").put(body).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String string2 = "Failed";
                return string2;
            }
            String date = response.header("Date");
            response.close();
            String string = DateHeader.getDateString(date);
            return string;
        }
        catch (IOException e) {
            log.error("Request call to RuneProfile API failed.");
            return "Failed";
        }
    }

    public String updateGeneratedPath(String accountHash) throws Exception {
        String string;
        block8: {
            HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").addPathSegment("generated-path").build();
            JsonObject jsonRequestBody = new JsonObject();
            jsonRequestBody.addProperty("accountHash", accountHash);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonRequestBody.toString());
            Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").put(requestBody).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                JsonObject responseBody = new JsonParser().parse(Objects.requireNonNull(response.body()).string()).getAsJsonObject();
                response.close();
                string = responseBody.get("generatedPath").getAsString();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Exception("Request call to RuneProfile API failed.");
                }
            }
            response.close();
        }
        return string;
    }

    public String updateDescription(String accountHash, String description) throws Exception {
        String string;
        block8: {
            HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").addPathSegment("description").build();
            JsonObject jsonRequestBody = new JsonObject();
            jsonRequestBody.addProperty("accountHash", accountHash);
            jsonRequestBody.addProperty("description", description);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonRequestBody.toString());
            Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").put(requestBody).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                JsonObject responseBody = new JsonParser().parse(Objects.requireNonNull(response.body()).string()).getAsJsonObject();
                response.close();
                string = responseBody.get("description").getAsString();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Exception("Request call to RuneProfile API failed.");
                }
            }
            response.close();
        }
        return string;
    }

    public JsonObject updateIsPrivate(String accountHash, boolean isPrivate) throws Exception {
        JsonObject jsonObject;
        block8: {
            HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").addPathSegment("private").build();
            JsonObject jsonBody = new JsonObject();
            jsonBody.addProperty("accountHash", accountHash);
            jsonBody.addProperty("isPrivate", Boolean.valueOf(isPrivate));
            RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonBody.toString());
            Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").put(requestBody).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                JsonObject responseBody = new JsonParser().parse(Objects.requireNonNull(response.body()).string()).getAsJsonObject();
                response.close();
                log.info("Body: " + responseBody);
                jsonObject = responseBody;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Exception("Request call to RuneProfile API failed.");
                }
            }
            response.close();
        }
        return jsonObject;
    }

    public void deleteProfile(String accountHash) {
        HttpUrl url = this.getBaseUrl().addPathSegment("api").addPathSegment("profile").build();
        JsonObject requestBodyJson = new JsonObject();
        requestBodyJson.addProperty("accountHash", accountHash);
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)requestBodyJson.toString());
        Request request = new Request.Builder().url(url).header("Content-Type", "application/json").header("User-Agent", "RuneLite").delete(requestBody).build();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            response.close();
        }
        catch (IOException e) {
            log.error("Request call to RuneProfile API failed.");
        }
    }
}

