/*
 * Decompiled with CFR 0.152.
 */
package com.tobdropchance;

import com.google.inject.Provides;
import com.tobdropchance.TobDropChanceConfig;
import com.tobdropchance.TobDropChanceConstant;
import com.tobdropchance.TobDropChanceOverlay;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Drop Chance", description="Displays estimated team and personal drop chance information at ToB")
public class TobDropChancePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobDropChancePlugin.class);
    @Inject
    private Client client;
    @Inject
    private TobDropChanceConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TobDropChanceOverlay overlay;
    boolean inRaid;
    int raidState;
    Map<String, Integer> deathCounter;
    boolean loadedPlayers;

    @Provides
    TobDropChanceConfig provideConfig(ConfigManager configManager) {
        return (TobDropChanceConfig)configManager.getConfig(TobDropChanceConfig.class);
    }

    protected void startUp() {
        this.deathCounter = new HashMap<String, Integer>();
        this.reset();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void reset() {
        this.inRaid = false;
        this.raidState = 0;
        this.loadedPlayers = false;
        this.deathCounter.clear();
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getSender() == null) {
            Matcher other;
            String msg = Text.sanitize((String)Text.removeTags((String)event.getMessage()));
            if (msg == null) {
                return;
            }
            String target = null;
            Matcher self = TobDropChanceConstant.DEATH_SELF.matcher(msg);
            if (self.matches()) {
                target = Text.sanitize((String)this.client.getLocalPlayer().getName());
            }
            if ((other = TobDropChanceConstant.DEATH_OTHER.matcher(msg)).matches()) {
                target = other.group(1);
            }
            if (target != null && this.deathCounter.containsKey(target)) {
                int count = this.deathCounter.get(target);
                this.deathCounter.put(target, count + 1);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.inRaid && !this.loadedPlayers) {
            this.deathCounter.clear();
            Map varcmap = this.client.getVarcMap();
            for (int i = 0; i < 5; ++i) {
                String tName;
                Integer playervarp = 330 + i;
                if (!varcmap.containsKey(playervarp) || (tName = Text.sanitize((String)varcmap.get(playervarp).toString())) == null || tName.equals("")) continue;
                this.deathCounter.put(tName, 0);
            }
            this.loadedPlayers = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int nextState = this.client.getVar(6440);
        if (this.raidState != nextState) {
            if (nextState == 0 || nextState == 1) {
                this.reset();
                this.raidState = nextState;
            } else {
                if (this.raidState == 1) {
                    this.reset();
                    this.inRaid = true;
                }
                this.raidState = nextState;
            }
        }
    }

    public Map<String, Integer> getDeathCounter() {
        return this.deathCounter;
    }
}

