/*
 * Decompiled with CFR 0.152.
 */
package com.tobdropchance;

import com.tobdropchance.TobDropChanceConfig;
import com.tobdropchance.TobDropChancePlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.util.Text;

public class TobDropChanceOverlay
extends OverlayPanel {
    private Client client;
    private TobDropChancePlugin plugin;
    private TobDropChanceConfig config;

    @Inject
    private TobDropChanceOverlay(TobDropChancePlugin plugin, Client client, TobDropChanceConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Theatre Points Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        Player player;
        if (this.plugin.inRaid && this.plugin.loadedPlayers && (player = this.client.getLocalPlayer()) != null && player.getName() != null) {
            String name = Text.sanitize((String)player.getName());
            List elems = this.panelComponent.getChildren();
            elems.clear();
            Map<String, Integer> deaths = this.plugin.getDeathCounter();
            double maxPoints = (double)deaths.size() * 18.0 + 14.0;
            double totalDeaths = 0.0;
            for (String pName : deaths.keySet()) {
                totalDeaths += (double)deaths.get(pName).intValue();
            }
            double totalLosses = totalDeaths * 4.0;
            double pointsRemaining = Math.max(0.0, maxPoints - totalLosses);
            double multiplier = pointsRemaining / maxPoints;
            double dropChance = 11.0 * multiplier;
            if (this.config.showTeamChance()) {
                elems.add(LineComponent.builder().left("Team:").right(String.format("%.2f%%", dropChance)).build());
            }
            double maxPersonal = 18.0 + 14.0 / (double)deaths.size();
            double personalLosses = 4.0 * (double)deaths.get(name).intValue();
            double personalDeaths = deaths.get(name).intValue();
            double personalRemaining = Math.max(0.0, maxPersonal - personalLosses);
            double personalChance = personalRemaining / pointsRemaining;
            if (this.config.showPersonalChance()) {
                elems.add(LineComponent.builder().left("Personal:").right(String.format("%.2f%%", 100.0 * personalChance)).build());
            }
            if (this.config.showYoinkChance()) {
                elems.add(LineComponent.builder().left("Team & Personal:").right(String.format("%.2f%%", dropChance * personalChance)).build());
            }
            if (this.config.showPersonalDeathCount()) {
                elems.add(LineComponent.builder().left("Personal Deaths:").right(String.format("%d", (int)personalDeaths)).build());
            }
            if (this.config.showDeathCount()) {
                elems.add(LineComponent.builder().left("Total Deaths:").right(String.format("%d", (int)totalDeaths)).build());
            }
        }
        return super.render(graphics);
    }
}

