/*
 * Decompiled with CFR 0.152.
 */
package com.CustomItemTags;

import com.CustomItemTags.CustomItemTagsConfig;
import com.CustomItemTags.CustomItemTagsOverlay;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom Item Tags")
public class CustomItemTagsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomItemTagsPlugin.class);
    static Collection<CustomTag> customTags = new ArrayList<CustomTag>();
    @Inject
    private Client client;
    @Inject
    private CustomItemTagsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CustomItemTagsOverlay overlay;

    @Provides
    CustomItemTagsConfig provideConfig(ConfigManager configManager) {
        return (CustomItemTagsConfig)configManager.getConfig(CustomItemTagsConfig.class);
    }

    public void reloadCustomSwaps() {
        customTags.clear();
        customTags.addAll(this.loadCustomTags(this.config.customTags()));
    }

    private Collection<? extends CustomTag> loadCustomTags(String customTags) {
        ArrayList<CustomTag> tags = new ArrayList<CustomTag>();
        for (String customTag : customTags.split("\n")) {
            if (customTag.trim().equals("")) continue;
            tags.add(CustomTag.fromString(customTag));
        }
        return tags;
    }

    protected static Collection<CustomTag> getTags() {
        return customTags;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("Custom Item Tags")) {
            this.reloadCustomSwaps();
        }
    }

    protected void startUp() {
        this.reloadCustomSwaps();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    static class CustomTag {
        public final String tag;
        public final int itemID;

        CustomTag(String tag, int itemID) {
            this.itemID = itemID;
            this.tag = tag;
        }

        public static CustomTag fromString(String s) {
            String[] split = s.split(",");
            String tag = split[0].trim();
            int ItemID = Integer.parseInt(split.length > 1 ? split[1].toLowerCase().trim() : "");
            return new CustomTag(tag, ItemID);
        }
    }
}

