/*
 * Decompiled with CFR 0.152.
 */
package com.CustomItemTags;

import com.CustomItemTags.CustomItemTagsConfig;
import com.CustomItemTags.CustomItemTagsPlugin;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.components.TextComponent;

class CustomItemTagsOverlay
extends WidgetItemOverlay {
    private final CustomItemTagsConfig config;
    private final ItemManager itemManager;
    static final Collection<CustomItemTagsPlugin.CustomTag> customTags = CustomItemTagsPlugin.getTags();

    @Inject
    CustomItemTagsOverlay(CustomItemTagsConfig config, ItemManager itemManager) {
        this.config = config;
        this.itemManager = itemManager;
        this.showOnInventory();
        this.showOnBank();
        this.showOnInterfaces(new int[]{4, 464, 81, 128, 616});
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        for (CustomItemTagsPlugin.CustomTag item : customTags) {
            if (item.itemID != itemId) continue;
            graphics.setFont(FontManager.getRunescapeSmallFont());
            this.renderText(graphics, widgetItem.getCanvasBounds(), item.tag);
            break;
        }
    }

    private void renderText(Graphics2D graphics, Rectangle bounds, String itemTag) {
        TextComponent textComponent = new TextComponent();
        textComponent.setPosition(new Point(bounds.x - 1, bounds.y + bounds.height - 1));
        textComponent.setColor(Color.white);
        textComponent.setText(itemTag);
        textComponent.render(graphics);
    }
}

