/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.LogLocked;
import com.example.LogLockedConfig;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class LogLockedOverlay
extends OverlayPanel {
    private final LogLocked plugin;
    private final LogLockedConfig config;

    @Inject
    LogLockedOverlay(LogLocked plugin, LogLockedConfig config) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.HIGH);
        this.setResizable(true);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.displayOverlay()) {
            return null;
        }
        this.panelComponent.getChildren().add(LineComponent.builder().left("Available unlocks:").right(String.valueOf(this.plugin.bankedSlots)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Slots till next:").right(String.valueOf(this.plugin.slotsTillNext)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Unlocked sections:").right(String.valueOf(this.plugin.unlockedSlots.size() - 1)).build());
        this.panelComponent.setPreferredSize(new Dimension(150, 100));
        this.panelComponent.setBorder(new Rectangle(5, 5, 5, 5));
        return super.render(graphics);
    }
}

